/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.flow;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowEdgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DataSerializer;
import org.netbeans.modules.vmd.api.io.ProjectTypeInfo;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.flow.FlowAccessController;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowDataSerializer
implements DataSerializer {
    private static final String FLOW_DOCUMENT_NODE = "FlowScene";
    private static final String VERSION_ATTR = "version";
    private static final String NODE_NODE = "Node";
    private static final String EDGE_NODE = "Edge";
    private static final String COMPONENTID_ATTR = "componentID";
    private static final String DESCRIPTORID_ATTR = "descriptorID";
    private static final String X_NODE_ATTR = "x";
    private static final String Y_NODE_ATTR = "y";
    private static final String X_EDGE_ATTR = "x";
    private static final String Y_EDGE_ATTR = "y";
    private static final String VERSION_VALUE_1 = "1";

    public Node serializeData(DataObjectContext dataObjectContext, DesignDocument designDocument, Document document) {
        ProjectTypeInfo projectTypeInfo = ProjectTypeInfo.getProjectTypeInfoFor((String)dataObjectContext.getProjectType());
        if (!projectTypeInfo.getTags().contains("flow")) {
            return null;
        }
        FlowAccessController flowAccessController = (FlowAccessController)designDocument.getListenerManager().getAccessController(FlowAccessController.class);
        FlowScene flowScene = flowAccessController.getScene();
        Element element = document.createElement(FLOW_DOCUMENT_NODE);
        FlowDataSerializer.setAttribute(document, element, VERSION_ATTR, VERSION_VALUE_1);
        Set set = flowScene.getObjects();
        for (Object e : set) {
            Object object;
            Point point;
            Widget widget;
            FlowDescriptor flowDescriptor;
            if (flowScene.isNode(e)) {
                flowDescriptor = (FlowDescriptor)e;
                widget = flowScene.findWidget(flowDescriptor);
                if (widget == null || (point = widget.getPreferredLocation()) == null) continue;
                object = document.createElement(NODE_NODE);
                FlowDataSerializer.setAttribute(document, (Node)object, COMPONENTID_ATTR, Long.toString(flowDescriptor.getRepresentedComponent().getComponentID()));
                FlowDataSerializer.setAttribute(document, (Node)object, DESCRIPTORID_ATTR, flowDescriptor.getDescriptorID());
                FlowDataSerializer.setAttribute(document, (Node)object, "x", Integer.toString(point.x));
                FlowDataSerializer.setAttribute(document, (Node)object, "y", Integer.toString(point.y));
                element.appendChild((Node)object);
                continue;
            }
            if (!flowScene.isEdge(e) || !((widget = flowScene.findWidget(flowDescriptor = (FlowDescriptor)e)) instanceof ConnectionWidget)) continue;
            point = (ConnectionWidget)widget;
            object = point.getControlPoints();
            if (point.getRoutingPolicy() != ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED || object.isEmpty()) continue;
            Element element2 = document.createElement(EDGE_NODE);
            FlowDataSerializer.setAttribute(document, element2, COMPONENTID_ATTR, Long.toString(flowDescriptor.getRepresentedComponent().getComponentID()));
            FlowDataSerializer.setAttribute(document, element2, DESCRIPTORID_ATTR, flowDescriptor.getDescriptorID());
            for (int i = 0; i < object.size(); ++i) {
                Point point2 = (Point)object.get(i);
                FlowDataSerializer.setAttribute(document, element2, "x" + i, Integer.toString(point2.x));
                FlowDataSerializer.setAttribute(document, element2, "y" + i, Integer.toString(point2.y));
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean deserializeData(DataObjectContext dataObjectContext, final DesignDocument designDocument, final Node node) {
        ProjectTypeInfo projectTypeInfo = ProjectTypeInfo.getProjectTypeInfoFor((String)dataObjectContext.getProjectType());
        if (!projectTypeInfo.getTags().contains("flow")) {
            return false;
        }
        if (!FLOW_DOCUMENT_NODE.equals(node.getNodeName())) {
            return false;
        }
        if (!VERSION_VALUE_1.equals(FlowDataSerializer.getAttributeValue(node, VERSION_ATTR))) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final FlowScene flowScene = ((FlowAccessController)designDocument.getListenerManager().getAccessController(FlowAccessController.class)).getScene();
                designDocument.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        FlowDataSerializer.this.deserializeDataVersion1(designDocument, node, flowScene);
                    }
                });
                flowScene.validate();
            }
        });
        return true;
    }

    private void deserializeDataVersion1(DesignDocument designDocument, Node node, FlowScene flowScene) {
        boolean bl = false;
        for (Node node2 : FlowDataSerializer.getChildNode(node)) {
            FlowEdgeDescriptor flowEdgeDescriptor;
            FlowNodeDescriptor flowNodeDescriptor;
            Object object;
            DesignComponent designComponent;
            String string;
            long l;
            if (NODE_NODE.equals(node2.getNodeName())) {
                int n;
                int n2;
                l = Long.parseLong(FlowDataSerializer.getAttributeValue(node2, COMPONENTID_ATTR));
                string = FlowDataSerializer.getAttributeValue(node2, DESCRIPTORID_ATTR);
                try {
                    n2 = Integer.parseInt(FlowDataSerializer.getAttributeValue(node2, "x"));
                    n = Integer.parseInt(FlowDataSerializer.getAttributeValue(node2, "y"));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                designComponent = designDocument.getComponentByUID(l);
                if (designComponent == null || string == null || (object = flowScene.findWidget(flowNodeDescriptor = new FlowNodeDescriptor(designComponent, string))) == null) continue;
                object.setPreferredLocation(new Point(n2, n));
                bl = true;
                continue;
            }
            if (!EDGE_NODE.equals(node2.getNodeName())) continue;
            l = Long.parseLong(FlowDataSerializer.getAttributeValue(node2, COMPONENTID_ATTR));
            string = FlowDataSerializer.getAttributeValue(node2, DESCRIPTORID_ATTR);
            DesignComponent designComponent2 = designDocument.getComponentByUID(l);
            if (designComponent2 == null || string == null || !((designComponent = flowScene.findWidget(flowEdgeDescriptor = new FlowEdgeDescriptor(designComponent2, string, null, false, null, false))) instanceof ConnectionWidget)) continue;
            flowNodeDescriptor = (ConnectionWidget)designComponent;
            flowNodeDescriptor.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
            object = new ArrayList();
            int n = 0;
            while (true) {
                int n3;
                int n4;
                try {
                    n4 = Integer.parseInt(FlowDataSerializer.getAttributeValue(node2, "x" + n));
                    n3 = Integer.parseInt(FlowDataSerializer.getAttributeValue(node2, "x" + n));
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                ((ArrayList)object).add(new Point(n4, n3));
                ++n;
            }
            if (((ArrayList)object).isEmpty()) continue;
            flowNodeDescriptor.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
            flowNodeDescriptor.setControlPoints((Collection)object, false);
        }
        if (!bl) {
            flowScene.layoutScene();
        }
    }

    private static String getAttributeValue(Node node, String string) {
        try {
            NamedNodeMap namedNodeMap;
            if (node != null && (namedNodeMap = node.getAttributes()) != null && (node = namedNodeMap.getNamedItem(string)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException dOMException) {
            Debug.warning((Object[])new Object[]{dOMException});
        }
        return null;
    }

    private static void setAttribute(Document document, Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        namedNodeMap.setNamedItem(attr);
    }

    private static Node[] getChildNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        Node[] nodeArray = new Node[nodeList != null ? nodeList.getLength() : 0];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = nodeList.item(i);
        }
        return nodeArray;
    }
}

