/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.MainProjectIterator;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainProjectScanningScope
extends TaskScanningScope
implements PropertyChangeListener {
    private TaskScanningScope.Callback callback;
    private InstanceContent lookupContent = new InstanceContent();
    private Lookup lookup;
    private Project currentProject;
    private Map<String, String> scopeLabels = Collections.synchronizedMap(new HashMap(3));
    private Timer refreshTimer;

    private MainProjectScanningScope(String string, String string2, Image image) {
        super(string, string2, image);
        this.extractLabelsFromProject(null, this.scopeLabels);
        this.lookupContent.add(this.scopeLabels);
    }

    public static MainProjectScanningScope create() {
        return new MainProjectScanningScope(NbBundle.getBundle(MainProjectScanningScope.class).getString("LBL_MainProjectScope"), NbBundle.getBundle(MainProjectScanningScope.class).getString("HINT_MainProjectScope"), ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/projectint/main_project_scope.png"));
    }

    public Iterator<FileObject> iterator() {
        return new MainProjectIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInScope(FileObject fileObject) {
        Project project = null;
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            project = this.currentProject;
        }
        if (null == fileObject || null == project) {
            return false;
        }
        mainProjectScanningScope = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (null == mainProjectScanningScope) {
            return false;
        }
        if (mainProjectScanningScope.equals(project)) {
            return true;
        }
        if (project.equals(OpenProjects.getDefault().getMainProject())) {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projectArray.length; ++i) {
                SubprojectProvider subprojectProvider;
                if (projectArray[i].equals(project) || null == (subprojectProvider = (SubprojectProvider)projectArray[i].getLookup().lookup(SubprojectProvider.class)) || !subprojectProvider.getSubprojects().contains(project) || !projectArray[i].equals(mainProjectScanningScope)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            if (null == this.lookup) {
                this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
            }
        }
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(TaskScanningScope.Callback callback) {
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            if (null != callback && null == this.callback) {
                OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
                Project project = OpenProjects.getDefault().getMainProject();
                if (null == project) {
                    project = MainProjectScanningScope.findCurrentProject();
                }
                this.setCurrentProject(project, false);
            } else if (null == callback && null != this.callback) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                this.setCurrentProject(null, false);
            }
            this.callback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
            MainProjectScanningScope mainProjectScanningScope = this;
            synchronized (mainProjectScanningScope) {
                if (null != this.callback) {
                    Project project = OpenProjects.getDefault().getMainProject();
                    if (null == project) {
                        project = MainProjectScanningScope.findCurrentProject();
                    } else {
                        this.setCurrentProject(null, false);
                    }
                    this.setCurrentProject(project, true);
                }
            }
        } else if ("activatedNodes".equals(propertyChangeEvent.getPropertyName())) {
            if (null != this.refreshTimer) {
                this.refreshTimer.cancel();
            }
            this.refreshTimer = new Timer();
            this.refreshTimer.schedule(new TimerTask(){

                public void run() {
                    Project project = OpenProjects.getDefault().getMainProject();
                    if (null == project) {
                        project = MainProjectScanningScope.findCurrentProject();
                        MainProjectScanningScope.this.setCurrentProject(project, true);
                    }
                }
            }, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentProject(Project project, boolean bl) {
        MainProjectScanningScope mainProjectScanningScope = this;
        synchronized (mainProjectScanningScope) {
            if (null == project && null == this.currentProject || null != this.currentProject && this.currentProject.equals(project)) {
                return;
            }
            if (null != this.currentProject) {
                this.lookupContent.remove((Object)this.currentProject);
            }
            if (null != project) {
                this.lookupContent.add((Object)project);
            }
            this.extractLabelsFromProject(project, this.scopeLabels);
            this.currentProject = project;
        }
        if (bl && null != this.callback) {
            this.callback.refresh();
        }
    }

    private void extractLabelsFromProject(Project project, Map<String, String> map) {
        map.clear();
        if (null == project) {
            map.put("StatusBarLabel", NbBundle.getMessage(MainProjectScanningScope.class, (String)"LBL_NoProjectStatusBar"));
        } else {
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            if (project.equals(OpenProjects.getDefault().getMainProject())) {
                map.put("StatusBarLabel", NbBundle.getMessage(MainProjectScanningScope.class, (String)"LBL_MainProjectStatusBar"));
            } else {
                map.put("ShortDescription", NbBundle.getMessage(MainProjectScanningScope.class, (String)"HINT_CurrentProjectScope", (Object)projectInformation.getDisplayName()));
                map.put("Name", projectInformation.getDisplayName());
                map.put("StatusBarLabel", NbBundle.getMessage(MainProjectScanningScope.class, (String)"LBL_CurrentProjectStatusBar", (Object)projectInformation.getDisplayName()));
            }
        }
    }

    static Project findCurrentProject() {
        Node[] nodeArray;
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Node node : nodeArray = TopComponent.getRegistry().getActivatedNodes()) {
            for (Project project : node.getLookup().lookupAll(Project.class)) {
                hashSet.add(project);
                if (hashSet.size() <= 1) continue;
                return null;
            }
            for (Project project : node.getLookup().lookupAll(DataObject.class)) {
                FileObject fileObject = project.getPrimaryFile();
                Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project2 == null) continue;
                hashSet.add(project2);
                if (hashSet.size() <= 1) continue;
                return null;
            }
        }
        return hashSet.isEmpty() ? null : (Project)new ArrayList(hashSet).get(0);
    }
}

