/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.DefaultCategory;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.RootNode;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.ui.Customizer;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;

public class DefaultModel
implements Model,
NodeListener {
    private RootNode rootNode;
    private Item selectedItem;
    private Category selectedCategory;
    private PropertyChangeSupport propertySupport;
    private ArrayList<ModelListener> modelListeners = new ArrayList(3);
    private boolean categoriesNeedRefresh = true;
    private Category[] categories;
    private boolean isRefreshingChildren = false;

    public DefaultModel(RootNode rootNode) {
        this.rootNode = rootNode;
        this.propertySupport = new PropertyChangeSupport(this);
        this.rootNode.addNodeListener(this);
    }

    public void setSelectedItem(Lookup lookup, Lookup lookup2) {
        Object object;
        Category category = null;
        Item item = null;
        if (null != lookup && null != (object = (Node)lookup.lookup(Node.class))) {
            category = this.findCategory((Node)object);
        }
        if (null != lookup2 && null != category && null != (object = (Node)lookup2.lookup(Node.class))) {
            item = this.findItem(category, (Node)object);
        }
        object = this.selectedItem;
        this.selectedItem = item;
        this.selectedCategory = category;
        this.propertySupport.firePropertyChange("selectedItem", object, this.selectedItem);
    }

    public void clearSelection() {
        this.setSelectedItem(null, null);
    }

    public Action[] getActions() {
        return this.rootNode.getActions(false);
    }

    public Item getSelectedItem() {
        return this.selectedItem;
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        ArrayList<ModelListener> arrayList = this.modelListeners;
        synchronized (arrayList) {
            this.modelListeners.add(modelListener);
            this.propertySupport.addPropertyChangeListener(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        ArrayList<ModelListener> arrayList = this.modelListeners;
        synchronized (arrayList) {
            this.modelListeners.remove(modelListener);
            this.propertySupport.removePropertyChangeListener(modelListener);
        }
    }

    public synchronized Category[] getCategories() {
        if (null == this.categories || this.categoriesNeedRefresh) {
            Node[] nodeArray = this.rootNode.getChildren().getNodes(DefaultModel.canBlock());
            this.categories = this.nodes2categories(nodeArray);
            this.categoriesNeedRefresh = false;
        }
        return this.categories;
    }

    public static boolean canBlock() {
        return !Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess();
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        this.categoriesNeedRefresh = true;
        if (this.isRefreshingChildren) {
            return;
        }
        final Node[] nodeArray = nodeMemberEvent.getDelta();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Category[] categoryArray = DefaultModel.this.findCategories(nodeArray);
                DefaultModel.this.fireCategoriesChanged(categoryArray, true);
            }
        });
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        this.categoriesNeedRefresh = true;
        final Node[] nodeArray = nodeMemberEvent.getDelta();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Category[] categoryArray = DefaultModel.this.findCategories(nodeArray);
                DefaultModel.this.fireCategoriesChanged(categoryArray, false);
            }
        });
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        this.categoriesNeedRefresh = true;
        this.fireCategoriesChanged(null, false);
    }

    public synchronized void nodeDestroyed(NodeEvent nodeEvent) {
        this.rootNode.removeNodeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCategoriesChanged(Category[] categoryArray, boolean bl) {
        ModelListener[] modelListenerArray;
        ArrayList<ModelListener> arrayList = this.modelListeners;
        synchronized (arrayList) {
            modelListenerArray = new ModelListener[this.modelListeners.size()];
            modelListenerArray = this.modelListeners.toArray(modelListenerArray);
        }
        for (int i = 0; i < modelListenerArray.length; ++i) {
            if (null != categoryArray) {
                if (bl) {
                    modelListenerArray[i].categoriesAdded(categoryArray);
                    continue;
                }
                modelListenerArray[i].categoriesRemoved(categoryArray);
                continue;
            }
            modelListenerArray[i].categoriesReordered();
        }
    }

    private Category[] nodes2categories(Node[] nodeArray) {
        Category[] categoryArray = new Category[nodeArray.length];
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i] = new DefaultCategory(nodeArray[i]);
        }
        return categoryArray;
    }

    private Category[] findCategories(Node[] nodeArray) {
        Category[] categoryArray = new Category[nodeArray.length];
        Category[] categoryArray2 = this.getCategories();
        for (int i = 0; i < categoryArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; !bl && null != categoryArray2 && j < categoryArray2.length; ++j) {
                Node node = (Node)categoryArray2[j].getLookup().lookup(Node.class);
                if (!nodeArray[i].equals((Object)node)) continue;
                categoryArray[i] = categoryArray2[j];
                bl = true;
            }
            if (bl) continue;
            categoryArray[i] = new DefaultCategory(nodeArray[i]);
        }
        return categoryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        RootNode rootNode = this.rootNode;
        synchronized (rootNode) {
            PaletteActions paletteActions = (PaletteActions)this.rootNode.getLookup().lookup(PaletteActions.class);
            Action action = paletteActions.getRefreshAction();
            if (null != action) {
                action.actionPerformed(new ActionEvent(this.getRoot(), 0, "refresh"));
            }
            this.clearSelection();
            this.categoriesNeedRefresh = true;
            this.isRefreshingChildren = true;
            try {
                this.rootNode.refreshChildren();
            }
            finally {
                this.isRefreshingChildren = false;
            }
            this.fireCategoriesChanged(null, false);
        }
    }

    public void showCustomizer(PaletteController paletteController, Settings settings) {
        Customizer.show((Node)this.rootNode, paletteController, settings);
    }

    public Lookup getRoot() {
        return this.rootNode.getLookup();
    }

    public boolean moveCategory(Category category, Category category2, boolean bl) {
        int n = this.categoryToIndex(category2);
        if (!bl) {
            ++n;
        }
        DragAndDropHandler dragAndDropHandler = this.getDragAndDropHandler();
        return dragAndDropHandler.moveCategory(category.getLookup(), n);
    }

    private int categoryToIndex(Category category) {
        Index index;
        Node node = (Node)category.getLookup().lookup(Node.class);
        if (null != node && null != (index = (Index)this.rootNode.getCookie(Index.class))) {
            return index.indexOf(node);
        }
        return -1;
    }

    public String getName() {
        return this.rootNode.getName();
    }

    private Category findCategory(Node node) {
        Category[] categoryArray = this.getCategories();
        for (int i = 0; i < categoryArray.length; ++i) {
            Node node2 = (Node)categoryArray[i].getLookup().lookup(Node.class);
            if (null == node2 || !node2.equals((Object)node)) continue;
            return categoryArray[i];
        }
        return null;
    }

    private Item findItem(Category category, Node node) {
        Item[] itemArray = category.getItems();
        for (int i = 0; i < itemArray.length; ++i) {
            Node node2 = (Node)itemArray[i].getLookup().lookup(Node.class);
            if (null == node2 || !node2.equals((Object)node)) continue;
            return itemArray[i];
        }
        return null;
    }

    public boolean canReorderCategories() {
        return this.getDragAndDropHandler().canReorderCategories(this.rootNode.getLookup());
    }

    private DragAndDropHandler getDragAndDropHandler() {
        return (DragAndDropHandler)this.rootNode.getLookup().lookup(DragAndDropHandler.class);
    }
}

