/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.discovery.projectimport.ReconfigurePanel;
import org.netbeans.modules.cnd.discovery.projectimport.ReconfigureProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;

public class ReconfigureAction
extends NodeAction {
    private static final boolean TEST_ACTION = true;
    private JMenuItem presenter;
    private boolean inited = false;
    private static boolean running = false;

    public static Action getReconfigureAction() {
        return (Action)SharedClassObject.findObject(ReconfigureAction.class, (boolean)true);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ReconfigureAction");
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        Project project;
        if (!this.inited) {
            this.presenter = new JMenuItem();
            Actions.connect((JMenuItem)this.presenter, (Action)((Object)this), (boolean)true);
            this.inited = true;
        }
        if ((project = this.getProject(this.getActivatedNodes())) == null) {
            this.setEnabled(!running);
            this.presenter.setVisible(false);
        } else {
            try {
                this.presenter.setVisible(true);
                this.setEnabled(!running);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setEnabled(false);
            }
        }
        return this.presenter;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        Project project = this.getProject(nodeArray);
        if (project == null) {
            return false;
        }
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider == null || !configurationDescriptorProvider.gotDescriptor()) {
            return false;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return false;
        }
        MakeConfiguration makeConfiguration = makeConfigurationDescriptor.getActiveConfiguration();
        if (makeConfiguration == null || makeConfiguration.getConfigurationType().getValue() != 0) {
            return false;
        }
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        if (compilerSet2Configuration == null) {
            return false;
        }
        CompilerSet compilerSet = compilerSet2Configuration.getCompilerSet();
        return compilerSet != null;
    }

    public void performAction(Node[] nodeArray) {
        String string;
        String string2;
        running = true;
        Project project = this.getProject(nodeArray);
        ReconfigureProject reconfigureProject = new ReconfigureProject(project);
        String string3 = "";
        if (reconfigureProject.isSunCompiler()) {
            string2 = "-g";
            string = "-g";
        } else {
            string2 = "-g3 -gdwarf-2";
            string = "-g3 -gdwarf-2";
        }
        ReconfigurePanel reconfigurePanel = new ReconfigurePanel(string2, string, string3, reconfigureProject.getRestOptions(), this.getLegend(reconfigureProject), reconfigureProject.getCompilerSet().getDisplayName());
        JButton jButton = new JButton(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureButton"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureButtonAD"));
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)reconfigurePanel, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureDialogTitle"), true, objectArray, (Object)jButton, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == jButton) {
            reconfigureProject.reconfigure(reconfigurePanel.getCFlags(), reconfigurePanel.getCppFlags(), reconfigurePanel.getLinkerFlags(), reconfigurePanel.getOtherOptions(), false, null);
        }
        running = false;
    }

    private String getLegend(ReconfigureProject reconfigureProject) {
        ReconfigureProject.CompilerOptions compilerOptions = reconfigureProject.getLastCompilerOptions();
        if (compilerOptions != null && compilerOptions.CFlags != null && compilerOptions.CppFlags != null && compilerOptions.CCompiler != null && compilerOptions.CppCompiler != null) {
            String string = compilerOptions.LinkerFlags == null ? "" : compilerOptions.LinkerFlags;
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureLegend", (Object)compilerOptions.CCompiler, (Object)compilerOptions.CppCompiler, (Object)compilerOptions.CFlags, (Object)compilerOptions.CppFlags, (Object[])new Object[]{string});
        }
        return "";
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Project getProject(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return null;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            Project project = (Project)nodeArray[i].getLookup().lookup(Project.class);
            if (project == null) continue;
            return project;
        }
        return null;
    }
}

