/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final RubyProject project;
    private static EditableProperties origPrivateProperties;

    public RubyProjectOperations(RubyProject rubyProject) {
        this.project = rubyProject;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        RubyProjectOperations.addFile(fileObject, "nbproject", arrayList);
        RubyProjectOperations.addFile(fileObject, "README", arrayList);
        RubyProjectOperations.addFile(fileObject, "LICENSE", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        arrayList.addAll(Arrays.asList(this.project.getSourceRoots().getRoots()));
        arrayList.addAll(Arrays.asList(this.project.getTestSourceRoots().getRoots()));
        RubyProjectOperations.addFile(this.project.getProjectDirectory(), "Rakefile", arrayList);
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        this.project.getRakeProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        origPrivateProperties = this.project.getRakeProjectHelper().getProperties("nbproject/private/private.properties");
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(file);
        this.project.setName(string);
        this.copyPrivateProps();
    }

    public void notifyMoving() throws IOException {
        origPrivateProperties = this.project.getRakeProjectHelper().getProperties("nbproject/private/private.properties");
        if (!this.project.getUpdateHelper().requestSave()) {
            throw new IOException(NbBundle.getMessage(RubyProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, String string) {
        if (project == null) {
            this.project.getRakeProjectHelper().notifyDeleted();
            return;
        }
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
        this.copyPrivateProps();
    }

    private void copyPrivateProps() {
        this.project.getReferenceHelper().copyToPrivateProperties(origPrivateProperties);
        origPrivateProperties = null;
    }
}

