/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsType {
    private static final Logger LOG = Logger.getLogger(SettingsType.class.getName());

    public static <K, V> StorageDescription<K, V> find(String string) {
        assert (string != null) : "The parameter id can't be null";
        StorageDescription storageDescription = Cache.getInstance().find(string);
        return storageDescription;
    }

    public static Locator getLocator(StorageDescription storageDescription) {
        assert (storageDescription != null) : "The parameter sd can't be null";
        DefaultLocator defaultLocator = "FontsColors".equals(storageDescription.getId()) ? new FontsColorsLocator(storageDescription.getId(), storageDescription.isUsingProfiles(), storageDescription.getMimeType(), storageDescription.getLegacyFileName()) : ("Keybindings".equals(storageDescription.getId()) || "Preferences".equals(storageDescription.getId()) ? new LegacyTextBaseLocator(storageDescription.getId(), storageDescription.isUsingProfiles(), storageDescription.getMimeType(), storageDescription.getLegacyFileName()) : new DefaultLocator(storageDescription.getId(), storageDescription.isUsingProfiles(), storageDescription.getMimeType(), storageDescription.getLegacyFileName()));
        return defaultLocator;
    }

    private SettingsType() {
    }

    private static final class LegacyTextBaseLocator
    extends DefaultLocator {
        public LegacyTextBaseLocator(String string, boolean bl, String string2, String string3) {
            super(string, bl, string2, string3);
        }

        protected FileObject getLegacyMimeFolder(FileObject fileObject, String string) {
            if (string == null || string.length() == 0) {
                return fileObject.getFileObject("text/base");
            }
            return ((DefaultLocator)this).getMimeFolder(fileObject, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FontsColorsLocator
    extends DefaultLocator {
        private static final String[] M_LEGACY_FILE_NAMES = new String[]{"Defaults/defaultColoring.xml", "Defaults/coloring.xml", "Defaults/editorColoring.xml"};
        private static final String[] U_LEGACY_FILE_NAMES = new String[]{"defaultColoring.xml", "coloring.xml", "editorColoring.xml"};

        public FontsColorsLocator(String string, boolean bl, String string2, String string3) {
            super(string, bl, string2, string3);
        }

        @Override
        protected void addModulesLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            this.addFiles(fileObject, string, bl, M_LEGACY_FILE_NAMES, map, true);
        }

        @Override
        protected void addUsersLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            this.addFiles(fileObject, string, bl, U_LEGACY_FILE_NAMES, map, false);
        }

        private void addFiles(FileObject fileObject, String string, boolean bl, String[] stringArray, Map<String, List<Object[]>> map, boolean bl2) {
            if (string == null) {
                FileObject[] fileObjectArray;
                for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                    if (!fileObject2.isFolder()) continue;
                    String string2 = fileObject2.getNameExt();
                    this.addFiles(fileObject2, stringArray, bl, map, string2, fileObject2, bl2);
                }
            } else {
                FileObject fileObject3 = fileObject.getFileObject(string);
                if (fileObject3 != null && fileObject3.isFolder()) {
                    this.addFiles(fileObject3, stringArray, bl, map, string, fileObject3, bl2);
                }
            }
        }

        private void addFiles(FileObject fileObject, String[] stringArray, boolean bl, Map<String, List<Object[]>> map, String string, FileObject fileObject2, boolean bl2) {
            for (String string2 : stringArray) {
                FileObject fileObject3 = fileObject.getFileObject(string2);
                if (fileObject3 == null) continue;
                List<Object[]> list = map.get(string);
                if (list == null) {
                    list = new ArrayList<Object[]>();
                    map.put(string, list);
                }
                list.add(new Object[]{fileObject2, fileObject3, bl2, null, true});
                if (LOG.isLoggable(Level.INFO)) {
                    Utils.logOnce(LOG, Level.INFO, this.settingTypeId + " settings " + "should reside in '" + this.settingTypeId + "' subfolder, " + "see #90403 for details. Offending file '" + fileObject3.getPath() + "'", null);
                }
                if (!bl) break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultLocator
    implements Locator {
        protected static final String MODULE_FILES_FOLDER = "Defaults";
        protected static final String DEFAULT_PROFILE_NAME = "NetBeans";
        private static final String WRITABLE_FILE_PREFIX = "org-netbeans-modules-editor-settings-Custom";
        private static final String WRITABLE_FILE_SUFFIX = ".xml";
        private static final String FA_TARGET_OS = "nbeditor-settings-targetOS";
        private static final String LINK_EXTENSION = "shadow";
        protected final String settingTypeId;
        protected final boolean isUsingProfiles;
        protected final String mimeType;
        protected final String legacyFileName;
        protected final String writableFilePrefix;
        protected final String modulesWritableFilePrefix;
        protected final ThreadLocal<FileObject> threadsBaseFolder = new ThreadLocal();

        public DefaultLocator(String string, boolean bl, String string2, String string3) {
            this.settingTypeId = string;
            this.isUsingProfiles = bl;
            this.mimeType = string2;
            this.legacyFileName = string3;
            this.writableFilePrefix = WRITABLE_FILE_PREFIX + string;
            this.modulesWritableFilePrefix = "Defaults/" + this.writableFilePrefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void scan(FileObject fileObject, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map<String, List<Object[]>> map) {
            assert (map != null) : "The parameter results can't be null";
            this.threadsBaseFolder.set(fileObject);
            try {
                FileObject fileObject2 = null;
                FileObject fileObject3 = null;
                if (fileObject != null) {
                    fileObject2 = this.getMimeFolder(fileObject, string);
                    fileObject3 = this.getLegacyMimeFolder(fileObject, string);
                }
                if (bl2) {
                    if (fileObject3 != null && fileObject3.isFolder()) {
                        this.addModulesLegacyFiles(fileObject3, string2, bl, map);
                    }
                    if (fileObject2 != null && fileObject2.isFolder()) {
                        this.addModulesFiles(fileObject2, string2, bl, map, bl4);
                    }
                }
                if (bl3) {
                    if (fileObject3 != null && fileObject3.isFolder()) {
                        this.addUsersLegacyFiles(fileObject3, string2, bl, map);
                    }
                    if (fileObject2 != null && fileObject2.isFolder()) {
                        this.addUsersFiles(fileObject2, string2, bl, map);
                    }
                }
            }
            finally {
                this.threadsBaseFolder.remove();
            }
        }

        @Override
        public final String getWritableFileName(String string, String string2, String string3, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(127);
            if (string == null || string.length() == 0) {
                stringBuilder.append(this.settingTypeId).append('/');
            } else {
                stringBuilder.append(string).append('/').append(this.settingTypeId).append('/');
            }
            if (this.isUsingProfiles) {
                assert (string2 != null) : "The profileId parameter must not be null";
                stringBuilder.append(string2).append('/');
            }
            if (bl) {
                stringBuilder.append(this.modulesWritableFilePrefix);
            } else {
                stringBuilder.append(this.writableFilePrefix);
            }
            if (string3 != null && string3.length() != 0) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(WRITABLE_FILE_SUFFIX);
            return stringBuilder.toString();
        }

        @Override
        public final boolean isUsingProfiles() {
            return this.isUsingProfiles;
        }

        protected FileObject getLegacyMimeFolder(FileObject fileObject, String string) {
            return string == null ? fileObject : fileObject.getFileObject(string);
        }

        protected void addModulesLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (this.legacyFileName != null) {
                this.addLegacyFiles(fileObject, string, "Defaults/" + this.legacyFileName, map, true);
            }
        }

        protected void addUsersLegacyFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (this.legacyFileName != null) {
                this.addLegacyFiles(fileObject, string, this.legacyFileName, map, true);
            }
        }

        private FileObject getMimeFolder(FileObject fileObject, String string) {
            return string == null ? fileObject : fileObject.getFileObject(string);
        }

        private void addModulesFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map, boolean bl2) {
            if (string == null) {
                FileObject fileObject2 = fileObject.getFileObject(this.settingTypeId);
                if (fileObject2 != null && fileObject2.isFolder()) {
                    if (this.isUsingProfiles) {
                        FileObject[] fileObjectArray;
                        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
                            if (!fileObject3.isFolder()) continue;
                            String string2 = fileObject3.getNameExt();
                            FileObject fileObject4 = fileObject3.getFileObject(MODULE_FILES_FOLDER);
                            if (fileObject4 == null || !fileObject4.isFolder()) continue;
                            this.addFiles(fileObject4, bl, map, string2, fileObject3, true, bl2);
                        }
                    } else {
                        FileObject fileObject5 = fileObject2.getFileObject(MODULE_FILES_FOLDER);
                        if (fileObject5 != null && fileObject5.isFolder()) {
                            this.addFiles(fileObject5, bl, map, null, null, true, bl2);
                        }
                    }
                }
            } else {
                FileObject fileObject6 = fileObject.getFileObject(this.settingTypeId + "/" + string + "/" + MODULE_FILES_FOLDER);
                if (fileObject6 != null && fileObject6.isFolder()) {
                    this.addFiles(fileObject6, bl, map, string, fileObject6.getParent(), true, bl2);
                }
            }
        }

        private void addUsersFiles(FileObject fileObject, String string, boolean bl, Map<String, List<Object[]>> map) {
            if (string == null) {
                FileObject fileObject2 = fileObject.getFileObject(this.settingTypeId);
                if (fileObject2 != null && fileObject2.isFolder()) {
                    if (this.isUsingProfiles) {
                        FileObject[] fileObjectArray;
                        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
                            if (!fileObject3.isFolder()) continue;
                            String string2 = fileObject3.getNameExt();
                            this.addFiles(fileObject3, bl, map, string2, fileObject3, false, false);
                        }
                    } else {
                        this.addFiles(fileObject2, bl, map, null, null, false, false);
                    }
                }
            } else {
                FileObject fileObject4 = fileObject.getFileObject(this.settingTypeId + "/" + string);
                if (fileObject4 != null && fileObject4.isFolder()) {
                    this.addFiles(fileObject4, bl, map, string, fileObject4, false, false);
                }
            }
        }

        private final void addFiles(FileObject fileObject, boolean bl, Map<String, List<Object[]>> map, String string, FileObject fileObject2, boolean bl2, boolean bl3) {
            List<Object[]> list;
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
            List list2 = FileUtil.getOrder(Arrays.asList(fileObject.getChildren()), (boolean)false);
            for (FileObject fileObject3 : list2) {
                Object[] objectArray;
                List<Object[]> list3;
                Object object;
                if (!fileObject3.isData()) continue;
                if (bl3 && LINK_EXTENSION.equals(fileObject3.getExt())) {
                    object = this.resolveLink(fileObject3);
                    if (object == null) continue;
                    list3 = map.get(string);
                    if (list3 == null) {
                        list3 = new ArrayList<Object[]>();
                        map.put(string, list3);
                    }
                    objectArray = new Object[]{fileObject2, fileObject3, true, object, false};
                    list3.add(objectArray);
                    continue;
                }
                if (this.mimeType.equals(FileUtil.getMIMEType((FileObject)fileObject3, (String[])new String[]{this.mimeType}))) {
                    block17: {
                        object = fileObject3.getAttribute(FA_TARGET_OS);
                        if (object != null) {
                            try {
                                if (!this.isApplicableForThisTargetOs(object)) {
                                    LOG.fine("Ignoring OS specific file: '" + fileObject3.getPath() + "', it's targetted for '" + object + "'");
                                }
                                break block17;
                            }
                            catch (Exception exception) {
                                LOG.log(Level.WARNING, "Ignoring editor settings file with invalid OS type mask '" + object + "' file: '" + fileObject3.getPath() + "'");
                            }
                            continue;
                        }
                    }
                    if ((list3 = map.get(string)) == null) {
                        list3 = new ArrayList<Object[]>();
                        map.put(string, list3);
                    }
                    objectArray = new Object[]{fileObject2, fileObject3, bl2, null, false};
                    if (bl2) {
                        if (fileObject3.getNameExt().startsWith(this.writableFilePrefix)) {
                            arrayList.add(objectArray);
                        } else if (object != null) {
                            arrayList2.add(objectArray);
                        } else {
                            list3.add(objectArray);
                        }
                    } else {
                        list3.add(objectArray);
                    }
                    if (bl) continue;
                    break;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Ignoring file: '" + fileObject3.getPath() + "' of type " + fileObject3.getMIMEType());
            }
            if (!arrayList2.isEmpty()) {
                list = map.get(string);
                list.addAll(arrayList2);
            }
            if (!arrayList.isEmpty()) {
                list = map.get(string);
                list.addAll(arrayList);
            }
        }

        private boolean isApplicableForThisTargetOs(Object object) throws NoSuchFieldException, IllegalAccessException {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                Field field = Utilities.class.getDeclaredField((String)object);
                int n = field.getInt(null);
                int n2 = Utilities.getOperatingSystem();
                return (n2 & n) != 0;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileObject resolveLink(FileObject fileObject) {
            Object object;
            Object object2;
            block24: {
                String string = null;
                String string2 = null;
                if (fileObject.getSize() == 0L) {
                    object2 = fileObject.getAttribute("originalFile");
                    if (object2 instanceof String) {
                        string = (String)object2;
                    } else if (object2 instanceof URL) {
                        string = ((URL)object2).toExternalForm();
                    } else {
                        LOG.warning("Invalid originalFile '" + object2 + "', ignoring editor settings link " + fileObject.getPath());
                    }
                    object = fileObject.getAttribute("originalFileSystem");
                    if (object instanceof String) {
                        string2 = (String)object;
                    }
                } else {
                    try {
                        object2 = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
                        try {
                            string = ((BufferedReader)object2).readLine();
                            string2 = ((BufferedReader)object2).readLine();
                        }
                        finally {
                            ((BufferedReader)object2).close();
                        }
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, "Can't read editor settings link, ignoring " + fileObject.getPath(), iOException);
                        string = null;
                    }
                }
                if (string2 != null && !string2.equals("SystemFileSystem")) {
                    LOG.warning("Editor settings links can only link targets on SystemFileSystem, ignoring link " + fileObject.getPath());
                    string = null;
                }
                object2 = null;
                if (string != null) {
                    try {
                        object = new URI(string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        object = null;
                    }
                    if (object != null && ((URI)object).isAbsolute()) {
                        try {
                            FileObject fileObject2 = URLMapper.findFileObject((URL)((URI)object).toURL());
                            if (fileObject2 == null) break block24;
                            if (fileObject2.getFileSystem().isDefault()) {
                                object2 = fileObject2;
                                break block24;
                            }
                            LOG.warning("Editor settings links can only link targets on SystemFileSystem, ignoring link " + fileObject.getPath());
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, "Can't resolve editor settings link, ignoring link " + fileObject.getPath(), iOException);
                        }
                    } else {
                        object2 = FileUtil.getConfigFile((String)string);
                    }
                }
            }
            if (object2 != null) {
                object = this.threadsBaseFolder.get();
                if (!object2.isFolder() || object2 == object || !FileUtil.isParentOf((FileObject)object, (FileObject)object2)) {
                    LOG.warning("Editor settings link '" + fileObject.getPath() + "' is not pointing to " + "a real subfolder of '" + object.getPath() + "', but to '" + object2.getPath() + "'. Ignoring the link.");
                    object2 = null;
                }
            }
            return object2;
        }

        private void addLegacyFiles(FileObject fileObject, String string, String string2, Map<String, List<Object[]>> map, boolean bl) {
            if (string == null) {
                String string3;
                FileObject fileObject2;
                if (this.isUsingProfiles) {
                    for (FileObject fileObject3 : fileObject2 = fileObject.getChildren()) {
                        if (!fileObject3.isFolder() || fileObject3.getNameExt().equals(MODULE_FILES_FOLDER)) continue;
                        String string4 = fileObject3.getNameExt();
                        FileObject fileObject4 = fileObject3.getFileObject(string2);
                        if (fileObject4 == null) continue;
                        this.addFile(fileObject4, map, string4, fileObject3, true);
                    }
                    string3 = DEFAULT_PROFILE_NAME;
                } else {
                    string3 = null;
                }
                fileObject2 = fileObject.getFileObject(string2);
                if (fileObject2 != null) {
                    this.addFile(fileObject2, map, string3, null, true);
                }
            } else if (string.equals(DEFAULT_PROFILE_NAME)) {
                FileObject fileObject5 = fileObject.getFileObject(string2);
                if (fileObject5 != null) {
                    this.addFile(fileObject5, map, string, null, bl);
                }
            } else {
                FileObject fileObject6;
                FileObject fileObject7 = fileObject.getFileObject(string);
                if (fileObject7 != null && fileObject7.isFolder() && (fileObject6 = fileObject7.getFileObject(string2)) != null) {
                    this.addFile(fileObject6, map, string, fileObject7, bl);
                }
            }
        }

        private void addFile(FileObject fileObject, Map<String, List<Object[]>> map, String string, FileObject fileObject2, boolean bl) {
            List<Object[]> list = map.get(string);
            if (list == null) {
                list = new ArrayList<Object[]>();
                map.put(string, list);
            }
            list.add(new Object[]{fileObject2, fileObject, bl, null, true});
            if (LOG.isLoggable(Level.INFO)) {
                Utils.logOnce(LOG, Level.INFO, this.settingTypeId + " settings " + "should reside in '" + this.settingTypeId + "' subfolder, " + "see #90403 for details. Offending file '" + fileObject.getPath() + "'", null);
            }
        }
    }

    static final class Cache
    implements LookupListener {
        private static Cache INSTANCE = null;
        private final Lookup.Result<StorageDescription> lookupResult;
        private final Map<String, StorageDescription> cache = new HashMap<String, StorageDescription>();

        public static synchronized Cache getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new Cache();
            }
            return INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StorageDescription find(String string) {
            Map<String, StorageDescription> map = this.cache;
            synchronized (map) {
                return this.cache.get(string);
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.rebuild();
        }

        private Cache() {
            this.lookupResult = Lookup.getDefault().lookupResult(StorageDescription.class);
            this.rebuild();
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rebuild() {
            Map<String, StorageDescription> map = this.cache;
            synchronized (map) {
                Collection collection = this.lookupResult.allInstances();
                HashSet<String> hashSet = new HashSet<String>();
                for (StorageDescription storageDescription : collection) {
                    hashSet.add(storageDescription.getId());
                }
                this.cache.keySet().retainAll(hashSet);
                for (StorageDescription storageDescription : collection) {
                    if (this.cache.containsKey(storageDescription.getId())) continue;
                    this.cache.put(storageDescription.getId(), storageDescription);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Locator {
        public void scan(FileObject var1, String var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7, Map<String, List<Object[]>> var8);

        public String getWritableFileName(String var1, String var2, String var3, boolean var4);

        public boolean isUsingProfiles();
    }
}

