/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.java.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaElementHandler {
    private static final Logger LOG = Logger.getLogger(MetaElementHandler.class.getName());
    private final ParserResult info;

    private MetaElementHandler(ParserResult parserResult) {
        this.info = parserResult;
    }

    public static MetaElementHandler forCompilationInfo(ParserResult parserResult) {
        return new MetaElementHandler(parserResult);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(String string, String string2, int n, boolean bl) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.FINE, "Class.forName() failed: {0}", classNotFoundException.getMessage());
            return Collections.emptyMap();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.log(Level.FINE, "Class.forName() failed: {0}", noClassDefFoundError.getMessage());
            return Collections.emptyMap();
        }
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        if (metaClass != null) {
            HashMap<MethodSignature, CompletionItem.MetaMethodItem> hashMap = new HashMap<MethodSignature, CompletionItem.MetaMethodItem>();
            LOG.log(Level.FINEST, "Adding groovy methods --------------------------");
            for (MetaMethod metaMethod : metaClass.getMetaMethods()) {
                LOG.log(Level.FINEST, ((Object)metaMethod).toString());
                this.populateProposal(clazz, metaMethod, string2, n, hashMap, bl);
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(String string, String string2, int n) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.FINEST, "Class.forName() failed: {0}", classNotFoundException.getMessage());
            return Collections.emptyMap();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.log(Level.FINEST, "Class.forName() failed: {0}", noClassDefFoundError.getMessage());
            return Collections.emptyMap();
        }
        MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        if (metaClass != null) {
            HashMap<FieldSignature, CompletionItem.FieldItem> hashMap = new HashMap<FieldSignature, CompletionItem.FieldItem>();
            LOG.log(Level.FINEST, "Adding groovy methods --------------------------");
            for (MetaProperty metaProperty : metaClass.getProperties()) {
                LOG.log(Level.FINEST, metaProperty.toString());
                MetaProperty metaProperty2 = metaProperty;
                if (!metaProperty2.getName().startsWith(string2)) continue;
                hashMap.put(new FieldSignature(metaProperty2.getName()), new CompletionItem.FieldItem(metaProperty2.getName(), metaProperty2.getModifiers(), n, this.info, metaProperty2.getType().getSimpleName()));
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private void populateProposal(Class clazz, Object object, String string, int n, Map<MethodSignature, CompletionItem.MetaMethodItem> map, boolean bl) {
        MetaMethod metaMethod;
        if (object != null && object instanceof MetaMethod && (metaMethod = (MetaMethod)object).getName().startsWith(string)) {
            LOG.log(Level.FINEST, "Found matching method: {0}", metaMethod.getName());
            CompletionItem.MetaMethodItem metaMethodItem = new CompletionItem.MetaMethodItem(clazz, metaMethod, n, true, bl);
            this.addOrReplaceItem(map, metaMethodItem);
        }
    }

    private void addOrReplaceItem(Map<MethodSignature, CompletionItem.MetaMethodItem> map, CompletionItem.MetaMethodItem metaMethodItem) {
        MetaMethod metaMethod = metaMethodItem.getMethod();
        int n = metaMethod.getDeclaringClass().getSuperClassDistance();
        for (CompletionItem.MetaMethodItem metaMethodItem2 : map.values()) {
            MetaMethod metaMethod2 = metaMethodItem2.getMethod();
            if (!metaMethod2.getName().equals(metaMethod.getName()) || !MetaElementHandler.isSame(metaMethod2, metaMethod)) continue;
            if (metaMethod2.getReturnType().isAssignableFrom(metaMethod.getReturnType()) && metaMethod2.getDeclaringClass().getSuperClassDistance() <= n) {
                LOG.log(Level.FINEST, "Remove existing method: {0}", metaMethod.getName());
                map.remove(this.getSignature(metaMethod2));
                break;
            }
            LOG.log(Level.FINEST, "Not removing existing method: {0}", metaMethod2.getName());
            return;
        }
        map.put(this.getSignature(metaMethod), metaMethodItem);
    }

    private static boolean isSame(MetaMethod metaMethod, MetaMethod metaMethod2) {
        if (!metaMethod.getName().equals(metaMethod2.getName())) {
            return false;
        }
        int n = 15;
        if ((metaMethod.getModifiers() & n) != (metaMethod2.getModifiers() & n)) {
            return false;
        }
        return MetaElementHandler.isSame(metaMethod.getParameterTypes(), metaMethod2.getParameterTypes());
    }

    private static boolean isSame(CachedClass[] cachedClassArray, CachedClass[] cachedClassArray2) {
        if (cachedClassArray.length == cachedClassArray2.length) {
            int n = cachedClassArray.length;
            for (int i = 0; i < n; ++i) {
                if (cachedClassArray[i] == cachedClassArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private MethodSignature getSignature(MetaMethod metaMethod) {
        String[] stringArray = new String[metaMethod.getParameterTypes().length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Utilities.translateClassLoaderTypeName(metaMethod.getParameterTypes()[i].getName());
        }
        return new MethodSignature(metaMethod.getName(), stringArray);
    }
}

