/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.TypeVisitor;

public class TypeInferenceVisitor
extends TypeVisitor {
    private ClassNode guessedType;
    private boolean leafReached = false;

    public TypeInferenceVisitor(SourceUnit sourceUnit, AstPath astPath, BaseDocument baseDocument, int n) {
        super(sourceUnit, astPath, baseDocument, n, false);
    }

    public ClassNode getGuessedType() {
        return this.guessedType;
    }

    public void collect() {
        this.guessedType = null;
        this.leafReached = false;
        super.collect();
    }

    protected void visitParameters(Parameter[] parameterArray, Variable variable) {
        if (!this.leafReached) {
            for (Parameter parameter : parameterArray) {
                if (!TypeInferenceVisitor.sameVariableName(parameter, variable)) continue;
                this.guessedType = parameter.getType();
                break;
            }
        }
    }

    public void visitVariableExpression(VariableExpression variableExpression) {
        if (variableExpression == this.leaf) {
            this.leafReached = true;
        }
        super.visitVariableExpression(variableExpression);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        Expression expression;
        if (!this.leafReached && (expression = binaryExpression.getLeftExpression()) instanceof VariableExpression && binaryExpression.getOperation().isA(100) && TypeInferenceVisitor.sameVariableName(this.leaf, expression)) {
            Expression expression2 = binaryExpression.getRightExpression();
            if (expression2 instanceof ConstantExpression && !expression2.getText().equals("null")) {
                this.guessedType = ((ConstantExpression)expression2).getType();
            } else if (expression2 instanceof ConstructorCallExpression) {
                this.guessedType = ((ConstructorCallExpression)expression2).getType();
            }
        }
        super.visitBinaryExpression(binaryExpression);
    }

    private static boolean sameVariableName(Parameter parameter, Variable variable) {
        return parameter.getName().equals(variable.getName());
    }

    private static boolean sameVariableName(ASTNode aSTNode, ASTNode aSTNode2) {
        return aSTNode instanceof VariableExpression && aSTNode2 instanceof VariableExpression && ((VariableExpression)aSTNode).getName().equals(((VariableExpression)aSTNode2).getName());
    }
}

