/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InnerToOuterTransformer
extends RefactoringVisitor {
    private Element inner;
    private Element outer;
    private InnerToOuterRefactoring refactoring;
    private boolean isInInnerClass = false;
    private Problem problem;

    private Element getCurrentElement() {
        return this.workingCopy.getTrees().getElement(this.getCurrentPath());
    }

    public InnerToOuterTransformer(InnerToOuterRefactoring innerToOuterRefactoring) {
        this.refactoring = innerToOuterRefactoring;
    }

    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        this.inner = this.refactoring.getSourceType().resolveElement((CompilationInfo)workingCopy);
        this.outer = workingCopy.getElementUtilities().enclosingTypeElement(this.inner);
    }

    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return null;
        }
        if (((Object)this.inner).equals(this.getCurrentElement())) {
            Tree tree = this.make.setLabel((Tree)identifierTree, (CharSequence)this.refactoring.getClassName());
            this.rewrite(identifierTree, tree);
        } else if (this.isThisReferenceToOuter()) {
            IdentifierTree identifierTree2 = this.refactoring.getReferenceName() == null ? this.make.Identifier((CharSequence)(this.outer.getSimpleName().toString() + "." + identifierTree.getName().toString())) : this.make.Identifier((CharSequence)(this.refactoring.getReferenceName() + "." + identifierTree.getName().toString()));
            this.rewrite(identifierTree, identifierTree2);
        } else if (this.isInInnerClass) {
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            Tree tree = generatorUtilities.importFQNs((Tree)identifierTree);
            this.rewrite(identifierTree, tree);
        }
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    public Tree visitNewClass(NewClassTree newClassTree, Element element) {
        Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (this.refactoring.getReferenceName() != null && element2 != null && this.workingCopy.getTypes().isSubtype(this.getCurrentElement().getEnclosingElement().asType(), this.inner.asType())) {
            Parameterizable parameterizable;
            String string = this.getCurrentClass() == this.inner ? this.refactoring.getReferenceName() : (this.workingCopy.getTypes().isSubtype(this.getCurrentClass().asType(), this.outer.asType()) ? "this" : ((parameterizable = this.getOuter(this.getCurrentClass())) != null ? this.getOuter(this.getCurrentClass()).getQualifiedName().toString() + ".this" : "this"));
            if (string != null) {
                parameterizable = (ExecutableElement)element2;
                if (parameterizable.isVarArgs()) {
                    int n = parameterizable.getParameters().size() - 1;
                    this.rewrite(newClassTree, this.make.insertNewClassArgument(newClassTree, n, (ExpressionTree)this.make.Identifier((CharSequence)string)));
                } else {
                    this.rewrite(newClassTree, this.make.addNewClassArgument(newClassTree, (ExpressionTree)this.make.Identifier((CharSequence)string)));
                }
            }
        } else if (this.refactoring.getReferenceName() != null && element2 != null && this.outer != null && ((TypeElement)this.outer).getNestingKind() == NestingKind.TOP_LEVEL) {
            Element element3 = element2.getEnclosingElement();
            ExpressionTree expressionTree = newClassTree.getEnclosingExpression();
            Element element4 = null;
            if (expressionTree != null) {
                element4 = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), expressionTree));
                Element element5 = element4 = expressionTree != null ? this.workingCopy.getTypes().asElement(element4.asType()) : null;
            }
            if (element3 != null && element3.getKind() == ElementKind.CLASS && element3 != this.inner && this.isInInnerClass && !element3.getModifiers().contains((Object)Modifier.STATIC) && ((TypeElement)element3).getNestingKind() == NestingKind.MEMBER && (element4 == null && expressionTree == null || element4 == this.outer)) {
                NewClassTree newClassTree2 = this.make.NewClass((ExpressionTree)this.make.Identifier((CharSequence)this.refactoring.getReferenceName()), newClassTree.getTypeArguments(), (ExpressionTree)this.make.Identifier((CharSequence)element3.getSimpleName()), newClassTree.getArguments(), newClassTree.getClassBody());
                this.rewrite(newClassTree, newClassTree2);
            }
        }
        return (Tree)super.visitNewClass(newClassTree, element);
    }

    private TypeElement getOuter(TypeElement typeElement) {
        while (typeElement != null && !this.workingCopy.getTypes().isSubtype(typeElement.asType(), this.outer.asType())) {
            typeElement = this.workingCopy.getElementUtilities().enclosingTypeElement((Element)typeElement);
        }
        return typeElement;
    }

    public Tree visitMethod(MethodTree methodTree, Element element) {
        if (methodTree.getReturnType() == null && this.refactoring.getReferenceName() != null && !((Object)this.inner).equals(this.getCurrentClass()) && this.workingCopy.getTypes().isSubtype(this.getCurrentElement().getEnclosingElement().asType(), this.inner.asType())) {
            MemberSelectTree memberSelectTree = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.getCurrentClass().getEnclosingElement().getSimpleName()), (CharSequence)"this");
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)((ExpressionStatementTree)methodTree.getBody().getStatements().get(0)).getExpression();
            int n = this.hasVarArgs(methodTree) ? methodTree.getParameters().size() - 1 : 0;
            MethodInvocationTree methodInvocationTree2 = this.make.insertMethodInvocationArgument(methodInvocationTree, n, (ExpressionTree)memberSelectTree);
            this.rewrite(methodInvocationTree, methodInvocationTree2);
        }
        return (Tree)super.visitMethod(methodTree, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree visitClass(ClassTree classTree, Element element) {
        Tree tree;
        Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        if (element2 != null && element2 == this.outer) {
            ClassTree classTree2;
            Element element3 = this.outer.getEnclosingElement();
            super.visitClass(classTree, element);
            TreePath treePath = this.workingCopy.getTrees().getPath(this.inner);
            ClassTree classTree3 = classTree2 = (ClassTree)treePath.getLeaf();
            classTree3 = (ClassTree)generatorUtilities.importComments((Tree)classTree3, this.workingCopy.getCompilationUnit());
            classTree3 = (ClassTree)this.make.setLabel((Tree)classTree3, (CharSequence)this.refactoring.getClassName());
            classTree3 = this.refactorInnerClass(classTree3);
            RetoucheUtils.copyJavadoc(this.inner, classTree3, this.workingCopy);
            if (element3.getKind() == ElementKind.PACKAGE) {
                FileObject fileObject = ClassPath.getClassPath((FileObject)this.workingCopy.getFileObject(), (String)"classpath/source").findOwnerRoot(this.workingCopy.getFileObject());
                ClassTree classTree4 = (ClassTree)this.workingCopy.getTrees().getTree(this.outer);
                ClassTree classTree5 = this.make.removeClassMember(classTree4, (Tree)classTree2);
                this.workingCopy.rewrite((Tree)classTree4, (Tree)classTree5);
                JavaRefactoringUtils.cacheTreePathInfo(this.workingCopy.getTrees().getPath(this.outer), (CompilationInfo)this.workingCopy);
                CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
                String string = RetoucheUtils.getPackageName(compilationUnitTree).replace('.', '/') + '/' + this.refactoring.getClassName() + ".java";
                CompilationUnitTree compilationUnitTree2 = this.make.CompilationUnit(fileObject, string, null, Collections.singletonList(classTree3));
                this.workingCopy.rewrite(null, (Tree)compilationUnitTree2);
                return classTree5;
            }
            ClassTree classTree6 = (ClassTree)this.workingCopy.getTrees().getTree(this.outer);
            ClassTree classTree7 = (ClassTree)this.workingCopy.getTrees().getTree(element3);
            ClassTree classTree8 = this.make.removeClassMember(classTree6, (Tree)classTree2);
            ClassTree classTree9 = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(classTree7, (Tree)classTree3);
            this.workingCopy.rewrite((Tree)classTree6, (Tree)classTree8);
            JavaRefactoringUtils.cacheTreePathInfo(this.workingCopy.getTrees().getPath(this.outer), (CompilationInfo)this.workingCopy);
            this.workingCopy.rewrite((Tree)classTree7, (Tree)classTree9);
            return classTree9;
        }
        if (this.refactoring.getReferenceName() != null && element2 != null && this.workingCopy.getTypes().isSubtype(element2.asType(), this.inner.asType()) && element2 != this.inner) {
            tree = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)this.refactoring.getReferenceName(), this.make.Type(this.outer.asType()), null);
            for (Tree tree2 : classTree.getMembers()) {
                MethodTree methodTree;
                if (tree2.getKind() != Tree.Kind.METHOD || (methodTree = (MethodTree)tree2).getReturnType() != null) continue;
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)((ExpressionStatementTree)methodTree.getBody().getStatements().get(0)).getExpression();
                ArrayList<? extends ExpressionTree> arrayList = new ArrayList<ExpressionTree>(methodInvocationTree.getArguments());
                MethodTree methodTree2 = null;
                IdentifierTree identifierTree = this.make.Identifier((CharSequence)tree.getName().toString());
                if (this.hasVarArgs(methodTree)) {
                    int n = methodTree.getParameters().size() - 1;
                    arrayList.add(n, identifierTree);
                    methodTree2 = this.make.insertMethodParameter(methodTree, n, (VariableTree)tree);
                } else {
                    arrayList.add(identifierTree);
                    methodTree2 = this.make.addMethodParameter(methodTree, (VariableTree)tree);
                }
                MethodInvocationTree methodInvocationTree2 = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.Identifier((CharSequence)"super"), arrayList);
                BlockTree blockTree = this.make.insertBlockStatement(methodTree.getBody(), 0, (StatementTree)this.make.ExpressionStatement((ExpressionTree)methodInvocationTree2));
                blockTree = this.make.removeBlockStatement(blockTree, 1);
                methodTree2 = this.make.Constructor(this.make.Modifiers(methodTree2.getModifiers().getFlags(), methodTree2.getModifiers().getAnnotations()), methodTree2.getTypeParameters(), methodTree2.getParameters(), methodTree2.getThrows(), blockTree);
                this.rewrite(methodTree, methodTree2);
            }
        }
        if (element2 == this.inner) {
            try {
                this.isInInnerClass = true;
                tree = (Tree)super.visitClass(classTree, element);
                return tree;
            }
            finally {
                this.isInInnerClass = false;
            }
        }
        return (Tree)super.visitClass(classTree, element);
    }

    public Problem getProblem() {
        return this.problem;
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        Element element2 = this.getCurrentElement();
        if (((Object)this.inner).equals(element2)) {
            ExpressionTree expressionTree = memberSelectTree.getExpression();
            if (expressionTree.getKind() == Tree.Kind.IDENTIFIER) {
                IdentifierTree identifierTree = this.make.Identifier((CharSequence)this.refactoring.getClassName());
                this.rewrite(memberSelectTree, identifierTree);
            } else if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree memberSelectTree2 = this.make.MemberSelect(((MemberSelectTree)expressionTree).getExpression(), (CharSequence)this.refactoring.getClassName());
                this.rewrite(memberSelectTree, memberSelectTree2);
            }
        } else if (this.isThisReferenceToOuter() && !"class".equals(memberSelectTree.getIdentifier().toString()) && !element2.getModifiers().contains((Object)Modifier.STATIC)) {
            if (this.refactoring.getReferenceName() != null) {
                IdentifierTree identifierTree = "this".equals(memberSelectTree.getIdentifier().toString()) ? this.make.Identifier((CharSequence)this.refactoring.getReferenceName()) : this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)this.refactoring.getReferenceName()), (CharSequence)memberSelectTree.getIdentifier());
                this.rewrite(memberSelectTree, identifierTree);
            } else {
                this.problem = MoveTransformer.createProblem(this.problem, true, NbBundle.getMessage(InnerToOuterTransformer.class, (String)"ERR_InnerToOuter_UseDeclareField", (Object)memberSelectTree));
                this.isThisReferenceToOuter();
            }
        }
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    private boolean isThisReferenceToOuter() {
        Element element = this.getCurrentElement();
        if (element == null || element.getKind() == ElementKind.PACKAGE) {
            return false;
        }
        TypeElement typeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(element);
        return ((Object)this.outer).equals(typeElement) && this.workingCopy.getTypes().isSubtype(this.getCurrentClass().asType(), this.inner.asType());
    }

    private TypeElement getCurrentClass() {
        for (TreePath treePath = this.getCurrentPath(); treePath != null; treePath = treePath.getParentPath()) {
            if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                return (TypeElement)this.workingCopy.getTrees().getElement(treePath);
            }
            if (treePath.getLeaf().getKind() != Tree.Kind.IMPORT) continue;
            return (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
        }
        throw new IllegalStateException();
    }

    private boolean isIn(Element element) {
        if (element == null) {
            return false;
        }
        Element element2 = element;
        while (element2.getKind() != ElementKind.PACKAGE) {
            if (((Object)element2).equals(this.inner)) {
                return true;
            }
            element2 = element2.getEnclosingElement();
        }
        return false;
    }

    private boolean hasVarArgs(MethodTree methodTree) {
        List<? extends VariableTree> list = methodTree.getParameters();
        if (list.isEmpty()) {
            return false;
        }
        VariableTree variableTree = list.get(list.size() - 1);
        return variableTree.toString().indexOf("...") != -1;
    }

    private ClassTree refactorInnerClass(ClassTree classTree) {
        MethodTree methodTree;
        String string = this.refactoring.getReferenceName();
        VariableTree variableTree = null;
        if (string != null) {
            variableTree = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)this.refactoring.getReferenceName(), this.make.Type(this.outer.asType()), null);
            classTree = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(classTree, (Tree)variableTree);
        }
        ModifiersTree modifiersTree = classTree.getModifiers();
        ModifiersTree modifiersTree2 = this.make.removeModifiersModifier(modifiersTree, Modifier.PRIVATE);
        modifiersTree2 = this.make.removeModifiersModifier(modifiersTree2, Modifier.STATIC);
        modifiersTree2 = this.make.removeModifiersModifier(modifiersTree2, Modifier.PROTECTED);
        this.rewrite(modifiersTree, modifiersTree2);
        if (string != null) {
            for (Tree tree : classTree.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD || (methodTree = (MethodTree)tree).getReturnType() != null) continue;
                MethodTree methodTree2 = this.hasVarArgs(methodTree) ? this.make.insertMethodParameter(methodTree, methodTree.getParameters().size() - 1, variableTree) : this.make.addMethodParameter(methodTree, variableTree);
                AssignmentTree assignmentTree = this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)("this." + string)), (ExpressionTree)this.make.Identifier((CharSequence)string));
                BlockTree blockTree = this.make.insertBlockStatement(methodTree2.getBody(), 1, (StatementTree)this.make.ExpressionStatement((ExpressionTree)assignmentTree));
                methodTree2 = this.make.Constructor(this.make.Modifiers(methodTree2.getModifiers().getFlags(), methodTree2.getModifiers().getAnnotations()), methodTree2.getTypeParameters(), methodTree2.getParameters(), methodTree2.getThrows(), blockTree);
                classTree = this.make.removeClassMember(classTree, (Tree)methodTree);
                classTree = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMember(classTree, (Tree)methodTree2);
            }
        }
        if (this.inner.getKind() == ElementKind.ENUM) {
            for (Tree tree : classTree.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD || (methodTree = (MethodTree)tree).getReturnType() != null) continue;
                this.rewrite(methodTree.getBody(), this.make.removeBlockStatement(methodTree.getBody(), 0));
            }
        }
        return classTree;
    }
}

