/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient TreePathHandle element;
    private TreePathHandle newElement;
    private final transient ChangeListener parent;
    private static final int MAX_NAME = 50;
    private boolean initialized = false;
    private String methodDeclaringSuperClass = null;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel commentsPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JComboBox scope;
    private JLabel scopeLabel;
    private JPanel scopePanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String string, TreePathHandle treePathHandle, ChangeListener changeListener) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.element = treePathHandle;
        this.parent = changeListener;
        this.initComponents();
    }

    public Scope getScope() {
        if (this.scope.getSelectedIndex() == 1) {
            return Scope.CURRENT;
        }
        return Scope.ALL;
    }

    String getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    private Collection getOverriddenMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return RetoucheUtils.getOverridenMethods(executableElement, compilationInfo);
    }

    public void initialize() {
        JLabel jLabel;
        JLabel jLabel2;
        Object object;
        if (this.initialized) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.element.getFileObject());
        Project project = FileOwnerQuery.getOwner((FileObject)this.element.getFileObject());
        if (project != null) {
            object = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)this.element.getFileObject()));
            jLabel2 = new JLabel(object.getDisplayName(), object.getIcon(), 2);
            jLabel = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AllProjects"), object.getIcon(), 2);
        } else {
            jLabel2 = null;
            jLabel = null;
        }
        object = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController compilationController) throws Exception {
                Collection collection;
                String string;
                Object object;
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                Object object2 = null;
                Set<Object> set = new HashSet();
                final Element element = WhereUsedPanel.this.element.resolveElement((CompilationInfo)compilationController);
                if (element.getKind() == ElementKind.METHOD) {
                    object = (ExecutableElement)element;
                    set = object.getModifiers();
                    string = NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_MethodUsages", (Object)WhereUsedPanel.this.getHeader((Element)object, (CompilationInfo)compilationController), (Object)WhereUsedPanel.this.getSimpleName(object.getEnclosingElement()));
                    WhereUsedPanel.this.methodDeclaringClass = WhereUsedPanel.this.getSimpleName(object.getEnclosingElement());
                    collection = WhereUsedPanel.this.getOverriddenMethods((ExecutableElement)object, (CompilationInfo)compilationController);
                    if (!collection.isEmpty()) {
                        ExecutableElement executableElement = (ExecutableElement)collection.iterator().next();
                        assert (executableElement != null);
                        object2 = new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOfBaseClass")).format(new Object[]{WhereUsedPanel.this.methodDeclaringSuperClass = WhereUsedPanel.this.getSimpleName(executableElement.getEnclosingElement())});
                        WhereUsedPanel.this.newElement = TreePathHandle.create((Element)executableElement, (CompilationInfo)compilationController);
                    }
                } else {
                    string = element.getKind().isClass() || element.getKind().isInterface() ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ClassUsages", (Object)element.getSimpleName()) : (element.getKind() == ElementKind.CONSTRUCTOR ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_ConstructorUsages", (Object)WhereUsedPanel.this.getHeader(element, (CompilationInfo)compilationController), (Object)WhereUsedPanel.this.getSimpleName(element.getEnclosingElement())) : (element.getKind().isField() ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_FieldUsages", (Object)element.getSimpleName(), (Object)WhereUsedPanel.this.getSimpleName(element.getEnclosingElement())) : (element.getKind() == ElementKind.PACKAGE ? NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_PackageUsages", (Object)element.getSimpleName()) : NbBundle.getMessage(WhereUsedPanel.class, (String)"DSC_VariableUsages", (Object)element.getSimpleName()))));
                }
                object = set;
                collection = object2;
                SwingUtilities.invokeLater(new Runnable((Set)object, (String)((Object)collection)){
                    final /* synthetic */ Set val$modifiers;
                    final /* synthetic */ String val$isBaseClassText;
                    {
                        this.val$modifiers = set;
                        this.val$isBaseClassText = string2;
                    }

                    public void run() {
                        WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                        WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                        WhereUsedPanel.this.label.setText(string);
                        if (element instanceof ExecutableElement) {
                            WhereUsedPanel.this.add((Component)WhereUsedPanel.this.methodsPanel, "Center");
                            WhereUsedPanel.this.methodsPanel.setVisible(true);
                            WhereUsedPanel.this.m_usages.setVisible(!this.val$modifiers.contains((Object)Modifier.STATIC));
                            WhereUsedPanel.this.m_overriders.setVisible(!element.getEnclosingElement().getModifiers().contains((Object)Modifier.FINAL) && !this.val$modifiers.contains((Object)Modifier.FINAL) && !this.val$modifiers.contains((Object)Modifier.STATIC) && !this.val$modifiers.contains((Object)Modifier.PRIVATE));
                            if (WhereUsedPanel.this.methodDeclaringSuperClass != null) {
                                WhereUsedPanel.this.m_isBaseClass.setVisible(true);
                                WhereUsedPanel.this.m_isBaseClass.setSelected(true);
                                Mnemonics.setLocalizedText((AbstractButton)WhereUsedPanel.this.m_isBaseClass, (String)this.val$isBaseClassText);
                            } else {
                                WhereUsedPanel.this.m_isBaseClass.setVisible(false);
                                WhereUsedPanel.this.m_isBaseClass.setSelected(false);
                            }
                        } else if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
                            WhereUsedPanel.this.add((Component)WhereUsedPanel.this.classesPanel, "Center");
                            WhereUsedPanel.this.classesPanel.setVisible(true);
                        } else {
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                            WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                            WhereUsedPanel.this.c_subclasses.setVisible(false);
                            WhereUsedPanel.this.m_usages.setVisible(false);
                            WhereUsedPanel.this.c_usages.setVisible(false);
                            WhereUsedPanel.this.c_directOnly.setVisible(false);
                        }
                        if (jLabel2 != null) {
                            WhereUsedPanel.this.scope.setModel(new DefaultComboBoxModel<Object>(new Object[]{jLabel, jLabel2}));
                            int n = RefactoringModule.getOption("whereUsed.scope", 0);
                            WhereUsedPanel.this.scope.setSelectedIndex(n);
                            WhereUsedPanel.this.scope.setRenderer(new JLabelRenderer());
                        } else {
                            WhereUsedPanel.this.scopePanel.setVisible(false);
                        }
                        WhereUsedPanel.this.validate();
                    }
                });
            }
        };
        try {
            javaSource.runUserActionTask((Task)object, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        this.initialized = true;
    }

    private String getSimpleName(Element element) {
        return element.getSimpleName().toString();
    }

    private String getHeader(Element element, CompilationInfo compilationInfo) {
        String string = ElementHeaders.getHeader((Element)element, (CompilationInfo)compilationInfo, (String)"%name%%parameters%");
        if (string.length() > 50) {
            string = string.substring(0, 49) + "...";
        }
        return RetoucheUtils.htmlize(string);
    }

    public TreePathHandle getBaseMethod() {
        return this.newElement;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.commentsPanel = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.scopePanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scope = new JComboBox();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/refactoring/java/ui/Bundle");
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_isBaseClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_overridersActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_overriders"));
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.m_usagesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_usages"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_subclasses"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_usages"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_directOnly"));
        this.add((Component)this.classesPanel, "Center");
        this.commentsPanel.setLayout(new BorderLayout());
        this.commentsPanel.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(itemEvent);
            }
        });
        this.commentsPanel.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.commentsPanel, "North");
        this.scopeLabel.setLabelFor(this.scope);
        Mnemonics.setLocalizedText((JLabel)this.scopeLabel, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope"));
        this.scope.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereUsedPanel.this.scopeActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.scopePanel);
        this.scopePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.scopeLabel).addPreferredGap(0).add((Component)this.scope, 0, 266, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.scopeLabel).add((Component)this.scope, -2, 20, Short.MAX_VALUE));
        this.scope.getAccessibleContext().setAccessibleDescription("N/A");
        this.add((Component)this.scopePanel, "Last");
    }

    private void scopeActionPerformed(ActionEvent actionEvent) {
        RefactoringModule.setOption("whereUsed.scope", this.scope.getSelectedIndex());
    }

    private void searchInCommentsItemStateChanged(ItemEvent itemEvent) {
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", bl);
    }

    private void m_isBaseClassActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent actionEvent) {
        this.parent.stateChanged(null);
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            if (object != null) {
                this.setText(((JLabel)object).getText());
                this.setIcon(((JLabel)object).getIcon());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        ALL,
        CURRENT;

    }
}

