/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.support.ArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.items.ChoiceGroupCD;
import org.netbeans.modules.vmd.midp.components.items.DateFieldCD;
import org.netbeans.modules.vmd.midp.components.items.GaugeCD;
import org.netbeans.modules.vmd.midp.components.items.ImageItemCD;
import org.netbeans.modules.vmd.midp.components.items.SpacerCD;
import org.netbeans.modules.vmd.midp.components.items.StringItemCD;
import org.netbeans.modules.vmd.midp.components.items.TextFieldCD;
import org.netbeans.modules.vmd.midp.components.sources.ItemCommandEventSourceCD;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterActions;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;

public class ConverterItems {
    static void convertItem(HashMap<String, ConverterItem> id2item, ConverterItem itemItem, DesignComponent itemComponent) {
        DesignComponent defaultCommand;
        Converter.convertClass(itemItem, itemComponent);
        DesignDocument document = itemComponent.getDocument();
        ConverterUtil.convertStringWithUserCode(itemComponent, "label", itemItem.getPropertyValue("label"));
        ConverterUtil.convertInteger(itemComponent, "preferredWidth", itemItem.getPropertyValue("preferredSizeX"));
        ConverterUtil.convertInteger(itemComponent, "preferredHeight", itemItem.getPropertyValue("preferredSizeY"));
        ConverterUtil.convertInteger(itemComponent, "layout", itemItem.getPropertyValue("layout"));
        ArrayList<String> commandsList = itemItem.getContainerPropertyValue("commands");
        if (commandsList != null) {
            for (String commandValue : commandsList) {
                ConverterItem commandActionItem = id2item.get(commandValue);
                if (commandActionItem == null) continue;
                ConverterActions.convertCommandAction(id2item, commandActionItem, document);
                DesignComponent eventSource = commandActionItem.getRelatedComponent();
                if (eventSource != null) {
                    MidpDocumentSupport.addEventSource((DesignComponent)itemComponent, (String)"commands", (DesignComponent)eventSource);
                    eventSource.writeProperty("item", PropertyValue.createComponentReference((DesignComponent)itemComponent));
                    continue;
                }
                Debug.warning((Object[])new Object[]{"Unrecognized command", itemItem, commandValue});
            }
        }
        if (itemItem.isPropertyValueSet("defaultCommand") && (defaultCommand = Converter.convertConverterItemComponent(id2item, itemItem.getPropertyValue("defaultCommand"), document)) != null) {
            List commandEventSources = DocumentSupport.gatherSubComponentsOfType((DesignComponent)itemComponent, (TypeID)ItemCommandEventSourceCD.TYPEID);
            for (DesignComponent commandEventSource : commandEventSources) {
                DesignComponent foundCommand = commandEventSource.readProperty("command").getComponent();
                if (defaultCommand != foundCommand) continue;
                itemComponent.writeProperty("defaultCommand", PropertyValue.createComponentReference((DesignComponent)commandEventSource));
                break;
            }
            Debug.warning((Object[])new Object[]{"defaultCommand not found for", itemItem, itemItem.getPropertyValue("defaultCommand")});
        }
    }

    static void convertGauge(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertGaugeCore(id2item, item, document.createComponent(GaugeCD.TYPEID));
    }

    static void convertGaugeCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent gauge) {
        ConverterItems.convertItem(id2item, item, gauge);
        ConverterUtil.convertBoolean(gauge, "interactive", item.getPropertyValue("interactive"));
        ConverterUtil.convertInteger(gauge, "value", item.getPropertyValue("value"));
        ConverterUtil.convertInteger(gauge, "maxValue", item.getPropertyValue("maxValue"));
    }

    static void convertAlertIndicator(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertGauge(id2item, item, document);
        DesignComponent gauge = item.getRelatedComponent();
        gauge.writeProperty("usedByAlert", MidpTypes.createBooleanValue((boolean)true));
    }

    static void convertSpacer(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertSpacerCore(id2item, item, document.createComponent(SpacerCD.TYPEID));
    }

    static void convertSpacerCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent spacer) {
        ConverterItems.convertItem(id2item, item, spacer);
        ConverterUtil.convertInteger(spacer, "minWidth", item.getPropertyValue("minWidth"));
        ConverterUtil.convertInteger(spacer, "minHeight", item.getPropertyValue("minHeight"));
    }

    static void convertStringItem(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertStringItemCore(id2item, item, document.createComponent(StringItemCD.TYPEID));
    }

    static void convertStringItemCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent stringComponent) {
        ConverterItems.convertItem(id2item, item, stringComponent);
        ConverterUtil.convertStringWithUserCode(stringComponent, "text", item.getPropertyValue("text"));
        ConverterUtil.convertConverterItemComponent(stringComponent, "font", id2item, item.getPropertyValue("font"));
        String apperanceMode = item.getPropertyValue("appearanceMode");
        if ("PLAIN".equals(apperanceMode)) {
            stringComponent.writeProperty("appearanceMode", MidpTypes.createIntegerValue((int)0));
        } else if ("BUTTON".equals(apperanceMode)) {
            stringComponent.writeProperty("appearanceMode", MidpTypes.createIntegerValue((int)2));
        } else if ("HYPERLINK".equals(apperanceMode)) {
            stringComponent.writeProperty("appearanceMode", MidpTypes.createIntegerValue((int)1));
        }
    }

    static void convertImageItem(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertImageItemCore(id2item, item, document.createComponent(ImageItemCD.TYPEID));
    }

    static void convertImageItemCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent imageComponent) {
        ConverterItems.convertItem(id2item, item, imageComponent);
        ConverterUtil.convertStringWithUserCode(imageComponent, "altText", item.getPropertyValue("altText"));
        ConverterUtil.convertConverterItemComponent(imageComponent, "image", id2item, item.getPropertyValue("image"));
        String apperanceMode = item.getPropertyValue("appearanceMode");
        if ("PLAIN".equals(apperanceMode)) {
            imageComponent.writeProperty("appearanceMode", MidpTypes.createIntegerValue((int)0));
        } else if ("BUTTON".equals(apperanceMode)) {
            imageComponent.writeProperty("appearanceMode", MidpTypes.createIntegerValue((int)2));
        } else if ("HYPERLINK".equals(apperanceMode)) {
            imageComponent.writeProperty("appearanceMode", MidpTypes.createIntegerValue((int)1));
        }
    }

    static void convertTextField(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertTextFieldCore(id2item, item, document.createComponent(TextFieldCD.TYPEID));
    }

    static void convertTextFieldCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent textField) {
        ConverterItems.convertItem(id2item, item, textField);
        ConverterUtil.convertInteger(textField, "constraints", item.getPropertyValue("constraints"));
        ConverterUtil.convertString(textField, "initialInputMode", item.getPropertyValue("initialInputMode"));
        ConverterUtil.convertInteger(textField, "constraints", item.getPropertyValue("maxSize"));
        ConverterUtil.convertStringWithUserCode(textField, "initialInputMode", item.getPropertyValue("string"));
    }

    static void convertDateField(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertDateFieldCore(id2item, item, document.createComponent(DateFieldCD.TYPEID));
    }

    static void convertDateFieldCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent dateField) {
        ConverterItems.convertItem(id2item, item, dateField);
        String inputMode = item.getPropertyValue("inputMode");
        if ("DATE".equals(inputMode)) {
            dateField.writeProperty("inputMode", MidpTypes.createIntegerValue((int)1));
        } else if ("DATE_TIME".equals(inputMode)) {
            dateField.writeProperty("inputMode", MidpTypes.createIntegerValue((int)3));
        } else if ("TIME".equals(inputMode)) {
            dateField.writeProperty("inputMode", MidpTypes.createIntegerValue((int)2));
        }
    }

    static void convertChoiceGroup(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        ConverterItems.convertChoiceGroupCore(id2item, item, document.createComponent(ChoiceGroupCD.TYPEID));
    }

    static void convertChoiceGroupCore(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent choiceGroup) {
        ConverterItems.convertItem(id2item, item, choiceGroup);
        String choiceTypeValue = item.getPropertyValue("choiceType");
        if ("EXCLUSIVE".equals(choiceTypeValue)) {
            choiceGroup.writeProperty("choiceType", MidpTypes.createIntegerValue((int)1));
        } else if ("IMPLICIT".equals(choiceTypeValue)) {
            choiceGroup.writeProperty("choiceType", MidpTypes.createIntegerValue((int)3));
        } else if ("MULTIPLE".equals(choiceTypeValue)) {
            choiceGroup.writeProperty("choiceType", MidpTypes.createIntegerValue((int)2));
        } else if ("POPUP".equals(choiceTypeValue)) {
            choiceGroup.writeProperty("choiceType", MidpTypes.createIntegerValue((int)4));
        }
        String fitPolicyValue = item.getPropertyValue("fitPolicy");
        if ("TEXT_WRAP_DEFAULT".equals(fitPolicyValue)) {
            choiceGroup.writeProperty("fitPolicy", MidpTypes.createIntegerValue((int)0));
        } else if ("TEXT_WRAP_OFF".equals(fitPolicyValue)) {
            choiceGroup.writeProperty("fitPolicy", MidpTypes.createIntegerValue((int)2));
        } else if ("TEXT_WRAP_ON".equals(fitPolicyValue)) {
            choiceGroup.writeProperty("fitPolicy", MidpTypes.createIntegerValue((int)1));
        }
        ArrayList<String> elementsList = item.getContainerPropertyValue("elements");
        if (elementsList != null) {
            for (String elementValue : elementsList) {
                DesignComponent choiceElement = Converter.convertConverterItemComponent(id2item, elementValue, choiceGroup.getDocument());
                if (choiceElement == null) {
                    Debug.warning((Object[])new Object[]{"ChoiceElement not found", elementValue});
                    continue;
                }
                choiceGroup.addComponent(choiceElement);
                ArraySupport.append((DesignComponent)choiceGroup, (String)"elements", (DesignComponent)choiceElement);
            }
        }
    }

    static void convertCustomItem(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent custom) {
        ConverterItems.convertItem(id2item, item, custom);
    }
}

