/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTasks;
import org.openide.util.Lookup;

final class CallHierarchyModel {
    public static final String PROP_ROOT = "root";
    private Call root;
    private HierarchyType type = HierarchyType.CALLER;
    private Set<Scope> scopes = EnumSet.of(Scope.ALL, Scope.TESTS);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    private CallHierarchyModel(Call root, HierarchyType type, Set<Scope> scopes) {
        this.root = root;
        root.model = this;
        if (type != null) {
            this.type = type;
        }
        if (scopes != null) {
            this.scopes = scopes;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public Call getRoot() {
        return this.root;
    }

    public synchronized Set<Scope> getScopes() {
        return this.scopes;
    }

    public synchronized void setScopes(Set<Scope> scopes) {
        this.scopes = scopes;
    }

    public synchronized HierarchyType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(HierarchyType type) {
        CallHierarchyModel callHierarchyModel = this;
        synchronized (callHierarchyModel) {
            this.type = type;
        }
        this.replaceRoot();
    }

    public void computeCalls(Call c, Runnable resultHandler) {
        if (this.type == HierarchyType.CALLER) {
            CallHierarchyTasks.findCallers(c, this.scopes.contains((Object)Scope.TESTS), this.scopes.contains((Object)Scope.ALL), resultHandler);
        } else {
            CallHierarchyTasks.findCallees(c, resultHandler);
        }
    }

    void replaceRoot() {
        if (this.root == null) {
            return;
        }
        Call oroot = this.root;
        this.root = CallHierarchyTasks.resolveRoot(this.root.selection, this.type == HierarchyType.CALLER);
        if (this.root != null) {
            this.root.model = this;
        }
        this.support.firePropertyChange(PROP_ROOT, oroot, this.root);
    }

    static CallHierarchyModel create(Lookup context, Set<Scope> scopes, HierarchyType type) {
        boolean isCallerGraph = type == null || type == HierarchyType.CALLER;
        Call root = CallHierarchyTasks.resolveRoot(context, isCallerGraph);
        if (root == null) {
            return null;
        }
        return new CallHierarchyModel(root, type, scopes);
    }

    static CallHierarchyModel create(TreePathHandle selection, Set<Scope> scopes, HierarchyType type) {
        boolean isCallerGraph = type == null || type == HierarchyType.CALLER;
        Call root = CallHierarchyTasks.resolveRoot(selection, isCallerGraph);
        if (root == null) {
            return null;
        }
        return new CallHierarchyModel(root, type, scopes);
    }

    static enum Scope {
        ALL,
        PROJECT,
        TESTS;

    }

    static enum HierarchyType {
        CALLER,
        CALLEE;

    }
}

