/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ChangeParamsTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ChangeParametersPlugin
extends JavaRefactoringPlugin {
    private ChangeParametersRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public ChangeParametersPlugin(ChangeParametersRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        ChangeParametersRefactoring.ParameterInfo[] paramTable = this.refactoring.getParameterInfo();
        Problem p = null;
        for (int i = 0; i < paramTable.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo in;
            int origIndex = paramTable[i].getOriginalIndex();
            if (origIndex == -1) {
                String t;
                String s = paramTable[i].getName();
                if (s == null || s.length() < 1) {
                    p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
                } else if (!Utilities.isJavaIdentifier((String)s)) {
                    p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_InvalidIdentifier", (Object)s));
                }
                ExecutableElement method = (ExecutableElement)this.treePathHandle.resolveElement((CompilationInfo)javac);
                TreeScanner<Boolean, String> scanner = new TreeScanner<Boolean, String>(){

                    @Override
                    public Boolean visitVariable(VariableTree vt, String p) {
                        super.visitVariable(vt, p);
                        return vt.getName().contentEquals(p);
                    }

                    @Override
                    public Boolean reduce(Boolean left, Boolean right) {
                        return left != null && left != false || right != null && right != false;
                    }
                };
                if (((Boolean)scanner.scan(javac.getTrees().getTree(method), s)).booleanValue()) {
                    p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_NameAlreadyUsed", (Object)s));
                }
                if ((t = paramTable[i].getType()) == null) {
                    p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
                }
                if ((s = paramTable[i].getDefaultValue()) == null || s.length() < 1) {
                    p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
                }
            }
            if ((in = paramTable[i]).getType() == null || !in.getType().endsWith("...") || i == paramTable.length - 1) continue;
            p = ChangeParametersPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_VarargsFinalPosition", (Object[])new Object[0]));
        }
        return p;
    }

    private static String newParMessage(String par) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(par)});
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ChangeParametersPlugin.class, (String)key);
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        final HashSet<FileObject> set = new HashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject()});
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    ElementHandle encl;
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    ElementUtilities elmUtils = info.getElementUtilities();
                    Element el = ChangeParametersPlugin.this.treePathHandle.resolveElement((CompilationInfo)info);
                    ElementHandle enclosingType = ElementHandle.create((Element)elmUtils.enclosingTypeElement(el));
                    ChangeParametersPlugin.this.allMethods = new HashSet();
                    ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)el)));
                    for (ExecutableElement e : RetoucheUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info)) {
                        set.add(SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()));
                        encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                    }
                    for (ExecutableElement e : RetoucheUtils.getOverridenMethods((ExecutableElement)el, (CompilationInfo)info)) {
                        set.add(SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()));
                        encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        ChangeParametersPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                    }
                    set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    set.add(SourceUtils.getFile((Element)el, (ClasspathInfo)info.getClasspathInfo()));
                }
            }, true);
        }
        catch (IOException ioe) {
            throw (RuntimeException)new RuntimeException().initCause(ioe);
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        JavaRefactoringPlugin.TransformTask transform;
        Problem p;
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(1, a.size());
        if (!a.isEmpty() && (p = this.createAndAddElements(a, transform = new JavaRefactoringPlugin.TransformTask(this, new ChangeParamsTransformer(this.refactoring, this.allMethods), this.treePathHandle), elements, this.refactoring)) != null) {
            this.fireProgressListenerStop();
            return p;
        }
        this.fireProgressListenerStop();
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case CHECKPARAMETERS: 
            case FASTCHECKPARAMETERS: 
            case PRECHECK: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return null;
    }

    @Override
    public Problem preCheck(CompilationController info) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem preCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        preCheckProblem = ChangeParametersPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        Element el = this.treePathHandle.resolveElement((CompilationInfo)info);
        if (el.getKind() != ElementKind.METHOD && el.getKind() != ElementKind.CONSTRUCTOR) {
            preCheckProblem = ChangeParametersPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return preCheckProblem;
        }
        preCheckProblem = JavaPluginUtils.isSourceElement(el, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        if (info.getElementUtilities().enclosingTypeElement(el).getKind() == ElementKind.ANNOTATION_TYPE) {
            preCheckProblem = new Problem(true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_MethodsInAnnotationsNotSupported"));
            return preCheckProblem;
        }
        for (ExecutableElement e : RetoucheUtils.getOverridenMethods((ExecutableElement)el, (CompilationInfo)info)) {
            if (!RetoucheUtils.isFromLibrary(e, info.getClasspathInfo())) continue;
            preCheckProblem = ChangeParametersPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_CannnotRefactorLibrary", (Object)el));
        }
        this.fireProgressListenerStop();
        return preCheckProblem;
    }
}

