/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Map;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class LeakingThisInConstructor {
    private static final String THIS_KEYWORD = "this";

    public static ErrorDescription hint(HintContext ctx) {
        IdentifierTree it = (IdentifierTree)ctx.getPath().getLeaf();
        CompilationInfo info = ctx.getInfo();
        if (!Utilities.isInConstructor(ctx)) {
            return null;
        }
        Element e = info.getTrees().getElement(ctx.getPath());
        if (e == null || !e.getSimpleName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        if (ctx.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, it, NbBundle.getMessage(LeakingThisInConstructor.class, (String)"MSG_org.netbeans.modules.java.hints.LeakingThisInConstructor"), new Fix[0]);
    }

    public static ErrorDescription hintOnAssignment(HintContext ctx) {
        Map<String, TreePath> variables = ctx.getVariables();
        TreePath thisPath = variables.get("$this");
        if (thisPath.getLeaf().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)thisPath.getLeaf()).getName().contentEquals(THIS_KEYWORD)) {
            return null;
        }
        if (!Utilities.isInConstructor(ctx)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), NbBundle.getMessage(LeakingThisInConstructor.class, (String)"MSG_org.netbeans.modules.java.hints.LeakingThisInConstructor"), new Fix[0]);
    }
}

