/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.modules.java.hints.analyzer.ui.AnalyzerTopComponent;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class PreviousError
extends AbstractAction
implements PropertyChangeListener {
    private AnalyzerTopComponent comp;

    public PreviousError(AnalyzerTopComponent comp) {
        this.comp = comp;
        this.comp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public boolean isEnabled() {
        boolean enabled;
        Node node = this.getNextMeaningfullNode();
        boolean bl = enabled = node != null;
        if (node != null) {
            this.comp.seenNodes.add(0, node);
        }
        return enabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Node node = this.getNextMeaningfullNode();
        this.comp.nodesForNext.add(0, node);
        FixDescription fd = (FixDescription)node.getLookup().lookup(FixDescription.class);
        assert (fd != null);
        try {
            this.comp.getExplorerManager().setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ErrorDescription ed = fd.getErrors();
        UiUtils.open((FileObject)ed.getFile(), (int)ed.getRange().getBegin().getOffset());
        this.fireEnabledChanged();
    }

    void fireEnabledChanged() {
        this.firePropertyChange("enabled", null, this.isEnabled());
    }

    private Node getNextMeaningfullNode() {
        List<Node> seenNodes = this.comp.seenNodes;
        if (seenNodes == null || seenNodes.isEmpty()) {
            return null;
        }
        while (seenNodes != null && !seenNodes.isEmpty()) {
            Node top = this.comp.seenNodes.remove(0);
            FixDescription fd = (FixDescription)top.getLookup().lookup(FixDescription.class);
            if (fd == null) continue;
            Node[] selected = this.comp.getExplorerManager().getSelectedNodes();
            if (selected.length == 1 && selected[0] == top) {
                this.comp.nodesForNext.add(0, top);
                continue;
            }
            if (this.comp.goOverFixed() && !fd.isFixed()) {
                this.comp.nodesForNext.add(0, top);
                continue;
            }
            return top;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireEnabledChanged();
    }
}

