/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.FieldWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;

public class ObjectFieldVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.Field,
Refreshable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    protected Field field;
    private ObjectReference objectReference;
    private ReferenceType classType;
    private String genericSignature;
    private boolean valueSet = true;
    private final Object valueLock = new Object();
    private boolean valueRetrieved = false;
    private ObjectReference value;

    public ObjectFieldVariable(JPDADebuggerImpl debugger, ObjectReference value, Field field, String parentID, ObjectReference objectReference) {
        super(debugger, value, ObjectFieldVariable.getID(parentID, field));
        this.field = field;
        this.objectReference = objectReference;
    }

    private static String getID(String parentID, Field field) {
        try {
            return parentID + '.' + TypeComponentWrapper.name(field) + "^";
        }
        catch (InternalExceptionWrapper ex) {
            return parentID + '.' + ex.getCause().getLocalizedMessage() + "^";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return parentID + ".0^";
        }
    }

    public ObjectFieldVariable(JPDADebuggerImpl debugger, ObjectReference value, Field field, String parentID, String genericSignature, ObjectReference objectReference) {
        this(debugger, value, field, parentID, objectReference);
        this.genericSignature = genericSignature;
    }

    public ObjectFieldVariable(JPDADebuggerImpl debugger, Field field, String parentID, String genericSignature, ObjectReference objectReference) {
        this(debugger, null, field, parentID, genericSignature, objectReference);
        this.valueSet = false;
    }

    public String getName() {
        try {
            return TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public String getClassName() {
        try {
            return ReferenceTypeWrapper.name(TypeComponentWrapper.declaringType(this.field));
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getCause().getLocalizedMessage();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return "";
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    public JPDAClassType getDeclaringClass() {
        return new JPDAClassTypeImpl(this.getDebugger(), this.getTheDeclaringClassType());
    }

    private ReferenceType getTheDeclaringClassType() {
        ReferenceType type = this.classType;
        if (type == null) {
            this.classType = type = FieldVariable.getTheDeclaringClassType(this.objectReference, this.field);
        }
        return type;
    }

    public String getDeclaredType() {
        try {
            return FieldWrapper.typeName(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "";
        }
    }

    @Override
    public JPDAClassType getClassType() {
        Value value = this.getInnerValue();
        if (value != null) {
            return super.getClassType();
        }
        try {
            Type type;
            try {
                type = FieldWrapper.type(this.field);
            }
            catch (InternalExceptionWrapper ex) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
                return null;
            }
            if (type instanceof ReferenceType) {
                return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)type);
            }
            return null;
        }
        catch (ClassNotLoadedException cnlex) {
            return null;
        }
    }

    public boolean isStatic() {
        return TypeComponentWrapper.isStatic0(this.field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Value getInnerValue() {
        if (this.valueSet) {
            return super.getInnerValue();
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                Value v;
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("STARTED (OFV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ")");
                    } else {
                        logger.fine("STARTED (OFV): " + this.objectReference + ".getValue(" + this.field + ")");
                    }
                }
                try {
                    v = this.objectReference == null ? ReferenceTypeWrapper.getValue(this.getTheDeclaringClassType(), this.field) : ObjectReferenceWrapper.getValue(this.objectReference, this.field);
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    v = null;
                }
                catch (InternalExceptionWrapper ocex) {
                    v = null;
                }
                catch (VMDisconnectedExceptionWrapper ocex) {
                    v = null;
                }
                if (logger.isLoggable(Level.FINE)) {
                    if (this.objectReference == null) {
                        logger.fine("FINISHED(OFV): " + this.getTheDeclaringClassType() + ".getValue(" + this.field + ") = " + v);
                    } else {
                        logger.fine("FINISHED(OFV): " + this.objectReference + ".getValue(" + this.field + ") = " + v);
                    }
                    logger.log(Level.FINE, "Called from ", new IllegalStateException("TEST"));
                }
                this.value = (ObjectReference)v;
                this.valueRetrieved = true;
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block15: {
            try {
                boolean set = false;
                if (this.objectReference != null) {
                    ObjectReferenceWrapper.setValue(this.objectReference, this.field, value);
                    set = true;
                } else {
                    ReferenceType rt = this.getTheDeclaringClassType();
                    if (rt instanceof ClassType) {
                        ClassType ct = (ClassType)rt;
                        ClassTypeWrapper.setValue(ct, this.field, value);
                        set = true;
                    }
                }
                if (!set) {
                    throw new InvalidExpressionException(this.field.toString());
                }
                if (this.valueSet) break block15;
                Object object = this.valueLock;
                synchronized (object) {
                    this.value = (ObjectReference)value;
                }
            }
            catch (IllegalArgumentExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex.getCause());
            }
            catch (InvalidTypeException ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ClassNotLoadedException ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (InternalExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ClassNotPreparedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws RefreshFailedException {
        if (this.valueSet) {
            return;
        }
        Object object = this.valueLock;
        synchronized (object) {
            if (!this.valueRetrieved) {
                this.getInnerValue();
            }
        }
    }

    @Override
    public synchronized boolean isCurrent() {
        return this.valueSet || this.valueRetrieved;
    }

    @Override
    public ObjectFieldVariable clone() {
        String name;
        try {
            name = TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            name = ex.getCause().getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            name = "0";
        }
        ObjectFieldVariable clon = new ObjectFieldVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.field, this.getID().substring(0, this.getID().length() - ("." + name + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()), this.genericSignature, this.objectReference);
        clon.classType = this.classType;
        return clon;
    }

    @Override
    public String toString() {
        try {
            return "ObjectFieldVariable " + TypeComponentWrapper.name(this.field);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return "Disconnected";
        }
    }
}

