/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.threads.api.Deadlock;
import org.netbeans.modules.dlight.threads.api.DeadlockThreadSnapshot;

public final class DeadlockImpl
implements Deadlock {
    private final int id;
    private final boolean actual;
    private final List<DeadlockThreadSnapshot> threads;
    private static final Pattern DEADLOCK_PATTERN = Pattern.compile("Deadlock\\s+#(\\d+),\\s+(Actual|Potential)\\s+deadlock");
    private static final Pattern THREAD_PATTERN = Pattern.compile("\\s+Thread\\s+#\\d+");
    private static final Pattern LOCK_PATTERN = Pattern.compile("\\s+Lock being (held|requested):\\s+0x([0-9a-fA-F]+)");

    private DeadlockImpl(int id, boolean actual, List<DeadlockThreadSnapshot> threads) {
        this.id = id;
        this.actual = actual;
        this.threads = Collections.unmodifiableList(threads);
    }

    public boolean isActual() {
        return this.actual;
    }

    public List<DeadlockThreadSnapshot> getThreadStates() {
        return this.threads;
    }

    public String toString() {
        return "Deadlock #" + this.id + " (" + (this.actual ? "actual" : "potential") + ")";
    }

    public static List<DeadlockImpl> fromErprint(String[] lines) {
        ArrayList<DeadlockImpl> deadlocks = new ArrayList<DeadlockImpl>();
        ListIterator<String> it = Arrays.asList(lines).listIterator();
        while (it.hasNext()) {
            Matcher m = DEADLOCK_PATTERN.matcher(it.next());
            if (!m.matches()) continue;
            deadlocks.add(DeadlockImpl.parseDeadlock(it, m));
        }
        return deadlocks;
    }

    private static DeadlockImpl parseDeadlock(ListIterator<String> it, Matcher firstLineMatch) {
        Matcher m;
        int id;
        try {
            id = Integer.parseInt(firstLineMatch.group(1));
        }
        catch (NumberFormatException ex) {
            id = -1;
        }
        boolean actual = firstLineMatch.group(2).equals("Actual");
        ArrayList<DeadlockThreadSnapshot> threads = new ArrayList<DeadlockThreadSnapshot>();
        while (it.hasNext() && (m = THREAD_PATTERN.matcher(it.next())).matches()) {
            threads.add(DeadlockImpl.parseThreadSnapshot(it, m));
        }
        return new DeadlockImpl(id, actual, threads);
    }

    private static DeadlockThreadSnapshot parseThreadSnapshot(ListIterator<String> it, Matcher firstLineMatch) {
        long oldLockAddress = DeadlockImpl.parseLockAddress(it.next(), "held");
        List<FunctionCall> oldLockStack = FunctionCallImpl.parseStack(it);
        long newLockAddress = DeadlockImpl.parseLockAddress(it.next(), "requested");
        List<FunctionCall> newLockStack = FunctionCallImpl.parseStack(it);
        return new DeadlockThreadSnapshotImpl(oldLockAddress, oldLockStack, newLockAddress, newLockStack);
    }

    private static long parseLockAddress(String line, String lockType) {
        Matcher m = LOCK_PATTERN.matcher(line);
        if (m.matches() && m.group(1).equals(lockType)) {
            try {
                return Long.parseLong(m.group(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private static class DeadlockThreadSnapshotImpl
    implements DeadlockThreadSnapshot {
        private final long oldLockAddress;
        private final List<FunctionCall> oldLockStack;
        private final long newLockAddress;
        private final List<FunctionCall> newLockStack;

        private DeadlockThreadSnapshotImpl(long oldLockAddress, List<FunctionCall> oldLockStack, long newLockAddress, List<FunctionCall> newLockStack) {
            this.oldLockAddress = oldLockAddress;
            this.oldLockStack = Collections.unmodifiableList(oldLockStack);
            this.newLockAddress = newLockAddress;
            this.newLockStack = Collections.unmodifiableList(newLockStack);
        }

        public long getHeldLockAddress() {
            return this.oldLockAddress;
        }

        public List<FunctionCall> getHeldLockCallStack() {
            return this.oldLockStack;
        }

        public long getRequestedLockAddress() {
            return this.newLockAddress;
        }

        public List<FunctionCall> getRequestedLockCallStack() {
            return this.newLockStack;
        }
    }
}

