/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.spi.ejbjar.support;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceSupport;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EjbEnterpriseReferenceContainerSupport {
    private EjbEnterpriseReferenceContainerSupport() {
    }

    public static EnterpriseReferenceContainer createEnterpriseReferenceContainer(Project project, AntProjectHelper helper) {
        return new ERC(project, helper);
    }

    private static class ERC
    implements EnterpriseReferenceContainer {
        private final Project ejbProject;
        private final AntProjectHelper antHelper;
        private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";

        private ERC(Project p, AntProjectHelper helper) {
            this.ejbProject = p;
            this.antHelper = helper;
        }

        @Override
        public String addEjbReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
            return this.addReference(ref, refType, ejbRefName, false, referencingFile, referencingClass);
        }

        @Override
        public String addEjbLocalReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
            return this.addReference(ref, refType, ejbRefName, true, referencingFile, referencingClass);
        }

        private String addReference(final EjbReference ejbReference, EjbReference.EjbRefIType refType, final String ejbRefName, final boolean local, FileObject referencingFile, final String referencingClass) throws IOException {
            EjbJar ejbModule = this.findEjbModule(referencingFile);
            MetadataModel<EjbJarMetadata> metadataModel = ejbModule.getMetadataModel();
            MetadataModel<EjbJarMetadata> ejbReferenceMetadataModel = ejbReference.getEjbModule().getMetadataModel();
            String ejbName = (String)ejbReferenceMetadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws Exception {
                    return metadata.findByEjbClass(ejbReference.getEjbClass()).getEjbName();
                }
            });
            Project project = FileOwnerQuery.getOwner((FileObject)ejbReference.getComponentFO(refType));
            AntArtifact[] antArtifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
            boolean hasArtifact = antArtifacts != null && antArtifacts.length > 0;
            final AntArtifact moduleJarTarget = hasArtifact ? antArtifacts[0] : null;
            String[] names = new String[]{""};
            if (moduleJarTarget != null) {
                names = moduleJarTarget.getArtifactLocations()[0].getPath().split("/");
            }
            String jarName = names[names.length - 1] + "#";
            final String ejbLink = jarName + ejbName;
            final boolean[] write = new boolean[]{false};
            String resourceName = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) {
                    EjbLocalRef ejbRef;
                    boolean fromSameProject;
                    String refName = null;
                    Ejb model = metadata.findByEjbClass(referencingClass);
                    boolean bl = fromSameProject = moduleJarTarget == null || ERC.this.ejbProject.equals(moduleJarTarget.getProject());
                    if (model == null) {
                        return ejbRefName;
                    }
                    if (local) {
                        refName = ERC.this.getUniqueEjbLocalRefName(model, ejbRefName);
                        ejbRef = model.newEjbLocalRef();
                        ejbRef.setEjbRefName(refName);
                        ejbRef.setEjbRefType(ejbReference.getEjbRefType());
                        ejbRef.setLocal(ejbReference.getLocal());
                        ejbRef.setLocalHome(ejbReference.getLocalHome());
                        if (fromSameProject) {
                            ejbRef.setEjbLink(ERC.this.stripModuleName(ejbLink));
                        }
                        model.addEjbLocalRef(ejbRef);
                    } else {
                        refName = ERC.this.getUniqueEjbRefName(model, ejbRefName);
                        ejbRef = model.newEjbRef();
                        ejbRef.setEjbRefName(refName);
                        ejbRef.setEjbRefType(ejbReference.getEjbRefType());
                        ejbRef.setRemote(ejbReference.getRemote());
                        ejbRef.setHome(ejbReference.getRemoteHome());
                        if (fromSameProject) {
                            ejbRef.setEjbLink(ERC.this.stripModuleName(ejbLink));
                        }
                        model.addEjbRef((EjbRef)ejbRef);
                    }
                    write[0] = true;
                    if (!fromSameProject) {
                        try {
                            ProjectClassPathExtender pcpe = (ProjectClassPathExtender)ERC.this.ejbProject.getLookup().lookup(ProjectClassPathExtender.class);
                            assert (pcpe != null);
                            pcpe.addAntArtifact(moduleJarTarget, moduleJarTarget.getArtifactLocations()[0]);
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                        }
                    }
                    return refName;
                }
            });
            if (write[0]) {
                this.writeDD(ejbModule);
            }
            ProjectManager.getDefault().saveProject(this.ejbProject);
            return resourceName;
        }

        @Override
        public String getServiceLocatorName() {
            EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
            return ep.getProperty(SERVICE_LOCATOR_PROPERTY);
        }

        @Override
        public void setServiceLocatorName(String serviceLocator) throws IOException {
            EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
            ep.setProperty(SERVICE_LOCATOR_PROPERTY, serviceLocator);
            this.antHelper.putProperties("nbproject/project.properties", ep);
            ProjectManager.getDefault().saveProject(this.ejbProject);
        }

        private String stripModuleName(String ejbLink) {
            int index = ejbLink.indexOf(35);
            return ejbLink.substring(index + 1);
        }

        private EjbJar findEjbModule(FileObject fileObject) {
            return EjbJar.getEjbJar(fileObject);
        }

        private void writeDD(EjbJar ejbModule) throws IOException {
            FileObject fo;
            if (ERC.isDescriptorMandatory(ejbModule.getJ2eeProfile()) && (fo = ejbModule.getDeploymentDescriptor()) != null) {
                DDProvider.getDefault().getDDRoot(fo).write(fo);
            }
        }

        @Override
        public String addResourceRef(final ResourceReference ref, FileObject referencingFile, final String referencingClass) throws IOException {
            EjbJar ejbModule = this.findEjbModule(referencingFile);
            MetadataModel<EjbJarMetadata> metadataModel = ejbModule.getMetadataModel();
            final boolean[] write = new boolean[]{false};
            String resourceName = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws IOException {
                    Ejb ejb = metadata.findByEjbClass(referencingClass);
                    if (ejb == null) {
                        return ref.getResRefName();
                    }
                    String resourceRefName = ref.getResRefName();
                    if (DataSource.class.getName().equals(ref.getResType())) {
                        if (!ERC.this.isJdbcConnectionAlreadyUsed(ejb, ref)) {
                            resourceRefName = ERC.this.getUniqueResRefName(ejb, ref.getResRefName());
                            ResourceRef resourceRef = ejb.newResourceRef();
                            EnterpriseReferenceSupport.populate(ref, resourceRefName, resourceRef);
                            ejb.addResourceRef(resourceRef);
                            write[0] = true;
                        }
                    } else if (!ERC.isResourceRefUsed(ejb, ref)) {
                        resourceRefName = ERC.this.getUniqueResRefName(ejb, ref.getResRefName());
                        ResourceRef resourceRef = ejb.newResourceRef();
                        EnterpriseReferenceSupport.populate(ref, resourceRefName, resourceRef);
                        ejb.addResourceRef(resourceRef);
                        write[0] = true;
                    }
                    return resourceRefName;
                }
            });
            if (write[0]) {
                this.writeDD(ejbModule);
            }
            return resourceName;
        }

        @Override
        public String addDestinationRef(final MessageDestinationReference ref, FileObject referencingFile, final String referencingClass) throws IOException {
            EjbJar ejbModule = this.findEjbModule(referencingFile);
            MetadataModel<EjbJarMetadata> metadataModel = ejbModule.getMetadataModel();
            final boolean[] write = new boolean[]{false};
            String resourceName = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) {
                    Ejb ejb = metadata.findByEjbClass(referencingClass);
                    if (ejb == null) {
                        return ref.getMessageDestinationRefName();
                    }
                    try {
                        for (MessageDestinationRef mdRef : ejb.getMessageDestinationRef()) {
                            if (!mdRef.getMessageDestinationRefName().equals(ref.getMessageDestinationRefName())) continue;
                            return mdRef.getMessageDestinationRefName();
                        }
                    }
                    catch (VersionNotSupportedException ex) {
                        Logger.getLogger("global").log(Level.INFO, null, ex);
                    }
                    String destinationRefName = ERC.this.getUniqueMessageDestRefName(ejb, ref.getMessageDestinationRefName());
                    try {
                        MessageDestinationRef messageDestinationRef = ejb.newMessageDestinationRef();
                        EnterpriseReferenceSupport.populate(ref, destinationRefName, messageDestinationRef);
                        ejb.addMessageDestinationRef(messageDestinationRef);
                    }
                    catch (VersionNotSupportedException vnse) {
                        // empty catch block
                    }
                    write[0] = true;
                    return destinationRefName;
                }
            });
            if (write[0]) {
                this.writeDD(ejbModule);
            }
            return resourceName;
        }

        private boolean isJdbcConnectionAlreadyUsed(Ejb ejb, ResourceReference ref) throws IOException {
            if (DataSource.class.getName().equals(ref.getResType())) {
                for (ResourceRef existingRef : ejb.getResourceRef()) {
                    boolean canCompareDefDesc;
                    String newDefaultDescription = ref.getDefaultDescription();
                    String existingDefaultDescription = existingRef.getDefaultDescription();
                    boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                    if (!DataSource.class.getName().equals(existingRef.getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(existingRef.getResRefName())) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isResourceRefUsed(Ejb ejb, ResourceReference resRef) {
            String resRefName = resRef.getResRefName();
            String resRefType = resRef.getResType();
            for (ResourceRef existingRef : ejb.getResourceRef()) {
                if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
                return true;
            }
            return false;
        }

        private String getUnigueName(Set<String> existingNames, String originalValue) {
            String proposedValue = originalValue;
            int index = 1;
            while (existingNames.contains(proposedValue)) {
                proposedValue = originalValue + Integer.toString(index++);
            }
            return proposedValue;
        }

        private String getUniqueResRefName(Ejb bean, String originalValue) {
            HashSet<String> resRefNames = new HashSet<String>();
            for (ResourceRef resourceRef : bean.getResourceRef()) {
                resRefNames.add(resourceRef.getResRefName());
            }
            return this.getUnigueName(resRefNames, originalValue);
        }

        private String getUniqueEjbRefName(Ejb bean, String originalValue) {
            HashSet<String> ejbRefNames = new HashSet<String>();
            for (EjbRef ejbRef : bean.getEjbRef()) {
                ejbRefNames.add(ejbRef.getEjbRefName());
            }
            return this.getUnigueName(ejbRefNames, originalValue);
        }

        private String getUniqueEjbLocalRefName(Ejb bean, String originalValue) {
            HashSet<String> ejbLocalRefNames = new HashSet<String>();
            for (EjbLocalRef ejbLocalRef : bean.getEjbLocalRef()) {
                ejbLocalRefNames.add(ejbLocalRef.getEjbRefName());
            }
            return this.getUnigueName(ejbLocalRefNames, originalValue);
        }

        private String getUniqueMessageDestRefName(Ejb bean, String originalValue) {
            HashSet<String> messageDestRefNames = new HashSet<String>();
            try {
                for (MessageDestinationRef messageDestRef : bean.getMessageDestinationRef()) {
                    messageDestRefNames.add(messageDestRef.getMessageDestinationRefName());
                }
            }
            catch (VersionNotSupportedException vnse) {
                Exceptions.printStackTrace((Throwable)vnse);
            }
            return this.getUnigueName(messageDestRefNames, originalValue);
        }

        private static boolean isDescriptorMandatory(Profile j2eeVersion) {
            return Profile.J2EE_13.equals(j2eeVersion) || Profile.J2EE_14.equals(j2eeVersion);
        }
    }
}

