/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    final Attr attr;
    final TreeMaker make;
    final Log log;
    final Symtab syms;
    final Names names;
    final Resolve rs;
    final Types types;
    final ConstFold cfolder;
    final Check chk;
    public int enterCount = 0;
    ListBuffer<Annotator> q = new ListBuffer();

    public static Annotate instance(Context context) {
        Annotate instance = context.get(annotateKey);
        if (instance == null) {
            instance = new Annotate(context);
        }
        return instance;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
    }

    public void later(Annotator a) {
        this.q.append(a);
    }

    public void earlier(Annotator a) {
        this.q.prepend(a);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().enterAnnotation();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        List<JCTree.JCExpression> args;
        Type at = a.annotationType.type != null ? a.annotationType.type : this.attr.attribType(a.annotationType, env);
        a.type = this.chk.checkType(a.annotationType.pos(), at, expected);
        boolean isError = a.type.isErroneous();
        if ((a.type.tsym.flags() & 0x2000L) == 0L) {
            this.log.error(a.annotationType.pos(), "not.annotation.type", a.type.toString());
            isError = true;
        }
        if ((args = a.args).length() == 1 && ((JCTree.JCExpression)args.head).getTag() != 30) {
            args.head = this.make.at(TreeInfo.getStartPos((JCTree)args.head)).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)args.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> tl = args;
        while (tl.nonEmpty()) {
            JCTree.JCExpression t = (JCTree.JCExpression)tl.head;
            if (t.getTag() != 30) {
                this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
            } else {
                JCTree.JCAssign assign = (JCTree.JCAssign)t;
                if (assign.lhs.getTag() != 35) {
                    this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
                } else {
                    Symbol method;
                    JCTree.JCIdent left = (JCTree.JCIdent)assign.lhs;
                    left.sym = method = this.rs.resolveQualifiedMethod(left.pos(), env, a.type, left.name, List.<Type>nil(), null);
                    left.type = method.type;
                    if (method.owner != a.type.tsym && !isError) {
                        this.log.error(left.pos(), "no.annotation.member", left.name, a.type);
                    }
                    Type result = method.type.getReturnType();
                    Attribute value = this.enterAttributeValue(result, assign.rhs, env);
                    if (!method.type.isErroneous() && !(value instanceof Attribute.Error)) {
                        buf.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)method, value));
                    }
                    t.type = result;
                }
            }
            tl = tl.tail;
        }
        return new Attribute.Compound(a.type, buf.toList());
    }

    Attribute enterAttributeValue(Type expected, JCTree.JCExpression tree, Env<AttrContext> env) {
        if (expected.isErroneous()) {
            switch (tree.getTag()) {
                case 43: {
                    return this.enterAnnotation((JCTree.JCAnnotation)tree, expected, env);
                }
                case 28: {
                    JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
                    if (na.elemtype != null) {
                        this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
                        return new Attribute.Error(expected);
                    }
                    ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
                    List<JCTree.JCExpression> l = na.elems;
                    while (l.nonEmpty()) {
                        Attribute value = this.enterAttributeValue(this.types.elemtype(expected), (JCTree.JCExpression)l.head, env);
                        if (!(value instanceof Attribute.Error)) {
                            buf.append(value);
                        }
                        l = l.tail;
                    }
                    return new Attribute.Array(expected, buf.toArray(new Attribute[buf.length()]));
                }
            }
            return new Attribute.Error(this.attr.attribExpr(tree, env, expected));
        }
        if (expected.isPrimitive() || this.types.isSameType(expected, this.syms.stringType)) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(expected);
            }
            if (result.constValue() == null) {
                this.log.error(tree.pos(), "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            result = this.cfolder.coerce(result, expected);
            return new Attribute.Constant(expected, result.constValue());
        }
        if (expected.tsym == this.syms.classType.tsym) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(expected);
            }
            if (TreeInfo.name(tree) != this.names._class) {
                this.log.error(tree.pos(), "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(expected);
            }
            return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)tree).selected.type);
        }
        if ((expected.tsym.flags() & 0x2000L) != 0L) {
            if (tree.getTag() != 43) {
                this.log.error(tree.pos(), "annotation.value.must.be.annotation", new Object[0]);
                return new Attribute.Error(expected);
            }
            return this.enterAnnotation((JCTree.JCAnnotation)tree, expected, env);
        }
        if (expected.tag == 11) {
            if (tree.getTag() != 28) {
                tree = this.make.at(tree.pos).NewArray(null, List.<JCTree.JCExpression>nil(), List.of(tree));
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
                return new Attribute.Error(expected);
            }
            ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                Attribute value = this.enterAttributeValue(this.types.elemtype(expected), (JCTree.JCExpression)l.head, env);
                if (!(value instanceof Attribute.Error)) {
                    buf.append(value);
                }
                l = l.tail;
            }
            na.type = expected;
            return new Attribute.Array(expected, buf.toArray(new Attribute[buf.length()]));
        }
        if (expected.tag == 10 && (expected.tsym.flags() & 0x4000L) != 0L) {
            this.attr.attribExpr(tree, env, expected);
            Symbol sym = TreeInfo.symbol(tree);
            if (sym == null || TreeInfo.nonstaticSelect(tree) || sym.kind != 4 || (sym.flags() & 0x4000L) == 0L) {
                this.log.error(tree.pos(), "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            Symbol.VarSymbol enumerator = (Symbol.VarSymbol)sym;
            return new Attribute.Enum(expected, enumerator);
        }
        this.log.error(tree.pos(), "annotation.value.not.allowable.type", new Object[0]);
        return new Attribute.Error(this.attr.attribExpr(tree, env, expected));
    }

    public static interface Annotator {
        public void enterAnnotation();

        public String toString();
    }
}

