/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbrefactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbrefactoring.EjbRefactoringPlugin;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class EjbRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        FileObject source = this.getRefactoringSource(refactoring);
        if (source == null) {
            return null;
        }
        List<EjbJar> ejbJars = this.getEjbJars(source);
        if (ejbJars.isEmpty()) {
            return null;
        }
        String ejbJarPaths = this.getEjbJarPaths(ejbJars);
        String msg = null;
        msg = refactoring instanceof RenameRefactoring ? "TXT_EjbJarRenameWarning" : (refactoring instanceof SafeDeleteRefactoring ? "TXT_EjbJarSafeDeleteWarning" : (refactoring instanceof MoveRefactoring ? "TXT_EjbJarMoveClassWarning" : (refactoring instanceof WhereUsedQuery ? "TXT_EjbJarWhereUsedWarning" : "TXT_EjbJarGeneralWarning")));
        return new EjbRefactoringPlugin(refactoring, NbBundle.getMessage(EjbRefactoringFactory.class, (String)msg, (Object)ejbJarPaths));
    }

    private String getEjbJarPaths(List<EjbJar> ejbJars) {
        StringBuilder ejbJarPaths = new StringBuilder();
        Iterator<EjbJar> it = ejbJars.iterator();
        while (it.hasNext()) {
            EjbJar ejbJar = it.next();
            String path = FileUtil.getFileDisplayName((FileObject)ejbJar.getDeploymentDescriptor());
            ejbJarPaths.append(path);
            if (!it.hasNext()) continue;
            ejbJarPaths.append(", ");
        }
        return ejbJarPaths.toString();
    }

    private FileObject getRefactoringSource(AbstractRefactoring refactoring) {
        FileObject source = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        if (source != null) {
            return source;
        }
        TreePathHandle tph = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            return tph.getFileObject();
        }
        NonRecursiveFolder folder = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return folder.getFolder();
        }
        return null;
    }

    private List<EjbJar> getEjbJars(FileObject source) {
        ArrayList<EjbJar> result = new ArrayList<EjbJar>();
        for (EjbJar each : EjbRefactoringFactory.getRelevantEjbModules(source)) {
            FileObject ejbJarFO = each.getDeploymentDescriptor();
            if (ejbJarFO == null) continue;
            result.add(each);
        }
        return result;
    }

    private static Collection<EjbJar> getRelevantEjbModules(FileObject fo) {
        Project affectedProject = FileOwnerQuery.getOwner((FileObject)fo);
        ArrayList<EjbJar> ejbmodules = new ArrayList<EjbJar>();
        ArrayList<Project> projects = new ArrayList<Project>();
        if (affectedProject != null) {
            EjbJar emod = EjbJar.getEjbJar((FileObject)affectedProject.getProjectDirectory());
            if (emod == null) {
                return Collections.EMPTY_SET;
            }
            projects.add(affectedProject);
            for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                EjbJar em;
                Set subprojects;
                Object obj;
                J2eeModuleProvider affectedPrjProvider;
                J2eeApplicationProvider j2eeApp;
                J2eeModuleProvider[] j2eeModules;
                Object isJ2eeApp = project.getLookup().lookup(J2eeApplicationProvider.class);
                if (isJ2eeApp != null && (j2eeModules = (j2eeApp = (J2eeApplicationProvider)isJ2eeApp).getChildModuleProviders()) != null && (affectedPrjProvider = (J2eeModuleProvider)affectedProject.getLookup().lookup(J2eeModuleProvider.class)) != null && Arrays.asList(j2eeModules).contains(affectedPrjProvider)) {
                    for (int k = 0; k < j2eeModules.length; ++k) {
                        FileObject srcRoot;
                        Project p;
                        FileObject[] sourceRoots = j2eeModules[k].getSourceRoots();
                        if (sourceRoots == null || sourceRoots.length <= 0 || (p = FileOwnerQuery.getOwner((FileObject)(srcRoot = sourceRoots[0]))) == null || projects.contains(p)) continue;
                        projects.add(p);
                    }
                }
                if ((obj = project.getLookup().lookup(SubprojectProvider.class)) == null || !(obj instanceof SubprojectProvider) || !(subprojects = ((SubprojectProvider)obj).getSubprojects()).contains(affectedProject) || (em = EjbJar.getEjbJar((FileObject)project.getProjectDirectory())) == null || projects.contains(project)) continue;
                projects.add(project);
            }
        }
        for (int j = 0; j < projects.size(); ++j) {
            Project prj = (Project)projects.get(j);
            EjbJar ejb = EjbJar.getEjbJar((FileObject)prj.getProjectDirectory());
            if (ejb == null) continue;
            ejbmodules.add(ejb);
        }
        return ejbmodules;
    }
}

