/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteServerSetup {
    private final Map<String, File> binarySetupMap;
    private final Map<ExecutionEnvironment, List<String>> updateMap;
    private final ExecutionEnvironment executionEnvironment;
    private boolean cancelled;
    private boolean failed;
    private String reason;
    private String libDir;

    RemoteServerSetup(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(SetupProvider.class));
        Collection list = results.allInstances();
        SetupProvider[] providers = list.toArray(new SetupProvider[list.size()]);
        this.libDir = HostInfoProvider.getLibDir((ExecutionEnvironment)executionEnvironment);
        if (!this.libDir.endsWith("/")) {
            this.libDir = this.libDir + "/";
        }
        this.binarySetupMap = new HashMap<String, File>();
        for (SetupProvider provider : providers) {
            Map map = provider.getBinaryFiles(executionEnvironment);
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                this.binarySetupMap.put(this.libDir + (String)entry.getKey(), (File)entry.getValue());
            }
        }
        this.updateMap = new HashMap<ExecutionEnvironment, List<String>>();
    }

    boolean needsSetupOrUpdate() {
        List<Object> updateList = new ArrayList();
        this.updateMap.clear();
        if (!this.isFailedOrCanceled()) {
            updateList = this.getBinaryUpdates();
        }
        if (this.isFailedOrCanceled()) {
            return false;
        }
        if (!updateList.isEmpty()) {
            this.updateMap.put(this.executionEnvironment, updateList);
            return true;
        }
        return false;
    }

    protected void setup() {
        List<String> list = this.updateMap.remove(this.executionEnvironment);
        for (String path : list) {
            RemoteUtil.LOGGER.log(Level.FINE, "RSS.setup: Updating \"{0}\" on {1}", new Object[]{path, this.executionEnvironment});
            if (!this.binarySetupMap.containsKey(path)) continue;
            File file = this.binarySetupMap.get(path);
            CndUtils.assertAbsoluteFileInConsole((File)file);
            String remotePath = path;
            try {
                if (file != null && file.exists() && this.copyTo(file, remotePath)) continue;
                throw new Exception();
            }
            catch (Exception ex) {
                this.setFailed(NbBundle.getMessage(RemoteServerSetup.class, (String)"ERR_UpdateSetupFailure", (Object)this.executionEnvironment, (Object)path));
            }
        }
    }

    private boolean copyTo(File file, String remoteFilePath) throws InterruptedException, ExecutionException {
        return (Integer)CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)remoteFilePath, (int)509, null, (boolean)true).get() == 0;
    }

    private List<String> getBinaryUpdates() {
        return new ArrayList<String>(this.binarySetupMap.keySet());
    }

    public String getReason() {
        return this.reason;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    private void setFailed(String reason) {
        this.failed = true;
        this.reason = reason;
    }

    protected boolean isFailed() {
        return this.failed;
    }

    private boolean isFailedOrCanceled() {
        return this.failed || this.cancelled;
    }
}

