/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.mapper.HostMappingsAnalyzer;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditPathMapDialog
extends JPanel
implements ActionListener {
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private static final String ACTION_ESCAPE_TABLE = "escapeTable";
    private static final String ACTION_TAB_IN_CELL = "tabInCell";
    private static final String ACTION_SHIFT_TAB_IN_CELL = "shiftTabInCell";
    private final JButton btnOK;
    private Dialog presenter;
    private final ServerRecord currentHost;
    private final DefaultComboBoxModel serverListModel;
    private final List<String> pathsToValidate;
    private final Map<ServerRecord, PathMapTableModel> cache = new HashMap<ServerRecord, PathMapTableModel>();
    private ProgressHandle phandle;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblHostName;
    private JButton restore;
    private JTable tblPathMappings;
    private JTextField tfHostName;
    private JTextArea txtError;
    private JTextArea txtExplanation;
    private Action editAction;

    public static boolean showMe(ServerRecord host) {
        return EditPathMapDialog.showMe(host, Collections.<String>emptyList());
    }

    public static boolean showMe(ExecutionEnvironment execEnv, List<String> pathsToValidate) {
        return EditPathMapDialog.showMe(ServerList.get((ExecutionEnvironment)execEnv), pathsToValidate == null ? Collections.emptyList() : pathsToValidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean showMe(ServerRecord host, List<String> pathsToValidate) {
        Dialog dialog;
        JButton btnOK = new JButton(NbBundle.getMessage(EditPathMapDialog.class, (String)"BTN_OK"));
        EditPathMapDialog dlg = new EditPathMapDialog(host, pathsToValidate, ServerList.getRecords(), btnOK);
        DialogDescriptor dd = new DialogDescriptor((Object)dlg, NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialogTitle"), true, new Object[]{btnOK, DialogDescriptor.CANCEL_OPTION}, (Object)btnOK, 0, null, (ActionListener)dlg);
        dd.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        dlg.presenter = dialog = DialogDisplayer.getDefault().createDialog(dd);
        try {
            dialog.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            dd.setValue(DialogDescriptor.CANCEL_OPTION);
        }
        finally {
            dialog.setVisible(false);
        }
        if (dd.getValue() == btnOK) {
            dlg.applyChanges();
            return true;
        }
        return false;
    }

    protected EditPathMapDialog(ServerRecord defaultHost, List<String> pathsToValidate, Collection<? extends ServerRecord> hostList, JButton btnOK) {
        String explanationText;
        this.btnOK = btnOK;
        this.pathsToValidate = pathsToValidate;
        this.currentHost = defaultHost;
        this.serverListModel = new DefaultComboBoxModel();
        for (ServerRecord serverRecord : hostList) {
            if (!serverRecord.isRemote()) continue;
            this.serverListModel.addElement(serverRecord);
        }
        this.initComponents();
        this.addTableActions();
        this.tfHostName.setBackground(this.getBackground());
        this.tfHostName.setText(this.currentHost.getDisplayName());
        this.initTable();
        if (!this.pathsToValidate.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String path : this.pathsToValidate) {
                String message = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_ExplanationOnePath", (Object)path);
                stringBuilder.append(message);
            }
            explanationText = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_ExplanationWithAllPaths", (Object)stringBuilder);
        } else {
            explanationText = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Explanation");
        }
        this.txtExplanation.setText(explanationText);
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane3.setOpaque(false);
        }
        this.initTableModel();
    }

    private void initTable() {
        this.tblPathMappings.getTableHeader().setPreferredSize(new Dimension(0, 20));
        this.tblPathMappings.getTableHeader().setFocusable(false);
        this.tblPathMappings.getTableHeader().setEnabled(false);
        this.tblPathMappings.getSelectionModel().setSelectionMode(1);
        this.tblPathMappings.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.tblPathMappings.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.tblPathMappings.getActionMap().put(ACTION_INLINE_EDITOR, this.getEditAction());
        this.tblPathMappings.setSurrendersFocusOnKeystroke(true);
        this.tblPathMappings.setCellSelectionEnabled(false);
        this.tblPathMappings.setRowSelectionAllowed(true);
        this.tblPathMappings.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.tblPathMappings.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblPathMappings.getInputMap().put(KeyStroke.getKeyStroke(27, 0), ACTION_ESCAPE_TABLE);
        this.tblPathMappings.getActionMap().put(ACTION_ESCAPE_TABLE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPathMapDialog.this.btnOK.requestFocus();
            }
        });
    }

    private static RemotePathMap getRemotePathMap(ExecutionEnvironment host) {
        return RemotePathMap.getPathMap(host);
    }

    private void addTableActions() throws MissingResourceException {
        AbstractAction removeAction = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACTION_Remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = EditPathMapDialog.this.tblPathMappings.getSelectedRows();
                if (rows.length > 0) {
                    DefaultTableModel model = (DefaultTableModel)EditPathMapDialog.this.tblPathMappings.getModel();
                    Arrays.sort(rows);
                    for (int i = rows.length - 1; i >= 0; --i) {
                        model.removeRow(rows[i]);
                    }
                }
            }
        };
        AbstractAction insertAction = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACTION_Insert")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = EditPathMapDialog.this.tblPathMappings.getSelectedRow();
                row = row < 0 ? 0 : row;
                DefaultTableModel model = (DefaultTableModel)EditPathMapDialog.this.tblPathMappings.getModel();
                model.insertRow(row, new Object[]{"", ""});
            }
        };
        final JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(insertAction));
        menu.add(new JMenuItem(removeAction));
        class MenuListener
        extends MouseAdapter {
            MenuListener() {
            }

            private void showMenu(MouseEvent evt) {
                if (evt != null) {
                    int row = EditPathMapDialog.this.tblPathMappings.rowAtPoint(evt.getPoint());
                    if (row >= 0 && EditPathMapDialog.this.tblPathMappings.getSelectionModel().isSelectionEmpty()) {
                        EditPathMapDialog.this.tblPathMappings.getSelectionModel().setSelectionInterval(row, row);
                    }
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showMenu(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showMenu(evt);
                }
            }
        }
        MenuListener menuListener = new MenuListener();
        this.tblPathMappings.addMouseListener(menuListener);
    }

    private synchronized void initTableModel() {
        PathMapTableModel tableModel = this.cache.get(this.currentHost);
        if (tableModel == null) {
            this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Loading"));
            this.handleProgress(true);
            tableModel = new PathMapTableModel();
            this.cache.put(this.currentHost, tableModel);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    final PathMapTableModel tm = EditPathMapDialog.this.prepareTableModel(EditPathMapDialog.this.currentHost.getExecutionEnvironment());
                    EditPathMapDialog.this.cache.put(EditPathMapDialog.this.currentHost, tm);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditPathMapDialog.this.handleProgress(false);
                            EditPathMapDialog.this.updatePathMappingsTable(tm);
                            EditPathMapDialog.this.enableControls(true, "");
                        }
                    });
                }
            });
        }
        this.updatePathMappingsTable(tableModel);
    }

    private PathMapTableModel prepareTableModel(Map<String, String> pm) {
        PathMapTableModel tableModel = new PathMapTableModel();
        for (Map.Entry<String, String> entry : pm.entrySet()) {
            tableModel.addRow(new String[]{entry.getKey(), entry.getValue()});
        }
        if (tableModel.getRowCount() < 4) {
            for (int i = 4; i > tableModel.getRowCount(); --i) {
                tableModel.addRow(new String[]{null, null});
            }
        } else {
            tableModel.addRow(new String[]{null, null});
        }
        return tableModel;
    }

    private void enableControls(boolean value, String message) {
        this.btnOK.setEnabled(value);
        this.restore.setEnabled(value);
        this.tblPathMappings.setEnabled(value);
        this.txtError.setText(message);
    }

    private void updatePathMappingsTable(DefaultTableModel tableModel) {
        this.tblPathMappings.setModel(tableModel);
    }

    private PathMapTableModel prepareTableModel(ExecutionEnvironment host) {
        Map<String, String> pm = EditPathMapDialog.getRemotePathMap(host).getMap();
        return this.prepareTableModel(pm);
    }

    void applyChanges() {
        for (ServerRecord host : this.cache.keySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            DefaultTableModel model = this.cache.get(host);
            for (int i = 0; i < model.getRowCount(); ++i) {
                String local = (String)model.getValueAt(i, 0);
                String remote = (String)model.getValueAt(i, 1);
                if (local == null || remote == null) continue;
                local = local.trim();
                remote = remote.trim();
                if (local.length() <= 0 || remote.length() <= 0) continue;
                map.put(local, remote);
            }
            EditPathMapDialog.getRemotePathMap(host.getExecutionEnvironment()).updatePathMap(map);
        }
    }

    private void initComponents() {
        this.lblHostName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblPathMappings = new PathTable();
        this.jScrollPane2 = new JScrollPane();
        this.txtExplanation = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.txtError = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfHostName = new JTextField();
        this.restore = new JButton();
        this.lblHostName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("EPMD_Hostname").charAt(0));
        this.lblHostName.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.lblHostName.text"));
        this.lblHostName.setFocusable(false);
        this.tblPathMappings.setModel(new PathMapTableModel());
        this.tblPathMappings.getTableHeader().setResizingAllowed(false);
        this.tblPathMappings.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblPathMappings);
        this.tblPathMappings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AN"));
        this.tblPathMappings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AD"));
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setEnabled(false);
        this.jScrollPane2.setFocusable(false);
        this.txtExplanation.setBackground(this.getBackground());
        this.txtExplanation.setColumns(20);
        this.txtExplanation.setLineWrap(true);
        this.txtExplanation.setRows(4);
        this.txtExplanation.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.txtExplanation.text"));
        this.txtExplanation.setWrapStyleWord(true);
        this.txtExplanation.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.txtExplanation.setFocusable(false);
        this.jScrollPane2.setViewportView(this.txtExplanation);
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setEnabled(false);
        this.jScrollPane3.setFocusable(false);
        this.txtError.setBackground(this.getBackground());
        this.txtError.setColumns(20);
        this.txtError.setForeground(new Color(255, 0, 0));
        this.txtError.setLineWrap(true);
        this.txtError.setRows(4);
        this.txtError.setWrapStyleWord(true);
        this.txtError.setFocusable(false);
        this.jScrollPane3.setViewportView(this.txtError);
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setLabelFor(this.tblPathMappings);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AN"));
        this.tfHostName.setEditable(false);
        this.tfHostName.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.tfHostName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.restore, (String)NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.restore.text"));
        this.restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPathMapDialog.this.restoreActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 447, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 447, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 447, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 447, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblHostName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tfHostName, -1, 400, Short.MAX_VALUE)).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.restore)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblHostName).addComponent(this.tfHostName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 61, -2).addGap(5, 5, 5).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 99, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 23, -2).addGap(27, 27, 27).addComponent(this.jScrollPane3, -2, 135, -2).addGap(7, 7, 7).addComponent(this.restore).addContainerGap()));
        this.lblHostName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Hostname"));
        this.lblHostName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Host_AD"));
    }

    private void restoreActionPerformed(ActionEvent evt) {
        this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Loading"));
        this.handleProgress(true);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                HostMappingsAnalyzer an = new HostMappingsAnalyzer(EditPathMapDialog.this.currentHost.getExecutionEnvironment());
                final PathMapTableModel tm = EditPathMapDialog.this.prepareTableModel(an.getMappings());
                EditPathMapDialog.this.cache.put(EditPathMapDialog.this.currentHost, tm);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (EditPathMapDialog.this.tblPathMappings != null) {
                            EditPathMapDialog.this.handleProgress(false);
                            EditPathMapDialog.this.updatePathMappingsTable(tm);
                            EditPathMapDialog.this.enableControls(true, "");
                        }
                    }
                });
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOK) {
            if (this.cache.get(this.currentHost).getRowCount() == 0) {
                this.presenter.setVisible(false);
                return;
            }
            this.handleProgress(true);
            this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Validating"));
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    final String errors = EditPathMapDialog.this.validateMaps();
                    Runnable action = errors.length() == 0 ? new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            EditPathMapDialog.this.presenter.setVisible(false);
                        }
                    } : new Runnable(){

                        @Override
                        public void run() {
                            EditPathMapDialog.this.handleProgress(false);
                            EditPathMapDialog.this.enableControls(true, errors);
                        }
                    };
                    SwingUtilities.invokeLater(action);
                }
            });
        }
    }

    private void handleProgress(boolean start) {
        if (start) {
            this.phandle = ProgressHandleFactory.createHandle((String)"");
            this.jPanel1.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.phandle), "North");
            this.jPanel1.setVisible(true);
            this.phandle.start();
        } else {
            this.phandle.finish();
            this.jPanel1.setVisible(false);
            this.jPanel1.removeAll();
        }
    }

    private String validateMaps() {
        DefaultTableModel model = this.cache.get(this.currentHost);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> pathsToValidateCopy = new ArrayList<String>(this.pathsToValidate);
        for (int i = 0; i < model.getRowCount(); ++i) {
            String local = (String)model.getValueAt(i, 0);
            String remote = (String)model.getValueAt(i, 1);
            if (local != null && (local = local.trim()).length() > 0) {
                if (!HostInfoProvider.fileExists((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)local)) {
                    sb.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadLocalPath", (Object)local));
                }
                if (!pathsToValidateCopy.isEmpty()) {
                    for (String pathToValidate : this.pathsToValidate) {
                        if (remote == null || !RemotePathMap.isSubPath(local, pathToValidate)) continue;
                        pathsToValidateCopy.remove(pathToValidate);
                        break;
                    }
                }
            }
            if (remote == null || (remote = remote.trim()).length() <= 0 || HostInfoProvider.fileExists((ExecutionEnvironment)this.currentHost.getExecutionEnvironment(), (String)remote)) continue;
            sb.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadRemotePath", (Object)remote));
        }
        if (!pathsToValidateCopy.isEmpty()) {
            StringBuilder sb2 = new StringBuilder();
            for (String path : pathsToValidateCopy) {
                sb2.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_OnePathNotResolved", (Object)path));
            }
            sb.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_AllPathsNotResolved", (Object)sb2));
        }
        return sb.toString();
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditAction();
        }
        return this.editAction;
    }

    private static void autoEdit(JTable tab) {
        if (tab.editCellAt(tab.getSelectedRow(), tab.getSelectedColumn(), null) && tab.getEditorComponent() != null) {
            if (tab.getSelectedColumn() == 0) {
                JPanel panel = (JPanel)tab.getEditorComponent();
                JTextField field = (JTextField)panel.getComponent(0);
                field.setCaretPosition(field.getText().length());
                field.requestFocusInWindow();
                field.selectAll();
            } else {
                JPanel panel = (JPanel)tab.getEditorComponent();
                JTextField field = (JTextField)panel.getComponent(0);
                field.setCaretPosition(field.getText().length());
                field.requestFocusInWindow();
                field.selectAll();
            }
        }
    }

    private class PathTable
    extends JTable {
        private PathTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 0: {
                    return new PathCellEditor(ExecutionEnvironmentFactory.getLocal());
                }
                case 1: {
                    return new PathCellEditor(EditPathMapDialog.this.currentHost.getExecutionEnvironment());
                }
            }
            throw new IllegalArgumentException("Invalid column number" + column);
        }
    }

    private static class PathMapTableModel
    extends DefaultTableModel {
        public PathMapTableModel() {
            super(new String[]{NbBundle.getMessage(EditPathMapDialog.class, (String)"LocalPathColumnName"), NbBundle.getMessage(EditPathMapDialog.class, (String)"RemotePathColumnName")}, 0);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    private static class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            EditPathMapDialog.autoEdit((JTable)ae.getSource());
        }
    }

    private static class PathCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final JPanel panel;
        private final JTextField tfPath;
        private final JButton btnBrowse;
        private final ExecutionEnvironment execEnv;

        public PathCellEditor(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
            this.tfPath = new JTextField();
            this.btnBrowse = new JButton(NbBundle.getMessage(EditPathMapDialog.class, (String)"BTN_Browse"));
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.tfPath.setBorder(BorderFactory.createEmptyBorder());
            this.btnBrowse.setPreferredSize(new Dimension(20, this.btnBrowse.getMinimumSize().height));
            this.panel.add((Component)this.tfPath, "Center");
            this.panel.add((Component)this.btnBrowse, "East");
            this.btnBrowse.addActionListener(this);
            this.tfPath.getInputMap().put(KeyStroke.getKeyStroke(9, 0), EditPathMapDialog.ACTION_TAB_IN_CELL);
            this.tfPath.getActionMap().put(EditPathMapDialog.ACTION_TAB_IN_CELL, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathCellEditor.this.tfPath.setSelectionStart(0);
                    PathCellEditor.this.tfPath.setSelectionEnd(0);
                    PathCellEditor.this.btnBrowse.requestFocus();
                    PathCellEditor.this.btnBrowse.setSelected(true);
                }
            });
            this.btnBrowse.getInputMap().put(KeyStroke.getKeyStroke(9, 1), EditPathMapDialog.ACTION_SHIFT_TAB_IN_CELL);
            this.btnBrowse.getActionMap().put(EditPathMapDialog.ACTION_SHIFT_TAB_IN_CELL, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathCellEditor.this.tfPath.setSelectionStart(0);
                    PathCellEditor.this.tfPath.setSelectionEnd(PathCellEditor.this.tfPath.getText().length());
                    PathCellEditor.this.btnBrowse.setSelected(false);
                    PathCellEditor.this.tfPath.requestFocus();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = this.execEnv.isLocal() ? NbBundle.getMessage(EditPathMapDialog.class, (String)"DIR_Choose_Title_Local") : NbBundle.getMessage(EditPathMapDialog.class, (String)"DIR_Choose_Title_Remote", (Object)ServerList.get((ExecutionEnvironment)this.execEnv).getDisplayName());
            FileChooserBuilder.JFileChooserEx fc = new FileChooserBuilder(this.execEnv).createFileChooser(this.tfPath.getText());
            fc.setFileSelectionMode(1);
            fc.setApproveButtonText(NbBundle.getMessage(EditPathMapDialog.class, (String)"BTN_Choose"));
            fc.setDialogTitle(title);
            fc.setApproveButtonMnemonic(10);
            if (fc.showOpenDialog(this.panel) == 0) {
                this.tfPath.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.tfPath.getText().trim();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tfPath.setText((String)value);
            return this.panel;
        }
    }
}

