/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Image;
import java.util.List;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.ui.FileSystemNode;
import org.netbeans.modules.remote.ui.NotConnectedNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class FileSystemRootNode
extends AbstractNode {
    private final ExecutionEnvironment env;

    public FileSystemRootNode(ExecutionEnvironment env) {
        super(FileSystemRootNode.createChildren(env), Lookups.fixed((Object[])new Object[]{env}));
        this.env = env;
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/fs_open.gif");
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/fs.gif");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_FileSystemRootNode");
    }

    private static Children createChildren(ExecutionEnvironment env) {
        return Children.create((ChildFactory)new FileSystemRootChildren(env), (boolean)true);
    }

    private static FileObject getRootFileObject(ExecutionEnvironment env) {
        FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        FileObject fo = fs.getRoot();
        return fo;
    }

    void refresh() {
        this.setChildren(FileSystemRootNode.createChildren(this.env));
    }

    private static class FileSystemRootChildren
    extends ChildFactory<Kind> {
        private final ExecutionEnvironment env;
        private final FileObject rootFileObject;

        public FileSystemRootChildren(ExecutionEnvironment env) {
            this.env = env;
            this.rootFileObject = FileSystemRootNode.getRootFileObject(env);
        }

        protected boolean createKeys(List<Kind> toPopulate) {
            if (ConnectionManager.getInstance().isConnectedTo(this.env)) {
                toPopulate.add(Kind.ROOT);
                toPopulate.add(Kind.HOME);
                toPopulate.add(Kind.MIRROR);
            } else {
                toPopulate.add(Kind.DISCONNECTED);
            }
            return true;
        }

        protected Node createNodeForKey(Kind key) {
            FileObject fo;
            switch (key) {
                case DISCONNECTED: {
                    return new NotConnectedNode(this.env);
                }
                case HOME: {
                    String homeDir = RemoteUtil.getHomeDirectory(this.env);
                    fo = this.rootFileObject.getFileObject(homeDir);
                    break;
                }
                case MIRROR: {
                    String mirror = RemotePathMap.getRemoteSyncRoot(this.env);
                    fo = this.rootFileObject.getFileObject(mirror);
                    break;
                }
                case ROOT: {
                    fo = this.rootFileObject;
                    break;
                }
                default: {
                    fo = this.rootFileObject;
                }
            }
            if (fo != null) {
                return new FileSystemNode(this.env, fo);
            }
            return null;
        }
    }

    private static enum Kind {
        HOME,
        MIRROR,
        ROOT,
        DISCONNECTED;

    }
}

