/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import java.util.Vector;

public class TypeDescriptorEntry {
    protected byte[] data;
    protected int offset;

    public TypeDescriptorEntry(JCPackage jCPackage, Info info, int n) {
        this.offset = n;
        switch (info.getType()) {
            case 2: 
            case 5: {
                String string = info.getDescriptor();
                this.data = this.pack(this.simpleDesc(jCPackage, string, 0, string.length()));
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                String string = info.getDescriptor();
                this.data = this.pack(this.compoundDesc(jCPackage, string, 0));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public TypeDescriptorEntry(Field field, int n) {
        this.offset = n;
        FieldDescriptor fieldDescriptor = field.getDescriptor();
        String string = fieldDescriptor.getDescriptorString();
        if (string != null) {
            this.data = this.pack(this.simpleDesc(field.getParentClass().getParentPackage(), string, 0, string.length()));
        } else {
            ClassIdentifier classIdentifier = fieldDescriptor.getClassIdentifier();
            PackageIdentifier packageIdentifier = classIdentifier.getPackageIdentifier();
            int n2 = field.getParentClass().getParentPackage().getPackageToken(packageIdentifier);
            this.data = this.pack(this.simpleDesc(n2, classIdentifier.getClassToken(), fieldDescriptor.isArray()));
        }
    }

    public TypeDescriptorEntry(String string, JCClass jCClass) {
        this.offset = 0;
        int n = string.indexOf(40);
        this.data = this.pack(this.compoundDesc(jCClass.getParentPackage(), string, n));
    }

    public TypeDescriptorEntry(JCMethod jCMethod, int n) {
        this.offset = n;
        String string = jCMethod.getName();
        int n2 = string.indexOf(40);
        this.data = this.pack(this.compoundDesc(jCMethod.getParentClass().getParentPackage(), string, n2));
    }

    int getOffset() {
        return this.offset;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypeDescriptorEntry)) {
            return false;
        }
        byte[] byArray = ((TypeDescriptorEntry)object).data;
        if (this.data.length != byArray.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    int size() {
        return this.data.length;
    }

    byte[] toByteArray() {
        return this.data;
    }

    private int[] compoundDesc(JCPackage jCPackage, String string, int n) {
        int n2;
        int[] nArray;
        assert (string.charAt(n) == '(') : "desc[offset] != '('";
        ++n;
        Vector<int[]> vector = new Vector<int[]>();
        int n3 = 0;
        block10: while (n < string.length()) {
            nArray = null;
            switch (string.charAt(n)) {
                case 'B': 
                case 'I': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    nArray = this.simpleDesc(jCPackage, string, n, 1);
                    vector.addElement(nArray);
                    n3 += nArray.length;
                    ++n;
                    continue block10;
                }
                case '[': {
                    switch (string.charAt(n + 1)) {
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            nArray = this.simpleDesc(jCPackage, string, n, 2);
                            vector.addElement(nArray);
                            n3 += nArray.length;
                            n += 2;
                            continue block10;
                        }
                        case 'L': {
                            n2 = string.indexOf(59, n);
                            assert (n2 != -1) : "end == -1";
                            nArray = this.simpleDesc(jCPackage, string, n, n2 - n + 1);
                            vector.addElement(nArray);
                            n3 += nArray.length;
                            n = n2 + 1;
                            continue block10;
                        }
                    }
                    throw new InternalError();
                }
                case 'L': {
                    n2 = string.indexOf(59, n);
                    assert (n2 != -1) : "end == -1";
                    nArray = this.simpleDesc(jCPackage, string, n, n2 - n + 1);
                    vector.addElement(nArray);
                    n3 += nArray.length;
                    n = n2 + 1;
                    continue block10;
                }
                case ')': {
                    ++n;
                    continue block10;
                }
            }
            throw new InternalError();
        }
        nArray = new int[n3];
        n2 = 0;
        for (int[] nArray2 : vector) {
            System.arraycopy(nArray2, 0, nArray, n2, nArray2.length);
            n2 += nArray2.length;
        }
        return nArray;
    }

    private int[] simpleDesc(JCPackage jCPackage, String string, int n, int n2) {
        int[] nArray;
        switch (string.charAt(n)) {
            case 'V': {
                nArray = new int[]{1};
                break;
            }
            case 'Z': {
                nArray = new int[]{2};
                break;
            }
            case 'B': {
                nArray = new int[]{3};
                break;
            }
            case 'S': {
                nArray = new int[]{4};
                break;
            }
            case 'I': {
                nArray = new int[]{5};
                break;
            }
            case 'L': {
                int n3;
                int n4;
                nArray = new int[5];
                nArray[0] = 6;
                String string2 = string.substring(++n, n + (n2 -= 2));
                int n5 = string2.indexOf(46);
                if (n5 != -1) {
                    String string3 = string2.substring(0, n5);
                    String string4 = string2.substring(n5 + 1);
                    n4 = Integer.decode(string3) | 0x80;
                    n3 = Integer.decode(string4);
                } else {
                    n4 = jCPackage.getDescriptorPackageToken(string2);
                    n3 = jCPackage.getDescriptorClassToken(string2);
                }
                nArray[1] = (byte)(n4 >> 4);
                nArray[2] = (byte)n4;
                nArray[3] = (byte)(n3 >> 4);
                nArray[4] = (byte)n3;
                break;
            }
            case '[': {
                nArray = this.simpleDesc(jCPackage, string, n + 1, n2 - 1);
                nArray[0] = nArray[0] | 8;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return nArray;
    }

    private int[] simpleDesc(int n, int n2, boolean bl) {
        int[] nArray = new int[]{bl ? -114 : 6, (byte)(n >> 4 | 8), (byte)n, (byte)(n2 >> 4), (byte)n2};
        return nArray;
    }

    private byte[] pack(int[] nArray) {
        byte[] byArray = new byte[(nArray.length + 1) / 2 + 1];
        byArray[0] = (byte)nArray.length;
        int n = 1;
        for (int i = 0; i < nArray.length; i += 2) {
            int n2 = nArray[i] & 0xFF;
            int n3 = 0;
            if (i + 1 < nArray.length) {
                n3 = nArray[i + 1] & 0xFF;
            }
            byArray[n++] = (byte)(n2 << 4 | n3);
        }
        return byArray;
    }

    public String toString() {
        return Msg.toHexString(this.toByteArray());
    }

    public byte[] getData() {
        return this.data;
    }
}

