/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.spring.container.servlet;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.spring.container.SpringComponentProviderFactory;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SpringServlet
extends ServletContainer {
    private static final long serialVersionUID = 5686655395749077671L;
    private static final Logger LOGGER = Logger.getLogger(SpringServlet.class.getName());
    public static final String CONTEXT_CONFIG_LOCATION = "contextConfigLocation";

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        return new DefaultResourceConfig();
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        try {
            wa.initiate(rc, (IoCComponentProviderFactory)new SpringComponentProviderFactory(rc, this.getContext()));
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Exception occurred when intialization", e);
            throw e;
        }
    }

    protected ConfigurableApplicationContext getContext() {
        String contextConfigLocation = this.getWebConfig().getInitParameter(CONTEXT_CONFIG_LOCATION);
        if (contextConfigLocation == null) {
            LOGGER.info("Using default applicationContext");
            return this.getDefaultContext();
        }
        LOGGER.info("Creating new child context from " + contextConfigLocation);
        return this.getChildContext(contextConfigLocation);
    }

    protected ConfigurableApplicationContext getDefaultContext() {
        WebApplicationContext springWebContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        ConfigurableApplicationContext springContext = (ConfigurableApplicationContext)springWebContext;
        return springContext;
    }

    protected ConfigurableApplicationContext getChildContext(String contextConfigLocation) {
        XmlWebApplicationContext ctx = new XmlWebApplicationContext();
        ctx.setParent((ApplicationContext)this.getDefaultContext());
        ctx.setServletContext(this.getServletContext());
        ctx.setConfigLocation(contextConfigLocation);
        ctx.refresh();
        return ctx;
    }
}

