/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.io.IOException;
import org.netbeans.modules.cnd.source.CppEditorSupportProvider;
import org.netbeans.modules.cnd.source.spi.CndCookieProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class SourceDataObject
extends MultiDataObject {
    static final long serialVersionUID = -6788084224129713370L;
    private InstanceContent ic;
    private Lookup myLookup;

    public SourceDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
    }

    final InstanceContent getInstanceContent() {
        return this.ic;
    }

    public final synchronized Lookup getLookup() {
        if (this.myLookup == null) {
            this.ic = new InstanceContent();
            this.ic.add((Object)this);
            this.ic.add((Object)this.getPrimaryFile());
            this.ic.add((Object)this, (InstanceContent.Convertor)CppEditorSupportProvider.staticFactory);
            this.ic.add((Object)this, (InstanceContent.Convertor)CppEditorSupportProvider.saveAsStaticFactory);
            CndCookieProvider.getDefault().addLookup((DataObject)this, this.ic);
            this.myLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        }
        return this.myLookup;
    }

    public final <T extends Node.Cookie> T getCookie(Class<T> type) {
        if (!Node.Cookie.class.isAssignableFrom(type)) {
            return null;
        }
        Object lookupResult = this.getLookup().lookup(type);
        if (lookupResult != null && !type.isInstance(lookupResult)) {
            return null;
        }
        Node.Cookie res = (Node.Cookie)lookupResult;
        return (T)res;
    }

    protected abstract Node createNodeDelegate();

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name != null && !SourceDataObject.isValidName(name)) {
            throw new IOException(NbBundle.getMessage(SourceDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)name));
        }
        return super.handleCreateFromTemplate(df, name);
    }

    static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }
}

