/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.patterns;

import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DTOHelper {
    private final Project project;
    private org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar;
    private Entity entity;
    private final TypeElement classElm;
    private EnterpriseBeans beans;
    private final FileObject fileObject;

    public DTOHelper(CompilationController controller, Element feature) {
        this.classElm = (TypeElement)feature.getEnclosingElement();
        this.fileObject = controller.getFileObject();
        this.project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.fileObject);
        DDProvider provider = DDProvider.getDefault();
        try {
            this.ejbJar = provider.getDDRoot(ejbModule.getDeploymentDescriptor());
            this.beans = this.ejbJar.getEnterpriseBeans();
            this.entity = (Entity)this.beans.findBeanByName("Entity", "EjbClass", this.classElm.getQualifiedName().toString());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public CmrField[] getCmrFields() {
        ArrayList<CmrField> cmrFields = new ArrayList<CmrField>();
        EjbRelation[] ejbRelations = this.getRelation();
        if (ejbRelations != null) {
            for (EjbRelation ejbRelation : ejbRelations) {
                EjbRelationshipRole role = ejbRelation.getEjbRelationshipRole();
                if (this.isUseEjb(role)) {
                    cmrFields.add(role.getCmrField());
                }
                if (!this.isUseEjb(role = ejbRelation.getEjbRelationshipRole2())) continue;
                cmrFields.add(role.getCmrField());
            }
        }
        return cmrFields.toArray(new CmrField[0]);
    }

    private EjbRelation[] getRelation() {
        Relationships relation = this.ejbJar.getSingleRelationships();
        return relation != null ? relation.getEjbRelation() : null;
    }

    public boolean isMultiple(CmrField cmrField) {
        boolean isMultiple = false;
        EjbRelation[] ejbRelations = this.getRelation();
        if (ejbRelations != null) {
            for (EjbRelation ejbRelation : ejbRelations) {
                EjbRelationshipRole role = ejbRelation.getEjbRelationshipRole();
                if (cmrField == role.getCmrField()) {
                    if ("Many".equals(ejbRelation.getEjbRelationshipRole2().getMultiplicity())) {
                        isMultiple = true;
                    }
                }
                if (cmrField != (role = ejbRelation.getEjbRelationshipRole2()).getCmrField()) continue;
                if (!"Many".equals(ejbRelation.getEjbRelationshipRole().getMultiplicity())) continue;
                isMultiple = true;
            }
        }
        return isMultiple;
    }

    public String getOppositeFieldType(CmrField cmrField) {
        String cmrFieldType2 = "";
        EjbRelation[] ejbRelations = this.getRelation();
        if (ejbRelations != null) {
            for (EjbRelation ejbRelation : ejbRelations) {
                EjbRelationshipRole role = ejbRelation.getEjbRelationshipRole();
                if (cmrField == role.getCmrField()) {
                    String ejbName = ejbRelation.getEjbRelationshipRole2().getRelationshipRoleSource().getEjbName();
                    cmrFieldType2 = this.findLocalIntNameByEntityName(ejbName);
                    break;
                }
                role = ejbRelation.getEjbRelationshipRole2();
                if (cmrField != role.getCmrField()) continue;
                String ejbName = ejbRelation.getEjbRelationshipRole().getRelationshipRoleSource().getEjbName();
                cmrFieldType2 = this.findLocalIntNameByEntityName(ejbName);
                break;
            }
        }
        return cmrFieldType2;
    }

    public String findLocalIntNameByEntityName(String entityName) {
        Entity[] ents = this.beans.getEntity();
        String localInterfaceName = "";
        for (int i = 0; i < ents.length; ++i) {
            if (!entityName.equals(ents[i].getEjbName())) continue;
            localInterfaceName = ents[i].getLocal();
            break;
        }
        return localInterfaceName;
    }

    public String findEntityNameByLocalInt(String interf) {
        Entity[] ents = this.beans.getEntity();
        String ejbName = "";
        for (int i = 0; i < ents.length; ++i) {
            if (!interf.equals(ents[i].getLocal())) continue;
            ejbName = ents[i].getEjbName();
            break;
        }
        return ejbName;
    }

    private boolean isUseEjb(EjbRelationshipRole role) {
        return role != null && role.getRelationshipRoleSource() != null && role.getRelationshipRoleSource().getEjbName().equals(this.getEntityName());
    }

    public CmpField[] getCmpFields() {
        return this.entity.getCmpField();
    }

    public String getFieldType(String fieldName) {
        String returnType = "";
        return returnType;
    }

    public String getEntityName() {
        return this.entity.getEjbName();
    }

    public String getLocalName() {
        return this.entity.getLocal();
    }

    public String getFullName() {
        return this.classElm.getQualifiedName().toString();
    }

    public String getPackage() {
        return this.getFullName().substring(0, this.getFullName().lastIndexOf(46));
    }

    public Project getProject() {
        return this.project;
    }

    public SourceGroup getSourceGroup() {
        SourceGroup entityFolder = null;
        SourceGroup[] folders = SourceGroups.getJavaSourceGroups((Project)this.project);
        for (int i = 0; i < folders.length; ++i) {
            if (!folders[i].contains(this.fileObject)) continue;
            entityFolder = folders[i];
        }
        return entityFolder;
    }
}

