/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.ant;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.LineContainsRegExp;
import org.apache.tools.ant.taskdefs.Concat;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.types.resources.ZipResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.zip.ZipEntry;
import org.netbeans.modules.ide.ergonomics.ant.IconResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ExtractLayer
extends Task
implements FileNameMapper,
URIResolver,
EntityResolver {
    private List<FileSet> moduleSet = new ArrayList<FileSet>();
    private List<FileSet> entries = new ArrayList<FileSet>();
    private File output;
    private File bundle;
    private String clusterName;
    private FilterChain bundleFilter;
    private File badgeFile;

    public void addConfiguredModules(FileSet fs) {
        this.moduleSet.add(fs);
    }

    public void addConfiguredEntries(FileSet fs) {
        this.entries.add(fs);
    }

    public void setDestDir(File f) {
        this.output = f;
    }

    public void setBundle(File f) {
        this.bundle = f;
    }

    public void setClusterName(String n) {
        this.clusterName = n;
    }

    public void addConfiguredBundleFilter(FilterChain b) {
        this.bundleFilter = b;
    }

    public void setBadgeIcon(File f) {
        this.badgeFile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Pattern copyPattern;
        Pattern concatPattern;
        Transformer et;
        Transformer rt;
        Transformer ft;
        BufferedImage badgeIcon;
        if (this.moduleSet.isEmpty()) {
            throw new BuildException();
        }
        if (this.output == null) {
            throw new BuildException();
        }
        if (this.clusterName == null) {
            throw new BuildException();
        }
        try {
            badgeIcon = this.badgeFile == null ? ImageIO.read(ExtractLayer.class.getResourceAsStream("badge.png")) : ImageIO.read(this.badgeFile);
        }
        catch (IOException ex) {
            throw new BuildException("Error reading " + this.badgeFile, (Throwable)ex);
        }
        try {
            URL fu = ExtractLayer.class.getResource("full-paths.xsl");
            URL ru = ExtractLayer.class.getResource("relative-refs.xsl");
            URL eu = ExtractLayer.class.getResource("entry-points.xsl");
            StreamSource fullpaths = new StreamSource(fu.openStream());
            StreamSource relative = new StreamSource(ru.openStream());
            StreamSource entryPoints = new StreamSource(eu.openStream());
            SAXTransformerFactory fack = (SAXTransformerFactory)TransformerFactory.newInstance();
            assert (Boolean.TRUE.equals(fack.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")));
            fack.setURIResolver(this);
            ft = fack.newTransformer(fullpaths);
            rt = fack.newTransformer(relative);
            rt.setParameter("cluster.name", this.clusterName);
            et = fack.newTransformer(entryPoints);
            et.setParameter("cluster.name", this.clusterName);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        StringBuilder modules = new StringBuilder();
        String sep = "\n    ";
        ByteArrayOutputStream uberLayer = new ByteArrayOutputStream();
        try {
            uberLayer.write("<?xml version='1.0' encoding='UTF-8'?>\n".getBytes("UTF-8"));
            uberLayer.write("<filesystem>\n".getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        StreamResult uberOut = new StreamResult(uberLayer);
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        f.setNamespaceAware(false);
        for (FileSet fs : this.moduleSet) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String path : ds.getIncludedFiles()) {
                File file = new File(basedir, path);
                try {
                    JarFile jf = new JarFile(file);
                    try {
                        java.util.zip.ZipEntry generatedLayer;
                        String mflayer;
                        String skip;
                        String modname;
                        Manifest mf = jf.getManifest();
                        if (mf == null || (modname = mf.getMainAttributes().getValue("OpenIDE-Module")) == null || "false".equals(skip = mf.getMainAttributes().getValue("FeaturesOnDemand-Proxy-Layer"))) continue;
                        String show = mf.getMainAttributes().getValue("AutoUpdate-Show-In-Client");
                        String base = modname.replaceFirst("/[0-9]+$", "");
                        if (!"false".equals(show)) {
                            modules.append(sep).append(base);
                            sep = ",\\\n    ";
                        }
                        if ((mflayer = mf.getMainAttributes().getValue("OpenIDE-Module-Layer")) != null) {
                            String n = mflayer.replaceFirst("/[^/]+$", "").replace('/', '.') + ".xml";
                            et.setParameter("filename", n);
                            et.transform(this.createSource(jf, jf.getEntry(mflayer)), uberOut);
                        }
                        if ((generatedLayer = jf.getEntry("META-INF/generated-layer.xml")) == null) continue;
                        et.setParameter("filename", base + "-generated.xml");
                        et.transform(this.createSource(jf, generatedLayer), uberOut);
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (Exception x) {
                    throw new BuildException("Reading " + file + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
        RegularExpression linePattern = new RegularExpression();
        String uberText = null;
        byte[] uberArr = null;
        try {
            uberLayer.write("</filesystem>\n".getBytes("UTF-8"));
            uberText = uberLayer.toString("UTF-8");
            uberArr = uberLayer.toByteArray();
            this.log("uberLayer for " + this.clusterName + "\n" + uberText, 3);
            TreeSet<String> concatregs = new TreeSet<String>();
            TreeSet<String> copyregs = new TreeSet<String>();
            TreeSet<String> keys = new TreeSet<String>();
            this.parse(new ByteArrayInputStream(uberArr), concatregs, copyregs, keys);
            this.log("Concats: " + concatregs, 3);
            this.log("Copies : " + copyregs, 3);
            StringBuilder stringBuilder = new StringBuilder();
            sep = "";
            for (String s : concatregs) {
                stringBuilder.append(sep);
                stringBuilder.append(s);
                sep = "|";
            }
            concatPattern = Pattern.compile(stringBuilder.toString());
            StringBuilder stringBuilder2 = new StringBuilder();
            sep = "";
            for (String s : copyregs) {
                stringBuilder2.append(sep);
                stringBuilder2.append(s);
                sep = "|";
            }
            copyPattern = Pattern.compile(stringBuilder2.toString());
            StringBuilder stringBuilder3 = new StringBuilder();
            sep = "";
            for (String s : keys) {
                stringBuilder3.append(sep);
                stringBuilder3.append(s);
                sep = "|";
            }
            linePattern.setPattern("(" + stringBuilder3 + ") *=");
        }
        catch (Exception ex) {
            throw new BuildException("Cannot parse layers: " + ex.getMessage(), (Throwable)ex);
        }
        HashMap<String, ResArray> bundles = new HashMap<String, ResArray>();
        bundles.put("", new ResArray());
        ResArray icons = new ResArray();
        for (FileSet fileSet : this.entries == null ? this.moduleSet : this.entries) {
            DirectoryScanner ds = fileSet.getDirectoryScanner(this.getProject());
            File basedir = ds.getBasedir();
            for (String path : ds.getIncludedFiles()) {
                File jar = new File(basedir, path);
                try {
                    JarFile jf = new JarFile(jar);
                    try {
                        Enumeration<JarEntry> en = jf.entries();
                        while (en.hasMoreElements()) {
                            ZipEntry zipEntry;
                            JarEntry je = en.nextElement();
                            if (concatPattern.matcher(je.getName()).matches()) {
                                zipEntry = new ZipEntry((java.util.zip.ZipEntry)je);
                                String noExt = je.getName().replaceFirst("\\.[^\\.]*$", "");
                                int index = noExt.indexOf("_");
                                String suffix = index == -1 ? "" : noExt.substring(index + 1);
                                ResArray ra = (ResArray)bundles.get(suffix);
                                if (ra == null) {
                                    ra = new ResArray();
                                    bundles.put(suffix, ra);
                                }
                                ra.add(new ZipResource(jar, "UTF-8", zipEntry));
                                ra.add(new StringResource("\n\n"));
                            }
                            if (!copyPattern.matcher(je.getName()).matches()) continue;
                            zipEntry = new ZipEntry((java.util.zip.ZipEntry)je);
                            ZipResource zr = new ZipResource(jar, "UTF-8", zipEntry);
                            if (badgeIcon != null) {
                                icons.add(new IconResource((Resource)zr, badgeIcon));
                                continue;
                            }
                            icons.add(zr);
                        }
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (Exception x) {
                    throw new BuildException("Reading " + jar + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
        for (Map.Entry entry : bundles.entrySet()) {
            ResArray ra = (ResArray)entry.getValue();
            Concat concat = new Concat();
            concat.setProject(this.getProject());
            ra.add(new StringResource(""));
            concat.add((ResourceCollection)ra);
            concat.setDestfile(ExtractLayer.localeVariant(this.bundle, (String)entry.getKey()));
            FilterChain ch = new FilterChain();
            LineContainsRegExp filter = new LineContainsRegExp();
            filter.addConfiguredRegexp(linePattern);
            ch.addLineContainsRegExp(filter);
            concat.addFilterChain(ch);
            concat.addFilterChain(this.bundleFilter);
            Concat.TextElement te = new Concat.TextElement();
            te.setProject(this.getProject());
            te.addText("\n\n\ncnbs=\\" + modules + "\n\n");
            te.setFiltering(false);
            concat.addFooter(te);
            concat.execute();
        }
        HashMap<String, Resource> names = new HashMap<String, Resource>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Resource r : icons) {
            String name = r.getName();
            Resource prev = names.put(name, r);
            if (prev == null || prev.getName().equals(r.getName())) continue;
            hashSet.add(r.getName());
            hashSet.add(prev.getName());
        }
        if (!hashSet.isEmpty()) {
            throw new BuildException("Duplicated resources are forbidden: " + hashSet.toString().replace(',', '\n'));
        }
        Copy copy = new Copy();
        copy.setProject(this.getProject());
        copy.add((ResourceCollection)icons);
        copy.setTodir(this.output);
        copy.add((FileNameMapper)this);
        copy.execute();
        try {
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(uberArr));
            DOMResult tmpRes = new DOMResult();
            ft.transform(streamSource, tmpRes);
            Node filesystem = tmpRes.getNode().getFirstChild();
            String n = filesystem.getNodeName();
            assert (n.equals("filesystem")) : n;
            if (filesystem.getChildNodes().getLength() > 0) {
                DOMSource tmpSrc = new DOMSource(tmpRes.getNode());
                StreamResult gen = new StreamResult(new File(this.output, "layer.xml"));
                rt.transform(tmpSrc, gen);
            }
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void parse(InputStream is, final Set<String> concat, final Set<String> copy, final Set<String> additionalKeys) throws Exception {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        f.setNamespaceAware(false);
        f.newSAXParser().parse(is, new DefaultHandler(){
            String prefix = "";

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("folder")) {
                    String n = attributes.getValue("name");
                    this.prefix = this.prefix + n + "/";
                } else if (qName.equals("file")) {
                    String n = attributes.getValue("name");
                    this.addResource(attributes.getValue("url"), true);
                    this.prefix = this.prefix + n;
                } else if (qName.equals("attr")) {
                    String name = attributes.getValue("name");
                    if (name.equals("SystemFileSystem.localizingBundle")) {
                        String bundlepath = attributes.getValue("stringvalue").replace('.', '/') + ".*properties";
                        concat.add(bundlepath);
                        if (this.prefix.endsWith("/")) {
                            additionalKeys.add(this.prefix.substring(0, this.prefix.length() - 1));
                        } else {
                            additionalKeys.add(this.prefix);
                        }
                    } else if (name.equals("iconResource") || name.equals("iconBase")) {
                        String s = attributes.getValue("stringvalue");
                        if (s == null) {
                            throw new BuildException("No stringvalue attribute for " + name);
                        }
                        this.addResource("nbresloc:" + s, false);
                    } else if (attributes.getValue("bundlevalue") != null) {
                        String bundlevalue = attributes.getValue("bundlevalue");
                        int idx = bundlevalue.indexOf(35);
                        String bundle = bundlevalue.substring(0, idx);
                        String key = bundlevalue.substring(idx + 1);
                        String bundlepath = bundle.replace('.', '/') + ".*properties";
                        concat.add(bundlepath);
                        additionalKeys.add(key);
                    } else {
                        this.addResource(attributes.getValue("urlvalue"), false);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equals("folder")) {
                    this.prefix = this.prefix.replaceFirst("[^/]+/$", "");
                } else if (qName.equals("file")) {
                    this.prefix = this.prefix.replaceFirst("[^/]+$", "");
                }
            }

            @Override
            public InputSource resolveEntity(String pub, String sys) throws IOException, SAXException {
                return new InputSource(new StringReader(""));
            }

            private void addResource(String url, boolean localAllowed) throws BuildException {
                if (url == null) {
                    return;
                }
                if (url.startsWith("nbres:")) {
                    url = "nbresloc:" + url.substring(6);
                }
                String prfx = "nbresloc:";
                if (!url.startsWith("nbresloc:")) {
                    if (localAllowed) {
                        if (url.startsWith("/")) {
                            copy.add(url.substring(1));
                        } else {
                            copy.add(".*/" + url);
                        }
                        return;
                    }
                    throw new BuildException("Unknown urlvalue was: " + url);
                }
                if ((url = url.substring("nbresloc:".length())).startsWith("/")) {
                    url = url.substring(1);
                }
                url = url.replaceFirst("(\\.[^\\.])+$*", ".*$1");
                copy.add(url);
            }
        });
    }

    private static File localeVariant(File base, String locale) {
        if (locale.length() == 0) {
            return base;
        }
        String name = base.getName().replaceFirst("\\.", "_" + locale + ".");
        return new File(base.getParentFile(), name);
    }

    public void setFrom(String arg0) {
    }

    public void setTo(String arg0) {
    }

    public String[] mapFileName(String fileName) {
        return new String[]{fileName.replace('/', '-')};
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    private Source createSource(JarFile jf, java.util.zip.ZipEntry entry) {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setValidating(false);
            DocumentBuilder b = f.newDocumentBuilder();
            b.setEntityResolver(this);
            Document doc = b.parse(jf.getInputStream(entry));
            return new DOMSource(doc);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private static final class ResArray
    extends ArrayList<Resource>
    implements ResourceCollection {
        private ResArray() {
        }

        public boolean isFilesystemOnly() {
            return false;
        }
    }
}

