/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.actions;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.midp.actions.GoToSourcePresenter;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;

public final class GoToSourceSupport {
    private GoToSourceSupport() {
    }

    public static void goToSourceOfComponent(final DesignComponent component) {
        if (component == null) {
            return;
        }
        final DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)component.getDocument());
        if (context == null) {
            return;
        }
        final CloneableEditorSupport[] editorSupport = new CloneableEditorSupport[1];
        final GoToSourcePresenter[] presenter = new GoToSourcePresenter[1];
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                presenter[0] = (GoToSourcePresenter)component.getPresenter(GoToSourcePresenter.class);
                if (presenter[0] != null) {
                    editorSupport[0] = context.getCloneableEditorSupport();
                }
            }
        });
        if (editorSupport[0] == null) {
            return;
        }
        IOSupport.forceUpdateCode((DataObject)context.getDataObject());
        editorSupport[0].edit();
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                StyledDocument document = null;
                try {
                    document = editorSupport[0].openDocument();
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                if (document != null) {
                    ProjectUtils.requestVisibility((DataObjectContext)ActiveViewSupport.getDefault().getActiveView().getContext(), (String)ProjectUtils.getSourceEditorViewDisplayName());
                    JEditorPane[] panes = editorSupport[0].getOpenedPanes();
                    if (panes != null && panes.length >= 1) {
                        final JEditorPane pane = panes[0];
                        pane.setVisible(true);
                        Iterable iterable = GuardedSectionManager.getInstance((StyledDocument)document).getGuardedSections();
                        for (final GuardedSection section : iterable) {
                            if (!presenter[0].matches(section)) continue;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    pane.setCaretPosition(section.getCaretPosition().getOffset());
                                }
                            });
                            break;
                        }
                    }
                }
            }
        });
    }
}

