/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.openide.util.Utilities;

public class SpacerDisplayPresenter
extends ScreenDisplayPresenter {
    private JSeparator separator;
    private JPanel panel = new JPanel();
    private JPanel innerPanel = new JPanel();

    public SpacerDisplayPresenter() {
        this.separator = new JSeparator(0){

            @Override
            public JPopupMenu getComponentPopupMenu() {
                return Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)SpacerDisplayPresenter.this.getRelatedComponent()), (Component)this);
            }
        };
        this.panel.setOpaque(false);
        this.innerPanel.setOpaque(false);
        this.panel.setLayout(new BoxLayout(this.panel, 2){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                SpacerDisplayPresenter.this.innerPanel.setLocation(0, (int)((double)parent.getHeight() - SpacerDisplayPresenter.this.separator.getPreferredSize().getHeight()) / 2);
            }
        });
        this.innerPanel.setLayout(new BoxLayout(this.innerPanel, 2));
        this.panel.add(this.innerPanel);
        this.innerPanel.add(this.separator);
        ScreenSupport.addKeyboardSupport(this);
    }

    public boolean isTopLevelDisplay() {
        return false;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        return this.panel;
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        int minHeight = Integer.parseInt(this.getComponent().readProperty("minHeight").getPrimitiveValue().toString());
        int minWidth = Integer.parseInt(this.getComponent().readProperty("minWidth").getPrimitiveValue().toString());
        int panelWidth = (int)this.panel.getMinimumSize().getWidth();
        this.panel.setMinimumSize(new Dimension(panelWidth, minHeight));
        int sepHeight = (int)this.separator.getMinimumSize().getHeight();
        this.innerPanel.setMinimumSize(new Dimension(minWidth, sepHeight));
        int prefHeight = -1;
        int prefWidth = -1;
        PropertyValue val = this.getComponent().readProperty("preferredHeight");
        if (val != null && val.getPrimitiveValue() != null) {
            prefHeight = Integer.valueOf(val.getPrimitiveValue().toString());
        }
        if ((val = this.getComponent().readProperty("preferredWidth")) != null && val.getPrimitiveValue() != null) {
            prefWidth = Integer.valueOf(val.getPrimitiveValue().toString());
        }
        if (prefHeight == -1) {
            this.panel.setPreferredSize(null);
        } else {
            this.panel.setPreferredSize(new Dimension((int)this.panel.getPreferredSize().getWidth(), prefHeight));
        }
        if (prefWidth == -1) {
            this.innerPanel.setPreferredSize(null);
            this.innerPanel.setMaximumSize(null);
        } else {
            this.innerPanel.setPreferredSize(new Dimension(prefWidth, (int)this.separator.getPreferredSize().getHeight()));
            this.innerPanel.setMaximumSize(new Dimension(prefWidth, (int)this.separator.getMaximumSize().getHeight()));
        }
        this.innerPanel.invalidate();
        this.innerPanel.revalidate();
        this.panel.revalidate();
    }

    public Shape getSelectionShape() {
        return new Rectangle(this.panel.getSize());
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptySet();
    }
}

