/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.IllegalArtifactCoordinateException;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactContext {
    private final File pom;
    private final File artifact;
    private final File metadata;
    private final ArtifactInfo artifactInfo;
    private final Gav gav;
    private final List<Exception> errors = new ArrayList<Exception>();

    public ArtifactContext(File pom, File artifact, File metadata, ArtifactInfo artifactInfo, Gav gav) throws IllegalArtifactCoordinateException {
        if (artifactInfo == null) {
            throw new IllegalArtifactCoordinateException("Parameter artifactInfo must not be null.");
        }
        this.pom = pom;
        this.artifact = artifact;
        this.metadata = metadata;
        this.artifactInfo = artifactInfo;
        this.gav = gav == null ? artifactInfo.calculateGav() : gav;
    }

    public File getPom() {
        return this.pom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getPomModel() {
        block21: {
            if (this.getPom() != null && this.getPom().exists()) {
                try {
                    return new ModelReader().readModel(new FileInputStream(this.getPom()));
                }
                catch (FileNotFoundException e) {
                    break block21;
                }
            }
            if (this.getArtifact() != null) {
                ZipFile jar = null;
                try {
                    jar = new ZipFile(this.getArtifact());
                    Enumeration<? extends ZipEntry> en = jar.entries();
                    while (true) {
                        if (en.hasMoreElements()) {
                            ZipEntry e = en.nextElement();
                            String name = e.getName();
                            if (!name.equals("META-INF/maven/" + this.gav.getGroupId() + "/" + this.gav.getArtifactId() + "/pom.xml")) continue;
                            Model model = new ModelReader().readModel(jar.getInputStream(e));
                            return model;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        return null;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public File getMetadata() {
        return this.metadata;
    }

    public ArtifactInfo getArtifactInfo() {
        return this.artifactInfo;
    }

    public Gav getGav() {
        return this.gav;
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public Document createDocument(IndexingContext context) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(ArtifactInfo.UINFO, this.getArtifactInfo().getUinfo(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            try {
                indexCreator.populateArtifactInfo(this);
            }
            catch (IOException ex) {
                this.addError(ex);
            }
        }
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            indexCreator.updateDocument(this.getArtifactInfo(), doc);
        }
        return doc;
    }

    public static class ModelReader {
        public Model readModel(InputStream pom) {
            if (pom == null) {
                return null;
            }
            Model model = new Model();
            Xpp3Dom dom = this.readPomInputStream(pom);
            if (dom == null) {
                return null;
            }
            if (dom.getChild("packaging") != null) {
                model.setPackaging(dom.getChild("packaging").getValue());
            } else {
                model.setPackaging(null);
            }
            if (dom.getChild("name") != null) {
                model.setName(dom.getChild("name").getValue());
            }
            if (dom.getChild("description") != null) {
                model.setDescription(dom.getChild("description").getValue());
            }
            return model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Xpp3Dom readPomInputStream(InputStream is) {
            InputStreamReader r = new InputStreamReader(is);
            try {
                Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)r);
                return xpp3Dom;
            }
            catch (XmlPullParserException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    ((Reader)r).close();
                }
                catch (IOException e) {}
            }
            return null;
        }
    }
}

