/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private static final Logger LOG = Logger.getLogger(SearchExecutor.class.getName());
    private final SearchHistoryPanel master;
    private Map<SVNUrl, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private int completedSearches;
    private boolean searchCanceled;
    private List<RepositoryRevision> results = new ArrayList<RepositoryRevision>();

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        this.criteria = master.getCriteria();
    }

    private void populatePathToRoot() {
        this.pathToRoot = new HashMap<String, File>();
        try {
            if (this.searchingUrl()) {
                String rootPath = SvnUtils.getRepositoryPath(this.master.getRoots()[0]);
                this.pathToRoot.put(rootPath, this.master.getRoots()[0]);
            } else {
                this.workFiles = new HashMap<SVNUrl, Set<File>>();
                for (File file : this.master.getRoots()) {
                    SVNUrl rootUrl = SvnUtils.getRepositoryRootUrl(file);
                    this.populatePathToRoot(file, rootUrl);
                    Set<File> set = this.workFiles.get(rootUrl);
                    if (set == null) {
                        set = new HashSet<File>(2);
                        this.workFiles.put(rootUrl, set);
                    }
                    set.add(file);
                }
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
    }

    private void populatePathToRoot(File file, SVNUrl rootUrl) throws SVNClientException {
        Map<File, SVNUrl> m = SvnUtils.getRepositoryUrls(file);
        for (Map.Entry<File, SVNUrl> e : m.entrySet()) {
            SVNUrl url = e.getValue();
            if (url == null) continue;
            String rootPath = SVNUrlUtils.getRelativePath((SVNUrl)rootUrl, (SVNUrl)url, (boolean)true);
            if (rootPath == null) {
                LOG.log(Level.FINE, "populatePathToRoot: rootUrl: {0}, url: {1}, probably svn:externals", new String[]{rootUrl.toString(), url.toString()});
                continue;
            }
            String fileAbsPath = e.getKey().getAbsolutePath().replace(File.separatorChar, '/');
            int commonPathLength = this.getCommonPostfixLength(rootPath, fileAbsPath);
            this.pathToRoot.put(rootPath.substring(0, rootPath.length() - commonPathLength), new File(fileAbsPath.substring(0, fileAbsPath.length() - commonPathLength)));
        }
    }

    private int getCommonPostfixLength(String a, String b) {
        int ai = a.length() - 1;
        int slash = -1;
        for (int bi = b.length() - 1; ai >= 0 && bi >= 0; --ai, --bi) {
            char ca = a.charAt(ai);
            char cb = b.charAt(bi);
            if (ca == '/') {
                slash = ai;
            }
            if (ca == cb) continue;
            if (slash <= -1) break;
            return a.length() - slash;
        }
        return a.length() - ai - 1;
    }

    @Override
    public void run() {
        this.populatePathToRoot();
        final SVNRevision fromRevision = this.criteria.getFrom();
        final SVNRevision toRevision = this.criteria.getTo();
        if (fromRevision == null || toRevision == null) {
            LOG.log(Level.WARNING, "wrong revision: [{0}:{1}] - [{2}:{3}]", new Object[]{fromRevision, this.criteria.tfFrom.getText(), toRevision, this.criteria.tfTo.getText()});
            return;
        }
        this.completedSearches = 0;
        if (this.searchingUrl()) {
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(this.master.getRepositoryUrl());
            SvnProgressSupport support = new SvnProgressSupport(){

                @Override
                public void perform() {
                    SearchExecutor.this.search(SearchExecutor.this.master.getRepositoryUrl(), null, fromRevision, toRevision, this, ((SearchExecutor)SearchExecutor.this).master.fileInfoCheckBox.isSelected());
                }
            };
            support.start(rp, this.master.getRepositoryUrl(), NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
        } else {
            for (final SVNUrl rootUrl : this.workFiles.keySet()) {
                final Set<File> files = this.workFiles.get(rootUrl);
                RequestProcessor rp = Subversion.getInstance().getRequestProcessor(rootUrl);
                SvnProgressSupport support = new SvnProgressSupport(){

                    @Override
                    public void perform() {
                        SearchExecutor.this.search(rootUrl, files, fromRevision, toRevision, this, ((SearchExecutor)SearchExecutor.this).master.fileInfoCheckBox.isSelected());
                    }
                };
                support.start(rp, rootUrl, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
            }
        }
    }

    private void search(SVNUrl rootUrl, Set<File> files, SVNRevision fromRevision, SVNRevision toRevision, SvnProgressSupport progressSupport, boolean fetchDetailsPaths) {
        block15: {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(rootUrl, progressSupport);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            if (progressSupport.isCanceled()) {
                this.searchCanceled = true;
                return;
            }
            if (this.searchingUrl()) {
                try {
                    ISVNLogMessage[] messages = client.getLogMessages(rootUrl, null, fromRevision, toRevision, false, fetchDetailsPaths, 0L);
                    this.appendResults(rootUrl, messages);
                }
                catch (SVNClientException e) {
                    if (!SvnClientExceptionHandler.handleLogException(rootUrl, toRevision, e)) {
                        progressSupport.annotate(e);
                    }
                    break block15;
                }
            }
            String[] paths = new String[files.size()];
            int idx = 0;
            try {
                for (File file : files) {
                    String p = SvnUtils.getRelativePath(file);
                    if (p != null && p.startsWith("/")) {
                        p = p.substring(1, p.length());
                    }
                    paths[idx++] = p;
                }
                ISVNLogMessage[] messages = SvnUtils.getLogMessages(client, rootUrl, paths, fromRevision, toRevision, false, fetchDetailsPaths);
                this.appendResults(rootUrl, messages);
            }
            catch (SVNClientException e) {
                block16: {
                    try {
                        if (SvnClientExceptionHandler.isHTTP403(e.getMessage())) {
                            for (String path : paths) {
                                ISVNLogMessage[] messages = client.getLogMessages(rootUrl.appendPath(path), null, fromRevision, toRevision, false, fetchDetailsPaths, 0L);
                                this.appendResults(rootUrl, messages);
                            }
                            return;
                        }
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.handleLogException(rootUrl, toRevision, e)) break block16;
                        progressSupport.annotate(ex);
                    }
                }
                if (SvnClientExceptionHandler.handleLogException(rootUrl, toRevision, e)) break block15;
                progressSupport.annotate(e);
            }
        }
    }

    private synchronized void appendResults(SVNUrl rootUrl, ISVNLogMessage[] logMessages) {
        HashMap<String, String> historyPaths = new HashMap<String, String>();
        for (int i = logMessages.length - 1; i >= 0; --i) {
            ISVNLogMessage logMessage = logMessages[i];
            if (logMessage == null) continue;
            String username = this.criteria.getUsername();
            String msg = this.criteria.getCommitMessage();
            String logMsg = logMessage.getMessage();
            if (username != null && !username.equals(logMessage.getAuthor()) || msg != null && logMsg != null && logMsg.indexOf(msg) == -1) continue;
            RepositoryRevision rev = new RepositoryRevision(logMessage, rootUrl);
            for (RepositoryRevision.Event event : rev.getEvents()) {
                if (event.getChangedPath().getAction() == 'A' && event.getChangedPath().getCopySrcPath() != null) {
                    String existingMapping = (String)historyPaths.get(event.getChangedPath().getPath());
                    if (existingMapping == null) {
                        existingMapping = event.getChangedPath().getPath();
                    }
                    historyPaths.put(event.getChangedPath().getCopySrcPath(), existingMapping);
                }
                String originalFilePath = event.getChangedPath().getPath();
                for (String srcPath : historyPaths.keySet()) {
                    if (!originalFilePath.startsWith(srcPath) || originalFilePath.length() != srcPath.length() && originalFilePath.charAt(srcPath.length()) != '/') continue;
                    originalFilePath = (String)historyPaths.get(srcPath) + originalFilePath.substring(srcPath.length());
                    break;
                }
                File file = this.computeFile(originalFilePath);
                event.setFile(file);
            }
            this.results.add(rev);
        }
        this.checkFinished();
    }

    private boolean searchingUrl() {
        return this.master.getRepositoryUrl() != null;
    }

    private File computeFile(String path) {
        for (String s : this.pathToRoot.keySet()) {
            if (!path.startsWith(s)) continue;
            return new File(this.pathToRoot.get(s), path.substring(s.length()));
        }
        return null;
    }

    private void checkFinished() {
        ++this.completedSearches;
        if (this.searchingUrl() && this.completedSearches >= 1 || this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchExecutor.this.master.setResults(SearchExecutor.this.results);
                }
            });
        }
    }
}

