/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.EventsModel;
import org.netbeans.modules.web.beans.navigation.actions.AbstractEventAction;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InspectEventsAtCaretAction
extends AbstractEventAction {
    private static final long serialVersionUID = -4645226875434261917L;
    private static final String INSPECT_EVENTS_AT_CARET = "inspect-events-at-caret";
    private static final String INSPECT_EVENTS_AT_CARET_POPUP = "inspect-events-at-caret-popup";

    public InspectEventsAtCaretAction() {
        super(NbBundle.getMessage(InspectEventsAtCaretAction.class, (String)INSPECT_EVENTS_AT_CARET));
    }

    @Override
    protected String getActionCommand() {
        return INSPECT_EVENTS_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return INSPECT_EVENTS_AT_CARET_POPUP;
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, final Object[] subject, JTextComponent component, FileObject fileObject) {
        Object handle = subject[0];
        if (handle == null) {
            return;
        }
        Element element = ((ElementHandle)handle).resolve((CompilationInfo)model.getCompilationController());
        ExecutableElement method = (ExecutableElement)element;
        if (model.getObserverParameter(method) == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotObserverContext"), 700);
            return;
        }
        List<VariableElement> eventInjectionPoints = model.getEventInjectionPoints(method, null);
        CompilationController controller = model.getCompilationController();
        final EventsModel uiModel = new EventsModel(eventInjectionPoints, controller, metaModel);
        final String name = method.getSimpleName().toString();
        if (SwingUtilities.isEventDispatchThread()) {
            WebBeansActionHelper.showEventsDialog(metaModel, model, subject, uiModel, name);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBeansActionHelper.showEventsDialog((MetadataModel<WebBeansModel>)metaModel, null, subject, uiModel, name);
                }
            });
        }
    }
}

