/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddDomainLocationVisualPanel
extends JPanel {
    private final transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private ButtonGroup buttonGroup1;
    private JComboBox domainField;
    private JLabel domainFieldLabel;
    private JLabel explanationLabel;
    private JTextField hostNameField;
    private JLabel hostNameLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField portValueField;
    private JLabel portValueLabel;
    private JRadioButton registerLocalRB;
    private JRadioButton registerRemoteRB;
    private JCheckBox useDefaultPortsCB;

    public AddDomainLocationVisualPanel() {
        this.initComponents();
        this.registerLocalRB.setSelected(true);
        this.registerRemoteRB.setSelected(false);
        this.hostNameField.setEnabled(false);
        this.portValueField.setEnabled(false);
        this.setName(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TITLE_DomainLocation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initModels(String gfRoot) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        File domainsDir = new File(gfRoot, "domains");
        File[] candidates = domainsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File dir) {
                File logsDir = new File(dir, "logs");
                return Utils.canWrite(logsDir);
            }
        });
        if (null != candidates) {
            for (File f : candidates) {
                model.addElement(f.getName());
            }
        }
        this.domainField.setModel(model);
        MyKeyListener kl = new MyKeyListener();
        this.domainField.getEditor().getEditorComponent().addKeyListener(kl);
        this.domainField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AddDomainLocationVisualPanel.this.domainField.getEditor().setItem(AddDomainLocationVisualPanel.this.domainField.getSelectedItem());
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        this.useDefaultPortsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        boolean defaultPortsAreOpen = true;
        ServerSocket adminPort = null;
        ServerSocket httpPort = null;
        try {
            adminPort = new ServerSocket(4848);
            httpPort = new ServerSocket(8080);
        }
        catch (IOException ex) {
            defaultPortsAreOpen = false;
            this.useDefaultPortsCB.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.text2"));
            if (null == adminPort) {
                this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TIP_ADMIN_IN_USE"));
            } else {
                this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TIP_HTTP_IN_USE"));
            }
        }
        finally {
            if (null != adminPort) {
                try {
                    adminPort.close();
                }
                catch (IOException ioe) {}
            }
            if (null != httpPort) {
                try {
                    httpPort.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.useDefaultPortsCB.setEnabled(defaultPortsAreOpen);
        this.useDefaultPortsCB.setSelected(defaultPortsAreOpen);
        this.registerLocalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainLocationVisualPanel.this.hostNameField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.portValueField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.domainField.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.useDefaultPortsCB.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        this.registerRemoteRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainLocationVisualPanel.this.hostNameField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.portValueField.setEnabled(!AddDomainLocationVisualPanel.this.registerLocalRB.isSelected());
                AddDomainLocationVisualPanel.this.domainField.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.useDefaultPortsCB.setEnabled(!AddDomainLocationVisualPanel.this.registerRemoteRB.isSelected());
                AddDomainLocationVisualPanel.this.fireChangeEvent();
            }
        });
        this.hostNameField.addKeyListener(kl);
        this.portValueField.addKeyListener(kl);
    }

    String getDomainField() {
        return (String)this.domainField.getEditor().getItem();
    }

    String getHostName() {
        return this.hostNameField.getText();
    }

    String getPortValue() {
        return this.portValueField.getText();
    }

    boolean getUseDefaultPorts() {
        return this.useDefaultPortsCB.isEnabled() && this.useDefaultPortsCB.isSelected();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    boolean registerLocalDomain() {
        return this.registerLocalRB.isSelected();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.registerLocalRB = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.domainFieldLabel = new JLabel();
        this.domainField = new JComboBox();
        this.explanationLabel = new JLabel();
        this.useDefaultPortsCB = new JCheckBox();
        this.registerRemoteRB = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.hostNameLabel = new JLabel();
        this.hostNameField = new JTextField();
        this.portValueLabel = new JLabel();
        this.portValueField = new JTextField();
        this.buttonGroup1.add(this.registerLocalRB);
        Mnemonics.setLocalizedText((AbstractButton)this.registerLocalRB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerLocalRB.text"));
        this.domainFieldLabel.setLabelFor(this.domainField);
        Mnemonics.setLocalizedText((JLabel)this.domainFieldLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainFieldLabel.text"));
        this.domainField.setEditable(true);
        this.domainField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.explanationLabel.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.explanationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useDefaultPortsCB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.text"));
        this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.explanationLabel, GroupLayout.Alignment.TRAILING, -1, 401, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.domainFieldLabel).addGap(4, 4, 4).addComponent(this.domainField, 0, 344, Short.MAX_VALUE)).addComponent(this.useDefaultPortsCB)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainFieldLabel).addComponent(this.domainField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.explanationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useDefaultPortsCB).addContainerGap(-1, Short.MAX_VALUE)));
        this.domainField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainField.AccessibleContext.accessibleDescription"));
        this.explanationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.explanationLabel.AccessibleContext.accessibleDescription"));
        this.useDefaultPortsCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.AccessibleContext.accessibleDescription"));
        this.buttonGroup1.add(this.registerRemoteRB);
        Mnemonics.setLocalizedText((AbstractButton)this.registerRemoteRB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerRemoteRB.text"));
        this.hostNameLabel.setLabelFor(this.hostNameField);
        Mnemonics.setLocalizedText((JLabel)this.hostNameLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostNameLabel.text"));
        this.hostNameField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostNameField.text"));
        this.portValueLabel.setLabelFor(this.portValueField);
        Mnemonics.setLocalizedText((JLabel)this.portValueLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.portValueLabel.text"));
        this.portValueField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.portValueField.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.hostNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hostNameField, -1, 317, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.portValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portValueField, -2, 70, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostNameField, -2, -1, -2).addComponent(this.hostNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portValueLabel).addComponent(this.portValueField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.hostNameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostNameField.AccessibleContext.accessibleDescription"));
        this.portValueField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.portValueField.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.registerLocalRB).addContainerGap(288, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.registerRemoteRB).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.registerLocalRB).addGap(2, 2, 2).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.registerRemoteRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
        this.registerLocalRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerLocalRB.AccessibleContext.accessibleDescription"));
        this.registerRemoteRB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.registerRemoteRB.AccessibleContext.accessibleDescription"));
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            AddDomainLocationVisualPanel.this.fireChangeEvent();
        }
    }
}

