/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.SymTabCache;
import org.openide.util.CharSequences;

public final class FileReferencesContext
extends CsmProgressAdapter {
    private final Lock lock = new Lock();
    private CsmFile csmFile;
    private int lastOffset;
    private boolean isClened = false;
    private Map<String, List<CsmUID<CsmVariable>>> fileLocalVars;
    private Map<String, Collection<CsmEnumerator>> libEnumerators;
    private Map<String, CsmEnumerator> hotSpotEnumerators;
    private OffsetsObjects offsets;
    private Map<CharSequence, CsmUID<CsmMacro>> projectMacros;
    private SymTabCache symTabCache = new SymTabCache();

    FileReferencesContext(CsmScope csmScope) {
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            this.csmFile = (CsmFile)csmScope;
        } else if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
            this.csmFile = ((CsmFunction)csmScope).getContainingFile();
        } else if (CsmKindUtilities.isOffsetable((Object)csmScope)) {
            this.csmFile = ((CsmOffsetable)csmScope).getContainingFile();
        }
        this.lastOffset = 0;
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    public void clean() {
        this.isClened = true;
        this._clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clean() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.fileLocalVars = null;
            this.offsets = null;
            this.projectMacros = null;
            this.libEnumerators = null;
            this.symTabCache.clear();
        }
    }

    public boolean isCleaned() {
        return this.isClened;
    }

    public void advance(int offset) {
        if (this.csmFile == null) {
            return;
        }
        this.lastOffset = offset;
    }

    public SymTabCache getSymTabCache() {
        return this.symTabCache;
    }

    public void putHotSpotEnum(Collection<CsmEnumerator> enumerators) {
        if (this.isCleaned()) {
            return;
        }
        if (this.hotSpotEnumerators == null) {
            this.hotSpotEnumerators = new HashMap<String, CsmEnumerator>();
        }
        HashSet<CsmEnum> enums = new HashSet<CsmEnum>();
        for (CsmEnumerator csmEnumerator : enumerators) {
            enums.add(csmEnumerator.getEnumeration());
        }
        for (CsmEnum csmEnum : enums) {
            for (CsmEnumerator i : csmEnum.getEnumerators()) {
                this.hotSpotEnumerators.put(((Object)i.getName()).toString(), i);
            }
        }
    }

    public CsmEnumerator getHotSpotEnum(String name) {
        if (this.isCleaned()) {
            return null;
        }
        if (this.hotSpotEnumerators == null) {
            this.hotSpotEnumerators = new HashMap<String, CsmEnumerator>();
        }
        return this.hotSpotEnumerators.get(name);
    }

    public Collection<CsmEnumerator> getLibEnumerators(String name) {
        if (this.isCleaned()) {
            return null;
        }
        if (this.libEnumerators == null) {
            this.libEnumerators = new HashMap<String, Collection<CsmEnumerator>>();
        }
        return this.libEnumerators.get(name);
    }

    public void putLibEnumerators(String name, Collection<CsmEnumerator> value) {
        if (this.isCleaned()) {
            return;
        }
        if (this.libEnumerators == null) {
            this.libEnumerators = new HashMap<String, Collection<CsmEnumerator>>();
        }
        this.libEnumerators.put(name, value);
    }

    public List<CsmVariable> getFileLocalIncludeVariables(String name) {
        if (this.isCleaned()) {
            return null;
        }
        List<CsmUID<CsmVariable>> vars = this.getFileLocalIncludeVariables().get(name);
        if (vars == null || vars.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CsmVariable> res = new ArrayList<CsmVariable>(vars.size());
        for (CsmUID<CsmVariable> uid : vars) {
            CsmVariable v = (CsmVariable)uid.getObject();
            if (v == null) continue;
            res.add(v);
        }
        return res;
    }

    public CsmObject findInnerFileDeclaration(int offset) {
        if (this.isCleaned()) {
            return null;
        }
        OffsetsObjects anOffsets = this.getFileOffsets();
        Offsets key = new Offsets(offset);
        int res = Collections.binarySearch(anOffsets.fileDeclarationsOffsets, key);
        if (res >= 0) {
            Offsets next;
            if (res < anOffsets.fileDeclarationsOffsets.size() - 1 && (next = (Offsets)anOffsets.fileDeclarationsOffsets.get(res + 1)).compareTo(key) == 0) {
                return next.object;
            }
            return ((Offsets)anOffsets.fileDeclarationsOffsets.get(res)).object;
        }
        return null;
    }

    public CsmObject findInnerFileObject(int offset) {
        if (this.isCleaned()) {
            return null;
        }
        OffsetsObjects anOffsets = this.getFileOffsets();
        Offsets key = new Offsets(offset);
        int res = Collections.binarySearch(anOffsets.fileObjectOffsets, key);
        if (res >= 0) {
            Offsets next;
            if (res < anOffsets.fileObjectOffsets.size() - 1 && (next = (Offsets)anOffsets.fileObjectOffsets.get(res + 1)).compareTo(key) == 0) {
                return next.object;
            }
            return ((Offsets)anOffsets.fileObjectOffsets.get(res)).object;
        }
        return null;
    }

    public CsmMacro findIncludedMacro(String name) {
        CsmUID<CsmMacro> uid;
        if (this.isCleaned()) {
            return null;
        }
        if (this.projectMacros == null) {
            this.projectMacros = new HashMap<CharSequence, CsmUID<CsmMacro>>();
            this.fillProjectMacros();
        }
        if ((uid = this.projectMacros.get(CharSequences.create((CharSequence)name))) != null) {
            return (CsmMacro)uid.getObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<CsmUID<CsmVariable>>> getFileLocalIncludeVariables() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.fileLocalVars == null) {
                this.fileLocalVars = new HashMap<String, List<CsmUID<CsmVariable>>>();
                CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
                CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, null, true, true, false);
                ArrayList<CsmVariable> allVars = new ArrayList<CsmVariable>(10);
                CsmProjectContentResolver.fillFileLocalVariablesByFilter(filter, this.csmFile, allVars);
                for (CsmVariable var : allVars) {
                    String name = ((Object)var.getName()).toString();
                    List<CsmUID<CsmVariable>> list = this.fileLocalVars.get(name);
                    if (list == null) {
                        list = new ArrayList<CsmUID<CsmVariable>>();
                        this.fileLocalVars.put(name, list);
                    }
                    list.add((CsmUID<CsmVariable>)UIDs.get((Object)var));
                }
            }
            return this.fileLocalVars;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffsetsObjects getFileOffsets() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.offsets == null) {
                this.offsets = new OffsetsObjects(new ArrayList(), new ArrayList());
                for (CsmOffsetableDeclaration declaration : this.csmFile.getDeclarations()) {
                    this.offsets.fileDeclarationsOffsets.add(new Offsets(declaration));
                }
                for (CsmOffsetableDeclaration declaration : this.csmFile.getIncludes()) {
                    this.offsets.fileObjectOffsets.add(new Offsets((CsmInclude)declaration));
                }
                for (CsmOffsetableDeclaration declaration : this.csmFile.getMacros()) {
                    this.offsets.fileObjectOffsets.add(new Offsets((CsmMacro)declaration));
                }
                Collections.sort(this.offsets.fileObjectOffsets);
            }
            return this.offsets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileParsingFinished(CsmFile file) {
        if (file.equals(this.csmFile)) {
            Lock lock = this.lock;
            synchronized (lock) {
                this.fileLocalVars = null;
                this.offsets = null;
                this.symTabCache.clear();
            }
        }
    }

    private void fillProjectMacros() {
        this.gatherIncludeMacros(this.csmFile, new HashSet<CsmFile>());
    }

    private void gatherIncludeMacros(CsmFile file, Set<CsmFile> visitedFiles) {
        if (visitedFiles.contains(file)) {
            return;
        }
        visitedFiles.add(file);
        for (CsmInclude inc : file.getIncludes()) {
            CsmFile incFile = inc.getIncludeFile();
            if (incFile == null) continue;
            this.getFileLocalMacros(incFile);
            this.gatherIncludeMacros(incFile, visitedFiles);
        }
    }

    private void getFileLocalMacros(CsmFile file) {
        for (CsmMacro macro : file.getMacros()) {
            CharSequence name = macro.getName();
            CsmUID<CsmMacro> uid = this.projectMacros.get(name);
            if (uid != null) continue;
            this.projectMacros.put(name, (CsmUID<CsmMacro>)UIDs.get((Object)macro));
        }
    }

    private static class Offsets
    implements Comparable<Offsets> {
        private int startOffset;
        private int endOffset;
        private CsmObject object;

        Offsets(CsmOffsetableDeclaration declaration) {
            this.startOffset = declaration.getStartOffset();
            this.endOffset = declaration.getEndOffset();
            this.object = declaration;
        }

        Offsets(CsmMacro macros) {
            this.startOffset = macros.getStartOffset();
            this.endOffset = macros.getEndOffset();
            this.object = macros;
        }

        Offsets(CsmInclude include) {
            this.startOffset = include.getStartOffset();
            this.endOffset = include.getEndOffset();
            this.object = include;
        }

        Offsets(int offset) {
            this.startOffset = offset;
            this.endOffset = offset;
        }

        @Override
        public int compareTo(Offsets o) {
            if (this.object != null && o.object == null ? this.startOffset <= o.startOffset && o.startOffset < this.endOffset : this.object == null && o.object != null && o.startOffset <= this.startOffset && this.startOffset < o.endOffset) {
                return 0;
            }
            return this.startOffset - o.startOffset;
        }
    }

    private static final class OffsetsObjects {
        private final List<Offsets> fileObjectOffsets;
        private final List<Offsets> fileDeclarationsOffsets;

        private OffsetsObjects(List<Offsets> fileObjectOffsets, List<Offsets> fileDeclarationsOffsets) {
            this.fileObjectOffsets = fileObjectOffsets;
            this.fileDeclarationsOffsets = fileDeclarationsOffsets;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

