/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.groovy.support.debug.GroovyLineBreakpoint;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;

public class Context {
    private static EditorContext editorContext;

    private static EditorContext getContext() {
        List l;
        if (editorContext == null && !(l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class)).isEmpty()) {
            editorContext = (EditorContext)l.get(0);
        }
        return editorContext;
    }

    public static boolean showSource(String url, int lineNumber, Object timeStamp) {
        return Context.getContext().showSource(url, lineNumber, timeStamp);
    }

    public static Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return Context.getContext().annotate(url, lineNumber, annotationType, timeStamp);
    }

    public static void removeAnnotation(Object annotation) {
        Context.getContext().removeAnnotation(annotation);
    }

    public static int getLineNumber(Object annotation, Object timeStamp) {
        return Context.getContext().getLineNumber(annotation, timeStamp);
    }

    public static int getCurrentLineNumber() {
        return Context.getContext().getCurrentLineNumber();
    }

    public static String getCurrentURL() {
        return Context.getContext().getCurrentURL();
    }

    public static FileObject getCurrentFile() {
        return EditorContextDispatcher.getDefault().getCurrentFile();
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-groovy", l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        EditorContextDispatcher.getDefault().removePropertyChangeListener(l);
    }

    public static void createTimeStamp(Object timeStamp) {
        Context.getContext().createTimeStamp(timeStamp);
    }

    public static void disposeTimeStamp(Object timeStamp) {
        Context.getContext().disposeTimeStamp(timeStamp);
    }

    public static String getFileName(GroovyLineBreakpoint b) {
        try {
            return new File(new URL(b.getURL()).getFile()).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean showSource(GroovyLineBreakpoint b) {
        if (b.getLineNumber() < 1) {
            return Context.showSource(b.getURL(), 1, null);
        }
        return Context.showSource(b.getURL(), b.getLineNumber(), null);
    }

    public static Object annotate(GroovyLineBreakpoint b) {
        boolean isConditional;
        String url = b.getURL();
        int lineNumber = b.getLineNumber();
        if (lineNumber < 1) {
            return null;
        }
        String condition = b.getCondition();
        boolean bl = isConditional = condition != null && !condition.trim().equals("");
        String annotationType = b.isEnabled() ? (isConditional ? "CondBreakpoint" : "Breakpoint") : (isConditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        return Context.annotate(url, lineNumber, annotationType, (Object)b);
    }
}

