/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class SuggestionsTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(SuggestionsTask.class.getName());
    private boolean cancelled = false;

    public void run(ParserResult result, SchedulerEvent event) {
        this.resume();
        FileObject fileObject = result.getSnapshot().getSource().getFileObject();
        if (fileObject == null || this.isCancelled()) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent) || this.isCancelled()) {
            return;
        }
        CursorMovedSchedulerEvent evt = (CursorMovedSchedulerEvent)event;
        int[] range = new int[]{Math.min(evt.getMarkOffset(), evt.getCaretOffset()), Math.max(evt.getMarkOffset(), evt.getCaretOffset())};
        if (range != null && range.length == 2 && range[0] != -1 && range[1] != -1 && range[0] != range[1]) {
            HintsController.setErrors((FileObject)fileObject, (String)SuggestionsTask.class.getName(), Collections.emptyList());
            return;
        }
        final int pos = evt.getCaretOffset();
        if (pos == -1 || this.isCancelled()) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(result.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result r = resultIterator.getParserResult(pos);
                    if (!(r instanceof ParserResult)) {
                        return;
                    }
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(r.getSnapshot().getMimeType());
                    if (language == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    HintsProvider provider = language.getHintsProvider();
                    if (provider == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    GsfHintsManager manager = language.getHintsManager();
                    if (manager == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    RuleContext ruleContext = manager.createRuleContext((ParserResult)r, language, pos, -1, -1);
                    if (ruleContext == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    ArrayList<ErrorDescription> descriptions = new ArrayList<ErrorDescription>();
                    ArrayList<Hint> hints = new ArrayList<Hint>();
                    provider.computeSuggestions(manager, ruleContext, hints, pos);
                    for (int i = 0; i < hints.size(); ++i) {
                        Hint hint = (Hint)hints.get(i);
                        if (SuggestionsTask.this.isCancelled()) {
                            return;
                        }
                        ErrorDescription desc = manager.createDescription(hint, ruleContext, false, i == hints.size() - 1);
                        descriptions.add(desc);
                    }
                    if (SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    HintsController.setErrors((FileObject)r.getSnapshot().getSource().getFileObject(), (String)SuggestionsTask.class.getName(), descriptions);
                }
            });
        }
        catch (ParseException e) {
            LOG.log(Level.WARNING, null, e);
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    private synchronized void resume() {
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }
}

