/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.AuthConstraint;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.UserDataConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRolesEditorPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTablePanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SecurityConstraintPanel
extends SectionInnerPanel {
    private SectionView view;
    private DDDataObject dObj;
    private WebApp webApp;
    private SecurityConstraint constraint;
    private JCheckBox authConstraintCB;
    private JLabel authConstraintDescLabel;
    private JTextField authConstraintDescTF;
    private JLabel displayNameLabel;
    private JTextField displayNameTF;
    private JButton editButton;
    private JPanel jPanel1;
    private JLabel roleNamesLabel;
    private JTextField roleNamesTF;
    private JComboBox transportGuaranteeCB;
    private JLabel transportGuaranteeLabel;
    private JCheckBox userDataConstraintCB;
    private JLabel userDataConstraintDescLabel;
    private JTextField userDataConstraintDescTF;
    private JLabel webResourceCollectionLabel;
    private JPanel webResourceCollectionPanel;
    private JPanel webResourceCollectionPanel2;

    public SecurityConstraintPanel(SectionView view, DDDataObject dObj, SecurityConstraint constraint) {
        super(view);
        this.initComponents();
        this.view = view;
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.constraint = constraint;
        this.initPanel();
    }

    private void initPanel() {
        this.displayNameTF.setText(this.constraint.getDefaultDisplayName());
        this.addValidatee(this.displayNameTF);
        AuthConstraint authConstraint = this.constraint.getAuthConstraint();
        if (authConstraint != null) {
            this.authConstraintCB.setSelected(true);
            this.updateVisualState();
            String nameString = this.getRoleNamesString(authConstraint);
            this.roleNamesTF.setText(nameString);
            this.authConstraintDescTF.setText(authConstraint.getDefaultDescription());
        }
        this.addModifier(this.authConstraintCB);
        this.addModifier(this.authConstraintDescTF);
        UserDataConstraint userDataConstraint = this.constraint.getUserDataConstraint();
        if (userDataConstraint != null) {
            this.userDataConstraintCB.setSelected(true);
            this.updateVisualState();
            this.transportGuaranteeCB.setSelectedItem(userDataConstraint.getTransportGuarantee());
            this.userDataConstraintDescTF.setText(userDataConstraint.getDefaultDescription());
        }
        this.addModifier(this.userDataConstraintCB);
        this.addModifier(this.userDataConstraintDescTF);
        this.addModifier(this.transportGuaranteeCB);
        WebResourceCollectionTableModel model = new WebResourceCollectionTableModel();
        WebResourceCollectionTablePanel panel = new WebResourceCollectionTablePanel(this.dObj, model);
        panel.setModel(this.dObj.getWebApp(), this.constraint, this.constraint.getWebResourceCollection());
        this.webResourceCollectionPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.webResourceCollectionPanel2.add((Component)((Object)panel), gridBagConstraints);
    }

    private void updateVisualState() {
        if (this.authConstraintCB.isSelected()) {
            this.authConstraintDescLabel.setEnabled(true);
            this.authConstraintDescTF.setEnabled(true);
            this.roleNamesLabel.setEnabled(true);
            this.roleNamesTF.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.authConstraintDescLabel.setEnabled(false);
            this.authConstraintDescTF.setEnabled(false);
            this.roleNamesLabel.setEnabled(false);
            this.roleNamesTF.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        if (this.userDataConstraintCB.isSelected()) {
            this.userDataConstraintDescLabel.setEnabled(true);
            this.userDataConstraintDescTF.setEnabled(true);
            this.transportGuaranteeLabel.setEnabled(true);
            this.transportGuaranteeCB.setEnabled(true);
        } else {
            this.userDataConstraintDescLabel.setEnabled(false);
            this.userDataConstraintDescTF.setEnabled(false);
            this.transportGuaranteeLabel.setEnabled(false);
            this.transportGuaranteeCB.setEnabled(false);
        }
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    public JComponent getErrorComponent(String name) {
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
        if (comp == this.displayNameTF) {
            String val = value;
            if (val.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Display Name", (JComponent)this.displayNameTF));
                return;
            }
            SecurityConstraint[] constraints = this.webApp.getSecurityConstraint();
            for (int i = 0; i < constraints.length; ++i) {
                if (constraints[i] == this.constraint || !val.equals(constraints[i].getDefaultDisplayName())) continue;
                this.getSectionView().getErrorPanel().setError(new Error(0, 3, val, (JComponent)this.displayNameTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    public void setValue(JComponent source, Object value) {
        if (source == this.displayNameTF) {
            String text = (String)value;
            this.constraint.setDisplayName(text);
            SectionPanel enclosingPanel = this.getSectionView().findSectionPanel((Object)this.constraint);
            enclosingPanel.setTitle(text);
            enclosingPanel.getNode().setDisplayName(text);
        } else if (source == this.authConstraintCB) {
            if (this.authConstraintCB.isSelected()) {
                this.refillAuthConstraint();
            } else {
                this.setAuthConstraint(null);
            }
        } else if (source == this.roleNamesTF) {
            this.refillAuthConstraint();
        } else if (source == this.authConstraintDescTF) {
            this.refillAuthConstraint();
        } else if (source == this.userDataConstraintCB) {
            if (this.userDataConstraintCB.isSelected()) {
                this.refillUserDataConstraint();
            } else {
                this.setUserDataConstraint(null);
            }
        } else if (source == this.transportGuaranteeCB) {
            this.refillUserDataConstraint();
        } else if (source == this.userDataConstraintDescTF) {
            this.refillUserDataConstraint();
        }
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.displayNameTF) {
            this.displayNameTF.setText(this.constraint.getDefaultDisplayName());
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void setUserDataConstraint(UserDataConstraint userDataConstraint) {
        this.constraint.setUserDataConstraint(userDataConstraint);
    }

    private UserDataConstraint getUserDataConstraint() {
        UserDataConstraint userDataConstraint = this.constraint.getUserDataConstraint();
        if (userDataConstraint == null) {
            try {
                userDataConstraint = (UserDataConstraint)this.webApp.createBean("UserDataConstraint");
                this.constraint.setUserDataConstraint(userDataConstraint);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return userDataConstraint;
    }

    private void refillUserDataConstraint() {
        this.setUserDataConstraint(null);
        UserDataConstraint userDataConstraint = this.getUserDataConstraint();
        userDataConstraint.setDescription(this.userDataConstraintDescTF.getText());
        userDataConstraint.setTransportGuarantee((String)this.transportGuaranteeCB.getSelectedItem());
    }

    private void setAuthConstraint(AuthConstraint authConstraint) {
        this.constraint.setAuthConstraint(authConstraint);
    }

    private AuthConstraint getAuthConstraint() {
        AuthConstraint authConstraint = this.constraint.getAuthConstraint();
        if (authConstraint == null) {
            try {
                authConstraint = (AuthConstraint)this.webApp.createBean("AuthConstraint");
                this.constraint.setAuthConstraint(authConstraint);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return authConstraint;
    }

    private void refillAuthConstraint() {
        this.setAuthConstraint(null);
        AuthConstraint authConstraint = this.getAuthConstraint();
        authConstraint.setDescription(this.authConstraintDescTF.getText());
        String roleNamesString = this.roleNamesTF.getText();
        StringTokenizer tokenizer = new StringTokenizer(roleNamesString, ",");
        while (tokenizer.hasMoreTokens()) {
            String roleName = tokenizer.nextToken().trim();
            if (roleName.length() <= 0) continue;
            authConstraint.addRoleName(roleName);
        }
    }

    private String getRoleNamesString(AuthConstraint authConstraint) {
        String[] names = authConstraint.getRoleName();
        String nameString = "";
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                nameString = nameString + ", ";
            }
            nameString = nameString + names[i];
        }
        return nameString;
    }

    private String[] getSelectedRoleNames() {
        return this.constraint.getAuthConstraint().getRoleName();
    }

    private String[] getAllRoleNames() {
        SecurityRole[] roles = this.webApp.getSecurityRole();
        String[] roleNames = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            roleNames[i] = roles[i].getRoleName();
        }
        return roleNames;
    }

    private void setSelectedRoleNames(String[] roleNames) {
        AuthConstraint authConstraint = this.constraint.getAuthConstraint();
        authConstraint.setRoleName(roleNames);
        this.roleNamesTF.setText(this.getRoleNamesString(authConstraint));
    }

    private void initComponents() {
        this.displayNameLabel = new JLabel();
        this.displayNameTF = new JTextField();
        this.roleNamesLabel = new JLabel();
        this.roleNamesTF = new JTextField();
        this.authConstraintDescLabel = new JLabel();
        this.authConstraintDescTF = new JTextField();
        this.transportGuaranteeLabel = new JLabel();
        this.transportGuaranteeCB = new JComboBox();
        this.webResourceCollectionLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.webResourceCollectionPanel = new JPanel();
        this.authConstraintCB = new JCheckBox();
        this.userDataConstraintCB = new JCheckBox();
        this.webResourceCollectionPanel2 = new JPanel();
        this.userDataConstraintDescLabel = new JLabel();
        this.userDataConstraintDescTF = new JTextField();
        this.editButton = new JButton();
        this.displayNameLabel.setLabelFor(this.displayNameTF);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)bundle.getString("LBL_displayName"));
        this.roleNamesLabel.setLabelFor(this.roleNamesTF);
        Mnemonics.setLocalizedText((JLabel)this.roleNamesLabel, (String)bundle.getString("LBL_SecurityRoleNames"));
        this.roleNamesLabel.setEnabled(false);
        this.roleNamesTF.setEditable(false);
        this.roleNamesTF.setEnabled(false);
        this.authConstraintDescLabel.setLabelFor(this.authConstraintDescTF);
        Mnemonics.setLocalizedText((JLabel)this.authConstraintDescLabel, (String)bundle.getString("LBL_SecurityRoleDescription"));
        this.authConstraintDescLabel.setEnabled(false);
        this.authConstraintDescTF.setEnabled(false);
        this.transportGuaranteeLabel.setLabelFor(this.transportGuaranteeCB);
        Mnemonics.setLocalizedText((JLabel)this.transportGuaranteeLabel, (String)bundle.getString("LBL_TransportGuarantee"));
        this.transportGuaranteeLabel.setEnabled(false);
        this.transportGuaranteeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"}));
        this.transportGuaranteeCB.setEnabled(false);
        this.webResourceCollectionLabel.setLabelFor(this.webResourceCollectionPanel);
        Mnemonics.setLocalizedText((JLabel)this.webResourceCollectionLabel, (String)bundle.getString("LBL_WebResourceCollection"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.webResourceCollectionPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.authConstraintCB, (String)bundle.getString("LBL_AuthConstraint"));
        this.authConstraintCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.authConstraintCB.setMargin(new Insets(0, 0, 0, 0));
        this.authConstraintCB.setOpaque(false);
        this.authConstraintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityConstraintPanel.this.authConstraintCBActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.userDataConstraintCB, (String)bundle.getString("LBL_UserDataConstraint"));
        this.userDataConstraintCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.userDataConstraintCB.setMargin(new Insets(0, 0, 0, 0));
        this.userDataConstraintCB.setOpaque(false);
        this.userDataConstraintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityConstraintPanel.this.userDataConstraintCBActionPerformed(evt);
            }
        });
        this.webResourceCollectionPanel2.setOpaque(false);
        GroupLayout webResourceCollectionPanel2Layout = new GroupLayout((Container)this.webResourceCollectionPanel2);
        this.webResourceCollectionPanel2.setLayout((LayoutManager)webResourceCollectionPanel2Layout);
        webResourceCollectionPanel2Layout.setHorizontalGroup((GroupLayout.Group)webResourceCollectionPanel2Layout.createParallelGroup(1).add(0, 544, Short.MAX_VALUE));
        webResourceCollectionPanel2Layout.setVerticalGroup((GroupLayout.Group)webResourceCollectionPanel2Layout.createParallelGroup(1).add(0, 38, Short.MAX_VALUE));
        this.userDataConstraintDescLabel.setLabelFor(this.userDataConstraintDescTF);
        Mnemonics.setLocalizedText((JLabel)this.userDataConstraintDescLabel, (String)bundle.getString("LBL_UserDataConstraintDescription"));
        this.userDataConstraintDescLabel.setEnabled(false);
        this.userDataConstraintDescTF.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)bundle.getString("LBL_EditRoleNames"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityConstraintPanel.this.editButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.transportGuaranteeLabel).addPreferredGap(0).add((Component)this.transportGuaranteeCB, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.userDataConstraintDescLabel).addPreferredGap(0).add((Component)this.userDataConstraintDescTF, -1, 466, Short.MAX_VALUE))).addPreferredGap(0)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.displayNameLabel).addPreferredGap(0).add((Component)this.displayNameTF, -1, 472, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.userDataConstraintCB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.webResourceCollectionPanel, -2, -1, -2).add((Component)this.jPanel1, -2, -1, -2))).add((Component)this.webResourceCollectionLabel).add(2, (Component)this.webResourceCollectionPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.roleNamesLabel).add((Component)this.authConstraintDescLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.roleNamesTF, -1, 455, Short.MAX_VALUE).add((Component)this.authConstraintDescTF, -1, 455, Short.MAX_VALUE))).add((Component)this.authConstraintCB)).add(6, 6, 6).add((Component)this.editButton).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.displayNameTF, -2, -1, -2).add((Component)this.displayNameLabel)).addPreferredGap(0).add((Component)this.webResourceCollectionLabel).addPreferredGap(0).add((Component)this.webResourceCollectionPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.authConstraintCB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.authConstraintDescLabel).add((Component)this.authConstraintDescTF, -2, -1, -2)).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(39, 39, 39).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.webResourceCollectionPanel, -2, -1, -2))).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.roleNamesLabel).add((Component)this.roleNamesTF, -2, -1, -2).add((Component)this.editButton)).addPreferredGap(0).add((Component)this.userDataConstraintCB))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.userDataConstraintDescTF, -2, -1, -2).add((Component)this.userDataConstraintDescLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.transportGuaranteeCB, -2, -1, -2).add((Component)this.transportGuaranteeLabel)).addContainerGap(36, Short.MAX_VALUE)));
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        SecurityRolesEditorPanel dialogPanel = new SecurityRolesEditorPanel(this.getAllRoleNames(), this.getSelectedRoleNames());
        EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(SecurityConstraintPanel.class, (String)"TTL_RoleNames"), false){

            protected String validate() {
                return null;
            }
        };
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
        d.setVisible(true);
        if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
            this.dObj.modelUpdatedFromUI();
            this.dObj.setChangedFromUI(true);
            String[] selectedRoles = dialogPanel.getSelectedRoles();
            this.setSelectedRoleNames(selectedRoles);
            this.dObj.setChangedFromUI(false);
        }
    }

    private void userDataConstraintCBActionPerformed(ActionEvent evt) {
        this.updateVisualState();
    }

    private void authConstraintCBActionPerformed(ActionEvent evt) {
        this.updateVisualState();
    }
}

