/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Comparator;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedGetConstructorFor;
import oracle.toplink.essentials.internal.security.PrivilegedInvokeConstructor;
import oracle.toplink.essentials.internal.security.PrivilegedNewInstanceFromClass;

public class SortedCollectionContainerPolicy
extends CollectionContainerPolicy {
    protected Comparator m_comparator = null;

    public SortedCollectionContainerPolicy() {
    }

    public SortedCollectionContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public Object containerInstance() {
        try {
            if (this.m_comparator != null) {
                Object[] arguments = new Object[]{this.m_comparator};
                Class[] constructClass = new Class[]{Comparator.class};
                Constructor constructor = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), constructClass, false));
                        return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, arguments));
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                    }
                }
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), constructClass, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, arguments);
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }
}

