/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class AppProjectGenerator {
    private AppProjectGenerator() {
    }

    static FileObject createProjectFromTemplate(FileObject zippedTemplate, File projectDir, String[] toReplace, String[] replaceWith) throws IOException {
        FileObject projectFolderFO;
        Stack<String> nameStack = new Stack<String>();
        while ((projectFolderFO = FileUtil.toFileObject((File)projectDir)) == null) {
            nameStack.push(projectDir.getName());
            projectDir = projectDir.getParentFile();
        }
        while (!nameStack.empty()) {
            projectFolderFO = projectFolderFO.createFolder((String)nameStack.pop());
        }
        AppProjectGenerator.unzip(zippedTemplate, projectFolderFO, toReplace, replaceWith);
        projectFolderFO.refresh(false);
        ProjectManager.getDefault().clearNonProjectCache();
        return projectFolderFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(FileObject zippedTemplate, FileObject targetFolder, String[] toReplace, String[] replaceWith) throws IOException {
        ZipInputStream zip = new ZipInputStream(zippedTemplate.getInputStream());
        ReplacingOutputStream replacer = new ReplacingOutputStream(toReplace, replaceWith);
        try {
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                String fileName = entry.getName();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(fileName.length());
                replacer.setOutput(baos);
                replacer.write(fileName.getBytes());
                replacer.close();
                fileName = baos.toString("UTF-8");
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)fileName);
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)fileName);
                FileLock lock = destFile.lock();
                try {
                    OutputStream output = destFile.getOutputStream(lock);
                    String encoding = null;
                    boolean propertiesEncoding = false;
                    String ext = destFile.getExt().toLowerCase();
                    if (ext.endsWith("java")) {
                        encoding = FileEncodingQuery.getDefaultEncoding().name();
                    } else if (ext.endsWith("form") || ext.endsWith("xml")) {
                        encoding = "UTF-8";
                    } else if (ext.endsWith("properties")) {
                        encoding = "ISO-8859-1";
                        propertiesEncoding = true;
                    } else if (fileName.startsWith("src/META-INF/")) {
                        encoding = FileEncodingQuery.getDefaultEncoding().name();
                    }
                    if (encoding != null || propertiesEncoding) {
                        replacer.setOutput(output, encoding, propertiesEncoding);
                        output = replacer;
                    }
                    try {
                        FileUtil.copy((InputStream)zip, (OutputStream)output);
                    }
                    finally {
                        output.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    static FileObject getGeneratedFile(FileObject projectFolder, String templFileName, String[] templateNames, String[] substNames) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(templFileName.length());
        ReplacingOutputStream replacer = new ReplacingOutputStream(templateNames, substNames);
        replacer.setOutput(baos);
        try {
            replacer.write(templFileName.getBytes());
            replacer.close();
            templFileName = baos.toString("UTF-8");
        }
        catch (IOException ex) {
            // empty catch block
        }
        return projectFolder.getFileObject(templFileName);
    }

    private static class ReplacingOutputStream
    extends OutputStream {
        private OutputStream output;
        private String[] toReplace;
        private String[] replaceWith;
        private int[] matchCounts;
        private StringBuilder pendingChars;
        private boolean forcePathNames;
        private String encoding;
        private boolean propertiesEncoding;

        ReplacingOutputStream(String[] toReplace, String[] replaceWith) {
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
            this.pendingChars = new StringBuilder(50);
        }

        void setOutput(OutputStream output) {
            this.output = output;
            this.forcePathNames = true;
            this.encoding = "UTF-8";
            this.propertiesEncoding = false;
            this.matchCounts = new int[this.toReplace.length];
        }

        void setOutput(OutputStream output, String encoding, boolean propertiesEncoding) {
            this.output = output;
            this.forcePathNames = false;
            this.encoding = encoding;
            this.propertiesEncoding = propertiesEncoding;
            this.matchCounts = new int[this.toReplace.length];
        }

        @Override
        public void write(int b) throws IOException {
            int completeMatch = -1;
            boolean charMatch = false;
            for (int i = 0; i < this.toReplace.length; ++i) {
                String template = this.toReplace[i];
                int count = this.matchCounts[i];
                if (template.charAt(count) == b) {
                    if (count + 1 == template.length()) {
                        completeMatch = i;
                        break;
                    }
                    this.matchCounts[i] = count + 1;
                    charMatch = true;
                    continue;
                }
                this.matchCounts[i] = 0;
            }
            if (completeMatch >= 0) {
                int preCount = this.pendingChars.length() - this.matchCounts[completeMatch];
                if (preCount > 0) {
                    this.output.write(this.pendingChars.substring(0, preCount).getBytes());
                }
                String subst = this.replaceWith[completeMatch];
                if (this.forcePathNames) {
                    subst = subst.replace('.', '/');
                }
                this.output.write(this.encode(subst));
                for (int i = 0; i < this.matchCounts.length; ++i) {
                    this.matchCounts[i] = 0;
                }
                this.pendingChars.delete(0, this.pendingChars.length());
            } else if (charMatch) {
                this.pendingChars.append((char)b);
            } else {
                this.writePendingBytes();
                this.output.write(b);
            }
        }

        private byte[] encode(String str) {
            if (this.propertiesEncoding) {
                str = UtilConvert.saveConvert((String)str);
            }
            if (this.encoding != null) {
                try {
                    return str.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(AppProjectGenerator.class.getName()).log(Level.INFO, "", ex);
                }
            }
            return str.getBytes();
        }

        private void writePendingBytes() throws IOException {
            if (this.pendingChars.length() > 0) {
                this.output.write(this.pendingChars.toString().getBytes());
                this.pendingChars.delete(0, this.pendingChars.length());
            }
        }

        @Override
        public void flush() throws IOException {
            this.writePendingBytes();
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            this.writePendingBytes();
            this.output.close();
        }
    }
}

