/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.adapter.GlobalRepositoryTreeAdapter;
import org.netbeans.modules.vmd.game.view.GameDesignTreeNodeRenderer;

public class GameDesignNavigator
extends JPanel {
    private GlobalRepository gameDesign;
    private JTree tree;
    private GlobalRepositoryTreeAdapter model;

    public GameDesignNavigator(GlobalRepository gameDesign) {
        this.gameDesign = gameDesign;
        this.init();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }

    private void init() {
        this.model = new GlobalRepositoryTreeAdapter(this.gameDesign);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new GameDesignTreeNodeRenderer());
        this.tree.addMouseListener(new TreeMousListener());
    }

    private class TreeMousListener
    extends MouseAdapter {
        private TreeMousListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handlePopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(e)) {
                Object node = this.getSelectedNodeObj(e);
                if (node instanceof Editable) {
                    Editable editable = (Editable)node;
                    GameDesignNavigator.this.gameDesign.getMainView().requestEditing(editable);
                } else {
                    super.mouseClicked(e);
                }
            } else {
                super.mouseClicked(e);
            }
        }

        private Object getSelectedNodeObj(MouseEvent e) {
            TreePath tp = GameDesignNavigator.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            GameDesignNavigator.this.tree.setSelectionPath(tp);
            return tp.getLastPathComponent();
        }

        private void handlePopup(MouseEvent e) {
            Object node = this.getSelectedNodeObj(e);
            if (node instanceof Editable) {
                Editable editable = (Editable)node;
                JPopupMenu menu = new JPopupMenu();
                for (Action action : editable.getActions()) {
                    menu.add(action);
                }
                menu.show(GameDesignNavigator.this.tree, e.getX(), e.getY());
            }
        }
    }
}

