/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.ui;

import java.awt.event.ActionEvent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.testrunner.ui.BaseTestMethodNodeAction;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.text.PositionBounds;

final class JumpToTestAction
extends BaseTestMethodNodeAction {
    private final boolean jumpToClass;

    JumpToTestAction(Testcase testcase, Project project, String name, boolean clazz) {
        super(testcase, project, name);
        this.jumpToClass = clazz;
    }

    protected void doActionPerformed(ActionEvent e) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = cdp.getConfigurationDescriptor();
        if (projectDescriptor == null) {
            return;
        }
        Folder root = projectDescriptor.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        String absPath = null;
        if (testRootFolder != null) {
            block1: for (Folder folder : testRootFolder.getAllTests()) {
                Item[] items = folder.getAllItemsAsArray();
                for (int k = 0; k < items.length; ++k) {
                    if (!items[k].getName().replaceAll("(.*)\\..*", "$1").equals(this.testcase.getClassName())) continue;
                    absPath = items[k].getAbsPath();
                    break block1;
                }
            }
        }
        if (absPath == null) {
            return;
        }
        CsmFile file = CsmModelAccessor.getModel().findFile(absPath, true, false);
        if (file == null) {
            return;
        }
        CsmOffsetableDeclaration targetDecl = null;
        for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
            if (!((Object)decl.getName()).toString().equals(this.testcase.getName())) continue;
            targetDecl = decl;
            break;
        }
        if (targetDecl == null) {
            return;
        }
        PositionBounds position = CsmUtilities.createPositionBounds(targetDecl);
        CsmUtilities.openSource((PositionBounds)position);
    }
}

