/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJCJavaModelImpl
implements JavaModel {
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private Map<String, JavaClass> javaModelClasses = new HashMap<String, JavaClass>();

    public XJCJavaModelImpl(JCodeModel codeModel, DynamicClassLoader dynLoader) {
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = dynLoader;
    }

    @Override
    public JavaClass getClass(Class<?> jClass) {
        if (jClass == null) {
            return null;
        }
        JavaClass cachedClass = this.javaModelClasses.get(jClass.getCanonicalName());
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._class(jClass.getCanonicalName()), this.jCodeModel, this.dynamicClassLoader);
            jc.setJavaModel(this);
            this.javaModelClasses.put(jClass.getCanonicalName(), jc);
            return jc;
        }
        catch (JClassAlreadyExistsException ex) {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._getClass(jClass.getCanonicalName()), this.jCodeModel, this.dynamicClassLoader);
            this.javaModelClasses.put(jClass.getCanonicalName(), jc);
            jc.setJavaModel(this);
            return jc;
        }
    }

    @Override
    public JavaClass getClass(String className) {
        JavaClass cachedClass = this.javaModelClasses.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._class(className), this.jCodeModel, this.dynamicClassLoader);
            this.javaModelClasses.put(className, jc);
            return jc;
        }
        catch (JClassAlreadyExistsException ex) {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._getClass(className), this.jCodeModel, this.dynamicClassLoader);
            this.javaModelClasses.put(className, jc);
            return jc;
        }
    }

    @Override
    public Annotation getAnnotation(JavaAnnotation annotation, Class<?> jClass) {
        return ((XJCJavaAnnotationImpl)annotation).getJavaAnnotation();
    }

    public Map<String, JavaClass> getJavaModelClasses() {
        return this.javaModelClasses;
    }

    public void setJavaModelClasses(Map<String, JavaClass> javaModelClasses) {
        this.javaModelClasses = javaModelClasses;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.dynamicClassLoader;
    }
}

