/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OraclePreparedStatement;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.Oracle9Platform;

public class Oracle10Platform
extends Oracle9Platform {
    public int executeBatch(Statement statement, boolean isStatementPrepared) throws SQLException {
        if (this.usesNativeBatchWriting() && isStatementPrepared) {
            return ((OraclePreparedStatement)statement).sendBatch();
        }
        int[] results = statement.executeBatch();
        return statement.getUpdateCount();
    }

    public boolean isNativeConnectionRequiredForLobLocator() {
        return false;
    }

    public void writeLOB(DatabaseField field, Object value, ResultSet resultSet, AbstractSession session) throws SQLException {
        if (this.isBlob(field.getType())) {
            Blob blob = (Blob)resultSet.getObject(field.getNameDelimited(this));
            blob.setBytes(1L, (byte[])value);
            session.log(1, "sql", "write_BLOB", blob.length(), field.getNameDelimited(this));
        } else if (this.isClob(field.getType())) {
            Clob clob = (Clob)resultSet.getObject(field.getNameDelimited(this));
            clob.setString(1L, (String)value);
            session.log(1, "sql", "write_CLOB", clob.length(), field.getNameDelimited(this));
        }
    }

    public boolean canBatchWriteWithOptimisticLocking(DatabaseCall call) {
        return true;
    }
}

