/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.refactoring.JavaRenameChanger;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

public class JavaPackageRenameTransaction
extends RenameTransaction {
    public JavaPackageRenameTransaction(Set<FileObject> files, String oldName, String newName) {
        super(files, oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        JavaRenameChanger renamer = new JavaRenameChanger(true, this.origName, this.newName);
        for (FileObject mappingFileObject : this.getToBeModifiedFiles()) {
            OutputStream outs = null;
            try {
                InputStream is = mappingFileObject.getInputStream();
                HibernateMapping hbMapping = HibernateMapping.createGraph(is);
                String pkgName = hbMapping.getAttributeValue("Package");
                if (pkgName != null && pkgName.equals(this.origName)) {
                    hbMapping.setAttributeValue("Package", this.newName);
                }
                renamer.refactoringImports(hbMapping);
                renamer.refactoringMyClasses(hbMapping.getMyClass());
                renamer.refactoringSubclasses(hbMapping.getSubclass());
                renamer.refactoringJoinedSubclasses(hbMapping.getJoinedSubclass());
                renamer.refactoringUnionSubclasses(hbMapping.getUnionSubclass());
                outs = mappingFileObject.getOutputStream();
                hbMapping.write(outs);
            }
            catch (FileAlreadyLockedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                try {
                    if (outs == null) continue;
                    outs.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }
}

