/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.openide.ErrorManager;

public class CustomClassLoader
extends URLClassLoader {
    private Map<String, File> package2File = new HashMap<String, File>();
    private Logger logger = Logger.getLogger(CustomClassLoader.class.getName());

    public CustomClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Initializing Custom Classloader with classpath : ");
            for (URL url : urls) {
                this.logger.info(url.toExternalForm());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean b) throws ClassNotFoundException {
        Class<?> clazz;
        if (name == null) {
            throw new IllegalArgumentException("class name cannot be null");
        }
        if (name.toLowerCase().indexOf("mysql") > -1) {
            System.out.println("CLASS:" + name);
        }
        if ((clazz = this.findLoadedClass(name)) != null) {
            return clazz;
        }
        String packageName = null;
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex != -1) {
            packageName = name.substring(0, lastDotIndex);
        }
        if (packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax") || packageName.startsWith("com.sun") || packageName.startsWith("org.hibernate") || packageName.startsWith("org.dom4j") || packageName.startsWith("net.sf.cglib") || packageName.startsWith("org.w3c") || packageName.startsWith("antlr") || packageName.startsWith("org.objectweb.asm") || packageName.startsWith("org.apache.commons.collections") || packageName.startsWith("net.sf.ehcache") || packageName.startsWith("org.netbeans"))) {
            clazz = super.loadClass(name, b);
        }
        if (clazz != null) {
            return clazz;
        }
        if (packageName != null && packageName.startsWith("org.apache.log4j")) {
            throw new ClassNotFoundException("Log4J is forbidden");
        }
        int dotIndex = name.indexOf(".");
        String fileName = null;
        String separator = File.separator;
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        fileName = dotIndex != -1 ? name.replaceAll("\\.", separator) + ".class" : name + ".class";
        Class loadedClass = null;
        InputStream is = this.getLocalResourceAsStream(packageName, fileName);
        if (is != null) {
            try {
                loadedClass = this.loadClass(name, is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        if (loadedClass != null) {
            return loadedClass;
        }
        return super.loadClass(name, b);
    }

    private Class loadClass(String className, InputStream is) {
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bytes = new byte[5120];
            int readBytes = 0;
            while ((readBytes = bis.read(bytes)) != -1) {
                os.write(bytes, 0, readBytes);
            }
            byte[] b = os.toByteArray();
            return this.defineClass(className, b, 0, b.length);
        }
        catch (ClassFormatError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        perms.setReadOnly();
        return perms;
    }

    private URL getLocalResource(String packageName, String name) {
        File preferred = null;
        if (packageName != null) {
            preferred = this.package2File.get(packageName);
        }
        ArrayList<File> files = new ArrayList<File>();
        if (preferred != null) {
            files.add(preferred);
        }
        for (File entry : files) {
            if (entry.isDirectory() && entry.exists()) {
                File f = new File(entry, name);
                if (!f.exists()) continue;
                try {
                    this.package2File.put(packageName, entry);
                    return f.toURL();
                }
                catch (MalformedURLException ex) {
                    continue;
                }
            }
            if (!entry.isFile() || !entry.exists()) continue;
            try {
                ZipFile zf = new ZipFile(entry);
                ZipEntry zipEntry = zf.getEntry(name = name.replaceAll("\\\\", "/"));
                if (zipEntry == null) continue;
                String url = entry.getAbsolutePath().replaceAll("\\\\", "/");
                if (!url.startsWith("/")) {
                    url = "/" + url;
                }
                URL r = new URL("jar:file://" + url + "!/" + name);
                this.package2File.put(packageName, entry);
                return r;
            }
            catch (ZipException ex) {
            }
            catch (IOException ex) {
            }
        }
        return null;
    }

    private InputStream getLocalResourceAsStream(String packageName, String name) {
        URL res = this.getLocalResource(packageName, name);
        if (res == null) {
            return null;
        }
        try {
            return res.openStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name != null && name.equals("hibernate.properties")) {
            return this.getHibernateProperties();
        }
        InputStream is = this.getLocalResourceAsStream(null, name);
        return is != null ? is : super.getResourceAsStream(name);
    }

    private InputStream getHibernateProperties() {
        ByteArrayInputStream bIn = new ByteArrayInputStream("hibernate.connection.provider_class=org.netbeans.modules.hibernate.util.CustomJDBCConnectionProvider".getBytes());
        return bIn;
    }
}

