/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

public class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    @Deprecated
    private static final boolean DEBUG = false;
    private static final Map<Class, List<Tree.Kind>> class2Kind = new HashMap<Class, List<Tree.Kind>>();
    private static final Set<String> keywords;
    private static final Set<String> nonCtorKeywords;

    private static Token<JavaTokenId> findTokenWithText(CompilationInfo info, String text, int start, int end) {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language()).subSequence(start, end);
        while (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() != JavaTokenId.IDENTIFIER || !text.equals(((Object)info.getTreeUtilities().decodeIdentifier(t.text())).toString())) continue;
            return t;
        }
        return null;
    }

    private static Tree normalizeLastLeftTree(Tree lastLeft) {
        while (lastLeft != null && lastLeft.getKind() == Tree.Kind.ARRAY_TYPE) {
            lastLeft = ((ArrayTypeTree)lastLeft).getType();
        }
        return lastLeft;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, Tree decl, Tree lastLeft, List<? extends Tree> firstRight, String name, CompilationUnitTree cu, SourcePositions positions) {
        int start;
        int declStart = (int)positions.getStartPosition(cu, decl);
        int n = start = (lastLeft = Utilities.normalizeLastLeftTree(lastLeft)) != null ? (int)positions.getEndPosition(cu, lastLeft) : declStart;
        if (start == -1 && (start = declStart) == -1) {
            return null;
        }
        int end = (int)positions.getEndPosition(cu, decl);
        for (Tree tree : firstRight) {
            int proposedEnd;
            if (tree == null || (proposedEnd = (int)positions.getStartPosition(cu, tree)) == -1 || proposedEnd >= end) continue;
            end = proposedEnd;
        }
        if (end == -1) {
            return null;
        }
        if (start > end) {
            start = (int)positions.getStartPosition(cu, decl);
        }
        return Utilities.findTokenWithText(info, name, start, end);
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, MemberSelectTree tree, CompilationUnitTree cu, SourcePositions positions) {
        int start = (int)positions.getStartPosition(cu, tree);
        int endPosition = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || endPosition == -1) {
            return null;
        }
        String member = tree.getIdentifier().toString();
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(endPosition) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext()) {
            while (ts.offset() >= start) {
                Token t = ts.token();
                if (t.id() == JavaTokenId.IDENTIFIER && member.equals(((Object)info.getTreeUtilities().decodeIdentifier(t.text())).toString())) {
                    return t;
                }
                if (ts.movePrevious()) continue;
                break;
            }
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, IdentifierTree tree, CompilationUnitTree cu, SourcePositions positions) {
        int start = (int)positions.getStartPosition(cu, tree);
        int endPosition = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || endPosition == -1) {
            return null;
        }
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(start) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext() && ts.offset() >= start) {
            Token t = ts.token();
            return t;
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo info, TreePath decl) {
        if (info.getTreeUtilities().isSynthetic(decl)) {
            return null;
        }
        Tree leaf = decl.getLeaf();
        if (class2Kind.get(MethodTree.class).contains((Object)leaf.getKind())) {
            MethodTree method = (MethodTree)leaf;
            ArrayList<Tree> rightTrees = new ArrayList<Tree>();
            rightTrees.addAll(method.getParameters());
            rightTrees.addAll(method.getThrows());
            rightTrees.add(method.getBody());
            Name name = method.getName();
            if (method.getReturnType() == null) {
                name = ((ClassTree)decl.getParentPath().getLeaf()).getSimpleName();
            }
            return Utilities.findIdentifierSpanImpl(info, leaf, method.getReturnType(), rightTrees, name.toString(), info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(VariableTree.class).contains((Object)leaf.getKind())) {
            VariableTree var = (VariableTree)leaf;
            return Utilities.findIdentifierSpanImpl(info, leaf, var.getType(), Collections.singletonList(var.getInitializer()), var.getName().toString(), info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(MemberSelectTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, (MemberSelectTree)leaf, info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(ClassTree.class).contains((Object)leaf.getKind())) {
            String name = ((ClassTree)leaf).getSimpleName().toString();
            if (name.length() == 0) {
                return null;
            }
            SourcePositions positions = info.getTrees().getSourcePositions();
            CompilationUnitTree cu = info.getCompilationUnit();
            int start = (int)positions.getStartPosition(cu, leaf);
            int end = (int)positions.getEndPosition(cu, leaf);
            if (start == -1 || end == -1) {
                return null;
            }
            return Utilities.findTokenWithText(info, name, start, end);
        }
        if (class2Kind.get(IdentifierTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, (IdentifierTree)leaf, info.getCompilationUnit(), info.getTrees().getSourcePositions());
        }
        if (class2Kind.get(ParameterizedTypeTree.class).contains((Object)leaf.getKind())) {
            return Utilities.findIdentifierSpanImpl(info, new TreePath(decl, ((ParameterizedTypeTree)leaf).getType()));
        }
        throw new IllegalArgumentException("Only MethodDecl, VariableDecl, MemberSelectTree, IdentifierTree and ClassDecl are accepted by this method. Got: " + (Object)((Object)leaf.getKind()));
    }

    public static int[] findIdentifierSpan(final TreePath decl, final CompilationInfo info, final Document doc) {
        final int[] result = new int[]{-1, -1};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Token<JavaTokenId> t = Utilities.findIdentifierSpan(info, doc, decl);
                if (t != null) {
                    result[0] = t.offset(null);
                    result[1] = t.offset(null) + t.length();
                }
            }
        };
        if (doc != null) {
            doc.render(r);
        } else {
            r.run();
        }
        return result;
    }

    public static Token<JavaTokenId> findIdentifierSpan(final CompilationInfo info, Document doc, final TreePath decl) {
        final Token[] result = new Token[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                result[0] = Utilities.findIdentifierSpanImpl(info, decl);
            }
        };
        if (doc != null) {
            doc.render(r);
        } else {
            r.run();
        }
        return result[0];
    }

    private static int findBodyStartImpl(Tree cltree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, cltree);
        int end = (int)positions.getEndPosition(cu, cltree);
        if (start == -1 || end == -1) {
            return -1;
        }
        if (start > doc.getLength() || end > doc.getLength()) {
            return -1;
        }
        try {
            String text = doc.getText(start, end - start);
            int index = text.indexOf(123);
            if (index == -1) {
                return -1;
            }
            return start + index;
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, null, e);
            return -1;
        }
    }

    public static int findBodyStart(final Tree cltree, final CompilationUnitTree cu, final SourcePositions positions, final Document doc) {
        Tree.Kind kind = cltree.getKind();
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind) && kind != Tree.Kind.METHOD) {
            throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)kind));
        }
        final int[] result = new int[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                result[0] = Utilities.findBodyStartImpl(cltree, cu, positions, doc);
            }
        });
        return result[0];
    }

    private static int findLastBracketImpl(Tree tree, CompilationUnitTree cu, SourcePositions positions, Document doc) {
        int start = (int)positions.getStartPosition(cu, tree);
        int end = (int)positions.getEndPosition(cu, tree);
        if (start == -1 || end == -1) {
            return -1;
        }
        if (start > doc.getLength() || end > doc.getLength()) {
            return -1;
        }
        try {
            String text = doc.getText(end - 1, 1);
            if (text.charAt(0) == '}') {
                return end - 1;
            }
        }
        catch (BadLocationException e) {
            LOG.log(Level.INFO, null, e);
        }
        return -1;
    }

    public static int findLastBracket(final Tree tree, final CompilationUnitTree cu, final SourcePositions positions, final Document doc) {
        final int[] result = new int[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                result[0] = Utilities.findLastBracketImpl(tree, cu, positions, doc);
            }
        });
        return result[0];
    }

    private static Token<JavaTokenId> createHighlightImpl(CompilationInfo info, Document doc, TreePath tree) {
        Tree leaf = tree.getLeaf();
        SourcePositions positions = info.getTrees().getSourcePositions();
        CompilationUnitTree cu = info.getCompilationUnit();
        if (leaf instanceof MethodTree || leaf instanceof VariableTree || leaf instanceof ClassTree || leaf instanceof MemberSelectTree) {
            return Utilities.findIdentifierSpan(info, doc, tree);
        }
        int start = (int)positions.getStartPosition(cu, leaf);
        int end = (int)positions.getEndPosition(cu, leaf);
        if ((long)start == -1L || (long)end == -1L) {
            return null;
        }
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts.move(start) == Integer.MAX_VALUE) {
            return null;
        }
        if (ts.moveNext()) {
            Token token = ts.token();
            if (ts.offset() == start && token != null) {
                JavaTokenId id = (JavaTokenId)token.id();
                if (id == JavaTokenId.IDENTIFIER) {
                    return token;
                }
                if (id == JavaTokenId.THIS || id == JavaTokenId.SUPER) {
                    return ts.offsetToken();
                }
            }
        }
        return null;
    }

    public static Token<JavaTokenId> getToken(final CompilationInfo info, final Document doc, final TreePath tree) {
        final Token[] result = new Token[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                result[0] = Utilities.createHighlightImpl(info, doc, tree);
            }
        });
        return result[0];
    }

    public static boolean isKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return keywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return keywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isNonCtorKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return nonCtorKeywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return nonCtorKeywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isPrivateElement(Element el) {
        if (el.getKind() == ElementKind.PARAMETER) {
            return true;
        }
        if (el.getKind() == ElementKind.LOCAL_VARIABLE) {
            return true;
        }
        if (el.getKind() == ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        return el.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    static {
        for (Tree.Kind k : Tree.Kind.values()) {
            Class<? extends Tree> c = k.asInterface();
            List<Tree.Kind> kinds = class2Kind.get(c);
            if (kinds == null) {
                kinds = new ArrayList<Tree.Kind>();
                class2Kind.put(c, kinds);
            }
            kinds.add(k);
        }
        keywords = new HashSet<String>();
        keywords.add("true");
        keywords.add("false");
        keywords.add("null");
        keywords.add("this");
        keywords.add("super");
        keywords.add("class");
        nonCtorKeywords = new HashSet<String>(keywords);
        nonCtorKeywords.remove("this");
        nonCtorKeywords.remove("super");
    }
}

