/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.debugger.common2.utils.PhasedProgress;

public abstract class ProgressManager {
    private final boolean old = false;
    private PhasedProgress phasedProgress;

    protected ProgressManager() {
    }

    protected PhasedProgress phasedProgress() {
        return this.phasedProgress;
    }

    protected abstract String[] levelLabels();

    protected String title() {
        String title = UIManager.getString("ProgressMonitor.progressText");
        return title;
    }

    public boolean startProgress(PhasedProgress.CancelListener cancelListener, boolean shortNames) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.phasedProgress != null) {
            return false;
        }
        int cols = shortNames ? 40 : 60;
        this.phasedProgress = new PhasedProgress(this.title(), this.levelLabels(), cancelListener, cols);
        this.setCancelListener(cancelListener);
        return true;
    }

    public void finishProgress() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.phasedProgress != null) {
            this.phasedProgress.setVisible(false);
            this.phasedProgress.dispose();
            this.phasedProgress = null;
        }
    }

    public void updateProgress(char beginEnd, int level, String message, int count, int total) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.isCancelled()) {
            return;
        }
        if (beginEnd == '>') {
            if (count == 0) {
                total = 0;
            }
            this.phasedProgress.setMessageFor(level, message, total);
        } else {
            this.phasedProgress.setProgressFor(level, count);
        }
    }

    public boolean isCancelled() {
        if (this.phasedProgress == null) {
            return true;
        }
        return this.phasedProgress.isCancelled();
    }

    public void setCancelListener(PhasedProgress.CancelListener cl) {
        if (this.phasedProgress != null) {
            this.phasedProgress.setCancelListener(cl);
        }
    }
}

