/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class CndRemote {
    private static final RequestProcessor validatorRP = new RequestProcessor("validator");

    public static void validate(final String name, final Runnable continuation) {
        if (name != null && name.equals("localhost")) {
            continuation.run();
            return;
        }
        Runnable validator = new Runnable(){

            public void run() {
                Host host = Host.byName(name);
                ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)host.executionEnvironment());
                serverRecord.validate(true);
                if (!serverRecord.isOnline()) {
                    return;
                }
                ExecutionEnvironment exEnv = serverRecord.getExecutionEnvironment();
                CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)exEnv);
                csm.initialize(true, true, null);
                PlatformInfo.getDefault((ExecutionEnvironment)exEnv);
                try {
                    SwingUtilities.invokeAndWait(continuation);
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                    final String message = MessageFormat.format(Catalog.get("ERR_Cant_Cnnect"), serverRecord.getDisplayName());
                    final String title = Catalog.get("DLG_TITLE_Cant_Connect");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), message, title, 0);
                        }
                    });
                }
            }
        };
        RequestProcessor.Task task = validatorRP.post(validator);
    }

    public static String[] getServerListIDs() {
        ArrayList<String> l = new ArrayList<String>();
        for (ExecutionEnvironment env : ServerList.getEnvironments()) {
            l.add(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env));
        }
        return l.toArray(new String[l.size()]);
    }

    public static String userhostFromConfiguration(Configuration conf) {
        if (!(conf instanceof MakeConfiguration)) {
            return "localhost";
        }
        MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
        DevelopmentHostConfiguration hostConfig = makeConfiguration.getDevelopmentHost();
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)hostConfig.getExecutionEnvironment());
    }

    public static void fillConfiguratioFromHost(Configuration conf, Host host) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)conf;
        if (!makeConfiguration.isMakefileConfiguration()) {
            return;
        }
        DevelopmentHostConfiguration hostConfig = makeConfiguration.getDevelopmentHost();
        ExecutionEnvironment exEnv = host.executionEnvironment();
        String userHostName = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)exEnv);
        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)exEnv);
        CompilerSet2Configuration csconf = makeConfiguration.getCompilerSet();
        if (csm == null || !csconf.isValid()) {
            return;
        }
        String csname = "SunStudio";
        StringConfiguration compilerSetName = new StringConfiguration(null, csname);
        csconf.setCompilerSetName(compilerSetName);
        CompilerSet cs = csm.getCompilerSet(csname);
        if (cs == null) {
            return;
        }
        String base = host.getRemoteStudioLocation();
        base = base + "/bin";
        hostConfig.setValue(userHostName);
    }
}

