/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.api;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.common.project.ui.DeployOnSaveUtils;
import org.netbeans.modules.j2ee.common.project.ui.J2EEProjectProperties;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectCreateData;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EjbJarProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_BUILD_DIR = "build";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";

    private EjbJarProjectGenerator() {
    }

    public static AntProjectHelper createProject(File file, String string, String string2, String string3) throws IOException {
        return EjbJarProjectGenerator.createProject(file, string, string2, string3, null, null);
    }

    @Deprecated
    public static AntProjectHelper createProject(File file, String string, String string2, String string3, String string4, String string5) throws IOException {
        EjbJarProjectCreateData ejbJarProjectCreateData = new EjbJarProjectCreateData();
        ejbJarProjectCreateData.setProjectDir(file);
        ejbJarProjectCreateData.setName(string);
        ejbJarProjectCreateData.setJavaEEProfile(Profile.fromPropertiesString((String)string2));
        ejbJarProjectCreateData.setServerInstanceID(string3);
        ejbJarProjectCreateData.setLibrariesDefinition(string4);
        ejbJarProjectCreateData.setServerLibraryName(string5);
        return EjbJarProjectGenerator.createProject(ejbJarProjectCreateData);
    }

    public static AntProjectHelper createProject(final EjbJarProjectCreateData ejbJarProjectCreateData) throws IOException {
        File file = ejbJarProjectCreateData.getProjectDir();
        final FileObject fileObject = FileUtil.createFolder((File)file);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = EjbJarProjectGenerator.createProjectImpl(ejbJarProjectCreateData, fileObject);
            }
        });
        return antProjectHelperArray[0];
    }

    private static AntProjectHelper createProjectImpl(final EjbJarProjectCreateData ejbJarProjectCreateData, FileObject fileObject) throws IOException {
        String string = ejbJarProjectCreateData.getName();
        String string2 = ejbJarProjectCreateData.getServerInstanceID();
        FileObject fileObject2 = fileObject.createFolder(DEFAULT_SRC_FOLDER);
        fileObject2.createFolder(DEFAULT_JAVA_FOLDER);
        if (!ejbJarProjectCreateData.skipTests()) {
            fileObject.createFolder(DEFAULT_TEST_FOLDER);
        }
        FileObject fileObject3 = fileObject2.createFolder(DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-ejbjarproject/MANIFEST.MF"), (FileObject)fileObject3, (String)"MANIFEST");
        String string3 = EjbJarProjectGenerator.configureServerLibrary(ejbJarProjectCreateData.getLibrariesDefinition(), string2, fileObject, ejbJarProjectCreateData.getServerLibraryName() != null);
        final AntProjectHelper antProjectHelper = EjbJarProjectGenerator.setupProject(fileObject, string, DEFAULT_SRC_FOLDER, DEFAULT_TEST_FOLDER, null, null, null, ejbJarProjectCreateData.getJavaEEProfile(), string2, ejbJarProjectCreateData.getLibrariesDefinition(), string3, ejbJarProjectCreateData.skipTests());
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.put("source.root", DEFAULT_SRC_FOLDER);
        editableProperties.setProperty("meta.inf", "${source.root}/conf");
        editableProperties.setProperty("src.dir", "${source.root}/java");
        editableProperties.setProperty("meta.inf.excludes", "sun-cmp-mappings.xml");
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject((Project)ejbJarProject);
        final ReferenceHelper referenceHelper = ejbJarProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EjbJarProjectGenerator.copyRequiredLibraries(antProjectHelper, referenceHelper, ejbJarProjectCreateData);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException.getException());
        }
        Profile profile = ejbJarProjectCreateData.getJavaEEProfile();
        if (!(Profile.JAVA_EE_5.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile) || Profile.JAVA_EE_6_WEB.equals(profile))) {
            String string4 = "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.1.xml";
            FileObject fileObject4 = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)string4), (FileObject)fileObject3, (String)"ejb-jar");
            EjbJar ejbJar = DDProvider.getDefault().getDDRoot(fileObject4);
            ejbJar.setDisplayName(string);
            ejbJar.write(fileObject4);
        }
        if (ejbJarProjectCreateData.isCDIEnabled()) {
            DDHelper.createBeansXml((Profile)profile, (FileObject)fileObject3);
        }
        return antProjectHelper;
    }

    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3, boolean bl) throws IOException {
        return EjbJarProjectGenerator.importProject(file, string, fileArray, fileArray2, file2, file3, string2, string3, bl, null, null);
    }

    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3, boolean bl, String string4, String string5) throws IOException {
        AntProjectHelper antProjectHelper = EjbJarProjectGenerator.importProject(file, string, fileArray, fileArray2, file2, file3, string2, string3, string4, string5);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("java.source.based", bl + "");
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    @Deprecated
    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3) throws IOException {
        return EjbJarProjectGenerator.importProject(file, string, fileArray, fileArray2, file2, file3, string2, string3, null, null);
    }

    @Deprecated
    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3, String string4, String string5) throws IOException {
        EjbJarProjectCreateData ejbJarProjectCreateData = new EjbJarProjectCreateData();
        ejbJarProjectCreateData.setProjectDir(file);
        ejbJarProjectCreateData.setName(string);
        ejbJarProjectCreateData.setSourceFolders(fileArray);
        ejbJarProjectCreateData.setTestFolders(fileArray2);
        ejbJarProjectCreateData.setConfigFilesBase(file2);
        ejbJarProjectCreateData.setLibFolder(file3);
        ejbJarProjectCreateData.setJavaEEProfile(Profile.fromPropertiesString((String)string2));
        ejbJarProjectCreateData.setServerInstanceID(string3);
        ejbJarProjectCreateData.setLibrariesDefinition(string4);
        ejbJarProjectCreateData.setServerLibraryName(string5);
        return EjbJarProjectGenerator.importProject(ejbJarProjectCreateData);
    }

    public static AntProjectHelper importProject(final EjbJarProjectCreateData ejbJarProjectCreateData) throws IOException {
        File file = ejbJarProjectCreateData.getProjectDir();
        assert (file != null) : "Project folder can't be null";
        final FileObject fileObject = FileUtil.createFolder((File)file);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = EjbJarProjectGenerator.importProjectImpl(ejbJarProjectCreateData, fileObject);
            }
        });
        return antProjectHelperArray[0];
    }

    private static AntProjectHelper importProjectImpl(final EjbJarProjectCreateData ejbJarProjectCreateData, FileObject fileObject) throws IOException {
        String string = ejbJarProjectCreateData.getName();
        final File[] fileArray = ejbJarProjectCreateData.getSourceFolders();
        final File[] fileArray2 = ejbJarProjectCreateData.getTestFolders();
        Profile profile = ejbJarProjectCreateData.getJavaEEProfile();
        String string2 = ejbJarProjectCreateData.getServerInstanceID();
        assert (fileArray != null && fileArray2 != null) : "Package roots can't be null";
        String string3 = EjbJarProjectGenerator.configureServerLibrary(ejbJarProjectCreateData.getLibrariesDefinition(), string2, fileObject, ejbJarProjectCreateData.getServerLibraryName() != null);
        final AntProjectHelper antProjectHelper = EjbJarProjectGenerator.setupProject(fileObject, string, null, null, ejbJarProjectCreateData.getConfigFilesBase(), ejbJarProjectCreateData.getLibFolder(), null, profile, string2, ejbJarProjectCreateData.getLibrariesDefinition(), string3, ejbJarProjectCreateData.skipTests());
        final EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(fileObject);
        final ReferenceHelper referenceHelper = ejbJarProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties editableProperties;
                    Element element;
                    String string;
                    String string2;
                    int n;
                    Element element2 = antProjectHelper.getPrimaryConfigurationData(true);
                    Document document = element2.getOwnerDocument();
                    NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
                    assert (nodeList.getLength() == 1);
                    Element element3 = (Element)nodeList.item(0);
                    nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
                    assert (nodeList.getLength() == 1);
                    Element element4 = (Element)nodeList.item(0);
                    for (n = 0; n < fileArray.length; ++n) {
                        string2 = "src.dir" + (n == 0 ? "" : Integer.toString(n + 1));
                        string = referenceHelper.createForeignFileReference(fileArray[n], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                        element = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                        element.setAttribute("id", string2);
                        element3.appendChild(element);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put(string2, string);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    if (fileArray2.length == 0) {
                        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties2.put("test.src.dir", "");
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
                    } else {
                        for (n = 0; n < fileArray2.length; ++n) {
                            if (!fileArray2[n].exists()) {
                                FileUtil.createFolder((File)fileArray2[n]);
                            }
                            string2 = "test.src.dir" + (n == 0 ? "" : Integer.toString(n + 1));
                            string = referenceHelper.createForeignFileReference(fileArray2[n], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                            element = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                            element.setAttribute("id", string2);
                            element4.appendChild(element);
                            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put(string2, string);
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        }
                    }
                    antProjectHelper.putPrimaryConfigurationData(element2, true);
                    EjbJarProjectGenerator.copyRequiredLibraries(antProjectHelper, referenceHelper, ejbJarProjectCreateData);
                    ProjectManager.getDefault().saveProject((Project)ejbJarProject);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            IOException iOException = new IOException("project creation failed");
            iOException.initCause(mutexException);
            throw iOException;
        }
        FileObject fileObject2 = FileUtil.toFileObject((File)ejbJarProjectCreateData.getConfigFilesBase()).getFileObject("ejb-jar.xml");
        if (fileObject2 != null) {
            try {
                String string4;
                boolean bl;
                EjbJar ejbJar = DDProvider.getDefault().getDDRoot(fileObject2);
                boolean bl2 = false;
                boolean bl3 = ejbJar.getVersion() == null ? true : (bl = new BigDecimal("2.1").compareTo(ejbJar.getVersion()) > 0);
                if (bl && Profile.J2EE_14.equals(profile)) {
                    ejbJar.setVersion(new BigDecimal("2.1"));
                    bl2 = true;
                }
                if (null == (string4 = ejbJar.getDefaultDisplayName()) || string4.trim().length() == 0) {
                    ejbJar.setDisplayName(string);
                    bl2 = true;
                }
                if (bl2) {
                    ejbJar.write(fileObject2);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return antProjectHelper;
    }

    private static void copyRequiredLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, EjbJarProjectCreateData ejbJarProjectCreateData) throws IOException {
        Profile profile;
        if (!antProjectHelper.isSharableProject()) {
            return;
        }
        if (!ejbJarProjectCreateData.skipTests() && referenceHelper.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (!ejbJarProjectCreateData.skipTests() && referenceHelper.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        if (((profile = ejbJarProjectCreateData.getJavaEEProfile()).equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB)) && referenceHelper.getProjectLibraryManager().getLibrary("javaee-endorsed-api-6.0") == null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("javaee-endorsed-api-6.0"));
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)antProjectHelper, (ReferenceHelper)referenceHelper);
    }

    private static String configureServerLibrary(final String string, final String string2, final FileObject fileObject, boolean bl) {
        String string3 = null;
        if (string != null && bl) {
            try {
                string3 = (String)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                    public String run() throws Exception {
                        return SharabilityUtility.findOrCreateLibrary((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)fileObject), (String)string), (String)string2).getName();
                    }
                });
            }
            catch (MutexException mutexException) {
                Exceptions.printStackTrace((Throwable)mutexException.getException());
            }
        }
        return string3;
    }

    private static String createFileReference(ReferenceHelper referenceHelper, FileObject fileObject, FileObject fileObject2) {
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            return EjbJarProjectGenerator.relativePath(fileObject, fileObject2);
        }
        return referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject2), null);
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException("Cannot find relative path, " + fileObject + " is not parent of " + fileObject2);
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject fileObject, String string, String string2, String string3, File file, File file2, String string4, Profile profile, String string5, String string6, String string7, boolean bl) throws IOException {
        EditableProperties editableProperties;
        String string8;
        String[] stringArray;
        Element element;
        Element element2;
        Utils.logUI(NbBundle.getBundle(EjbJarProjectGenerator.class), "UI_EJB_PROJECT_CREATE_SHARABILITY", new Object[]{string6 != null, string7 != null});
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.j2ee.ejbjarproject", (String)string6);
        EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ReferenceHelper referenceHelper = ejbJarProject.getReferenceHelper();
        Element element3 = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element3.getOwnerDocument();
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
        element4.appendChild(document.createTextNode(string));
        element3.appendChild(element4);
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "minimum-ant-version");
        element5.appendChild(document.createTextNode(MINIMUM_ANT_VERSION));
        element3.appendChild(element5);
        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties3 = antProjectHelper.getProperties("nbproject/private/private.properties");
        Element element6 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
        if (string2 != null) {
            element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            element2.setAttribute("id", "src.dir");
            element2.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_src.dir"));
            element6.appendChild(element2);
            editableProperties2.setProperty("src.dir", string2);
        }
        element3.appendChild(element6);
        element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
        if (string3 != null) {
            element = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            element.setAttribute("id", "test.src.dir");
            element.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_test.src.dir"));
            element2.appendChild(element);
            editableProperties2.setProperty("test.src.dir", string3);
        }
        element3.appendChild(element2);
        antProjectHelper.putPrimaryConfigurationData(element3, true);
        if (string4 != null) {
            editableProperties2.setProperty("resource.dir", string4);
        } else {
            editableProperties2.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        }
        element = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion specificationVersion = element.getSpecification().getVersion();
        String string9 = specificationVersion.toString();
        if (string9.equals("1.7")) {
            string9 = "1.6";
        }
        editableProperties2.setProperty("javac.source", string9);
        editableProperties2.setProperty("javac.target", string9);
        editableProperties2.setProperty("dist.dir", "dist");
        editableProperties2.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        editableProperties2.setProperty("dist.ear.jar", "${dist.dir}/${jar.name}");
        editableProperties2.setProperty("j2ee.platform", profile.toPropertiesString());
        editableProperties2.setProperty("jar.name", PropertyUtils.getUsablePropertyName((String)string) + ".jar");
        editableProperties2.setProperty("jar.compress", "false");
        if (antProjectHelper.isSharableProject() && string7 != null) {
            editableProperties2.setProperty("javac.classpath", "${libs." + string7 + "." + "classpath" + "}");
        } else {
            editableProperties2.setProperty("javac.classpath", "");
        }
        J2EEProjectProperties.setServerProperties((EditableProperties)editableProperties2, (EditableProperties)editableProperties3, (String)string7, null, null, (String)string5, (Profile)profile, (J2eeModule.Type)J2eeModule.Type.EJB);
        editableProperties2.setProperty("j2ee.compile.on.save", "true");
        editableProperties2.setProperty("j2ee.deploy.on.save", DeployOnSaveUtils.isDeployOnSaveSupported((String)string5));
        editableProperties2.setProperty("javac.debug", "true");
        editableProperties2.setProperty("javac.deprecation", "false");
        if (bl) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "${javac.classpath}:";
            stringArray = stringArray2;
            stringArray2[1] = "${build.classes.dir}";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "${javac.classpath}:";
            stringArray3[1] = "${build.classes.dir}:";
            stringArray3[2] = "${libs.junit.classpath}:";
            stringArray = stringArray3;
            stringArray3[3] = "${libs.junit_4.classpath}";
        }
        editableProperties2.setProperty("javac.test.classpath", stringArray);
        editableProperties2.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        editableProperties2.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        editableProperties2.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties2.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        editableProperties2.setProperty("build.test.results.dir", "${build.dir}/test/results");
        editableProperties2.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties2.setProperty("build.classes.dir", "${build.dir}/classes");
        editableProperties2.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        editableProperties2.setProperty("build.ear.classes.dir", "${build.dir}/classes");
        editableProperties2.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        editableProperties2.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        editableProperties2.setProperty("platform.active", "default_platform");
        editableProperties2.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}");
        editableProperties2.setProperty("javadoc.private", "false");
        editableProperties2.setProperty("javadoc.notree", "false");
        editableProperties2.setProperty("javadoc.use", "true");
        editableProperties2.setProperty("javadoc.nonavbar", "false");
        editableProperties2.setProperty("javadoc.noindex", "false");
        editableProperties2.setProperty("javadoc.splitindex", "true");
        editableProperties2.setProperty("javadoc.author", "false");
        editableProperties2.setProperty("javadoc.version", "false");
        editableProperties2.setProperty("javadoc.windowtitle", "");
        editableProperties2.setProperty("javadoc.encoding", "${source.encoding}");
        editableProperties2.setProperty("javadoc.preview", "true");
        editableProperties2.setProperty("javadoc.additionalparam", "");
        editableProperties2.setProperty("runmain.jvmargs", "");
        editableProperties2.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties2.setProperty("source.encoding", charset.name());
        if (profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB)) {
            editableProperties2.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-6.0.classpath}"});
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
        if (file != null) {
            string8 = EjbJarProjectGenerator.createFileReference(referenceHelper, fileObject, FileUtil.toFileObject((File)file));
            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            editableProperties.setProperty("meta.inf", string8);
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
        if (file2 != null) {
            string8 = EjbJarProjectGenerator.createFileReference(referenceHelper, fileObject, FileUtil.toFileObject((File)file2));
            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            editableProperties.setProperty("lib.dir", string8);
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
        J2EEProjectProperties.createDeploymentScript((FileObject)fileObject, (EditableProperties)editableProperties2, (EditableProperties)editableProperties3, (String)string5, (J2eeModule.Type)J2eeModule.Type.EJB);
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties3);
        string8 = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject((Project)string8);
        return antProjectHelper;
    }

    public static void setPlatform(final AntProjectHelper antProjectHelper, final String string, final String string2) {
        FileObject fileObject = antProjectHelper.getProjectDirectory();
        if (fileObject == null) {
            return;
        }
        try {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
                                UpdateHelper updateHelper = ejbJarProject.getUpdateHelper();
                                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                                String string = string;
                                if (string == null) {
                                    string = JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
                                }
                                PlatformUiSupport.storePlatform((EditableProperties)editableProperties, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/j2ee-ejbjarproject/3", (String)string, (SpecificationVersion)(string2 != null ? new SpecificationVersion(string2) : null));
                                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                                ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory()));
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

